/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.lang.reflect.Method;

public class JfxHelper {
    private static final VersionID JRE_MINIMUM_VER = new VersionID("1.7.0_06");
    private static final String[] SUPPORTTED_OS = new String[]{"Windows", "Linux", "Mac OS X"};
    private static VersionID currentVersion = null;
    private static boolean detectionCompleted = false;

    public static boolean isCompatibleRuntime(JREInfo jREInfo, JREInfo jREInfo2) {
        if (jREInfo.getFXVersion() == null && jREInfo2.getFXVersion() == null) {
            return true;
        }
        return !jREInfo.getProductVersion().isGreaterThan(jREInfo2.getProductVersion()) && !jREInfo.getFXVersion().isGreaterThan(jREInfo2.getFXVersion());
    }

    public static boolean isJfxSupportSatisfied(ClassLoader classLoader, LaunchDesc launchDesc) {
        JavaFXRuntimeDesc javaFXRuntimeDesc = launchDesc.getJavaFXRuntimeDescriptor();
        if (null == javaFXRuntimeDesc && !launchDesc.isFXApp()) {
            return true;
        }
        String string = null == javaFXRuntimeDesc ? "2.2+" : javaFXRuntimeDesc.getVersion();
        return JfxHelper.isJfxSupportSatisfied(classLoader, string);
    }

    public static boolean isJfxSupportSatisfied(ClassLoader classLoader, String string) {
        if (null == string || string.length() == 0) {
            string = "2.2+";
        }
        VersionString versionString = new VersionString(string);
        VersionID versionID = JfxHelper.getCurrentJfxVersion(classLoader);
        return null == versionID ? false : versionString.contains(versionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionID getCurrentJfxVersion(ClassLoader classLoader) {
        if (detectionCompleted) return currentVersion;
        Class<JfxHelper> clazz = JfxHelper.class;
        synchronized (JfxHelper.class) {
            Object object;
            if (detectionCompleted) return currentVersion;
            try {
                if (null == classLoader) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                object = classLoader.loadClass("com.sun.javafx.runtime.VersionInfo");
                Method method = ((Class)object).getMethod("getVersion", null);
                String string = (String)method.invoke(null, null);
                currentVersion = new VersionID(string);
            }
            catch (Exception exception) {
                currentVersion = null;
            }
            if (null == currentVersion && (object = System.getProperty("jnlp.fx")) != null) {
                object = ((String)object).trim();
                currentVersion = new VersionID((String)object);
            }
            detectionCompleted = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return currentVersion;
        }
    }

    static void reset() {
        detectionCompleted = false;
    }

    public static boolean isSupportedJreVersion(VersionID versionID) {
        return !JRE_MINIMUM_VER.isGreaterThan(versionID);
    }

    public static boolean isSupportedOS(String string) {
        for (int i = 0; i < SUPPORTTED_OS.length; ++i) {
            if (SUPPORTTED_OS[i].indexOf(string) == -1) continue;
            return true;
        }
        return false;
    }

    public static void validateJfxRequest(LaunchDesc launchDesc, JREInfo jREInfo) throws LaunchDescException {
        if (!JfxHelper.isSupportedOS(jREInfo.getOSName())) {
            String string = ResourceManager.getString((String)"launch.error.jfx.os", (String)jREInfo.getOSName());
            throw new LaunchDescException(launchDesc, string, null);
        }
        VersionID versionID = jREInfo.getProductVersion();
        if (!JfxHelper.isSupportedJreVersion(versionID)) {
            String string = ResourceManager.getString((String)"launch.error.jfx.jre", (String)JRE_MINIMUM_VER.toString(), (String)versionID.toString());
            throw new LaunchDescException(launchDesc, string, null);
        }
    }

    public static void validateJfxRequest(LaunchDesc launchDesc, JREDesc jREDesc) throws LaunchDescException {
        VersionID versionID = new VersionID(jREDesc.getVersion());
        if (!JfxHelper.isSupportedJreVersion(versionID) && !versionID.match(JRE_MINIMUM_VER)) {
            String string = ResourceManager.getString((String)"launch.error.jfx.jre", (String)JRE_MINIMUM_VER.toString(), (String)versionID.toString());
            throw new LaunchDescException(launchDesc, string, null);
        }
    }
}

