/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaInternalFrameBorder;
import com.apple.laf.AquaLookAndFeel;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class AquaInternalFrameUI
extends BasicInternalFrameUI
implements SwingConstants {
    protected static final String IS_PALETTE_PROPERTY = "JInternalFrame.isPalette";
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    private static final String NORMAL_FRAME = "normal";
    private static final String PALETTE_FRAME = "palette";
    private static final String OPTION_DIALOG = "optionDialog";
    PropertyChangeListener fPropertyListener;
    protected Color fSelectedTextColor;
    protected Color fNotSelectedTextColor;
    AquaInternalFrameBorder fAquaBorder;
    private ResizeBox resizeBox;
    boolean fMouseOverPressedButton;
    int fWhichButtonPressed = -1;
    boolean fRollover = false;
    boolean fDocumentEdited = false;
    boolean fIsPallet;
    static final AquaUtils.RecyclableSingleton<Icon> closeIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX);
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> minimizeIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX);
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> zoomIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX);
        }
    };
    static final InternalFrameShadow documentWindowShadow = new InternalFrameShadow(){

        @Override
        Border getForegroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(0, 0, 0, 196));
                    graphics.fillRoundRect(n, n2, n3, n4, 16, 16);
                    graphics.fillRect(n, n2 + n4 - 16, n3, 16);
                }
            }, new AquaUtils.Painter(){

                @Override
                public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(0, 0, 0, 64));
                    graphics.drawLine(n + 2, n2 - 8, n + n3 - 2, n2 - 8);
                }
            }, 0, 7, 1.1f, 1.0f, 24, 51, 51, 25, 25, 25, 25);
        }

        @Override
        Border getBackgroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(0, 0, 0, 128));
                    graphics.fillRoundRect(n - 3, n2 - 8, n3 + 6, n4, 16, 16);
                    graphics.fillRect(n - 3, n2 + n4 - 20, n3 + 6, 19);
                }
            }, new AquaUtils.Painter(){

                @Override
                public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(0, 0, 0, 32));
                    graphics.drawLine(n, n2 - 11, n + n3 - 1, n2 - 11);
                }
            }, 0, 0, 3.0f, 1.0f, 10, 51, 51, 25, 25, 25, 25);
        }
    };
    static final InternalFrameShadow paletteWindowShadow = new InternalFrameShadow(){

        @Override
        Border getForegroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(0, 0, 0, 128));
                    graphics.fillRect(n, n2 + 3, n3, n4 - 3);
                }
            }, null, 0, 3, 1.0f, 1.0f, 10, 25, 25, 12, 12, 12, 12);
        }

        @Override
        Border getBackgroundShadowBorder() {
            return this.getForegroundShadowBorder();
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> RESIZE_ICON = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaIcon.ScalingJRSUIIcon(11, 11){

                @Override
                public void initIconPainter(AquaPainter<JRSUIState> aquaPainter) {
                    ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.GROW_BOX_TEXTURED);
                    ((JRSUIState)aquaPainter.state).set(JRSUIConstants.WindowType.UTILITY);
                }
            };
        }
    };

    public int getWhichButtonPressed() {
        return this.fWhichButtonPressed;
    }

    public boolean getMouseOverPressedButton() {
        return this.fMouseOverPressedButton;
    }

    public boolean getRollover() {
        return this.fRollover;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaInternalFrameUI((JInternalFrame)jComponent);
    }

    public AquaInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.frame.add((Component)this.frame.getRootPane(), "Center");
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        Object object = jComponent.getClientProperty(IS_PALETTE_PROPERTY);
        if (object != null) {
            this.setPalette((Boolean)object);
        } else {
            object = jComponent.getClientProperty(FRAME_TYPE);
            if (object != null) {
                this.setFrameType((String)object);
            } else {
                this.setFrameType(NORMAL_FRAME);
            }
        }
        this.frame.setMinimumSize(new Dimension(this.fIsPallet ? 120 : 150, this.fIsPallet ? 39 : 65));
        this.frame.setOpaque(false);
        jComponent.setBorder(new CompoundUIBorder(this.fIsPallet ? (Border)paletteWindowShadow.get() : (Border)documentWindowShadow.get(), jComponent.getBorder()));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.fSelectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.fNotSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    @Override
    public void setSouthPane(JComponent jComponent) {
        if (this.southPane != null) {
            this.frame.remove(this.southPane);
            this.deinstallMouseHandlers(this.southPane);
        }
        if (jComponent != null) {
            this.frame.add(jComponent);
            this.installMouseHandlers(jComponent);
        }
        this.southPane = jComponent;
    }

    public static Icon exportCloseIcon() {
        return closeIcon.get();
    }

    public static Icon exportMinimizeIcon() {
        return minimizeIcon.get();
    }

    public static Icon exportZoomIcon() {
        return zoomIcon.get();
    }

    @Override
    protected void installKeyboardActions() {
    }

    @Override
    protected void installComponents() {
        JLayeredPane jLayeredPane = this.frame.getLayeredPane();
        this.resizeBox = new ResizeBox(jLayeredPane);
        this.resizeBox.repositionResizeBox();
        jLayeredPane.add(this.resizeBox);
        jLayeredPane.setLayer(this.resizeBox, JLayeredPane.DRAG_LAYER);
        jLayeredPane.addComponentListener(this.resizeBox);
        this.resizeBox.addListeners();
        this.resizeBox.setVisible(this.frame.isResizable());
    }

    @Override
    protected void installListeners() {
        this.fPropertyListener = new PropertyListener();
        this.frame.addPropertyChangeListener(this.fPropertyListener);
        super.installListeners();
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        JLayeredPane jLayeredPane = this.frame.getLayeredPane();
        this.resizeBox.removeListeners();
        jLayeredPane.removeComponentListener(this.resizeBox);
        jLayeredPane.remove(this.resizeBox);
        this.resizeBox = null;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(this.fPropertyListener);
    }

    @Override
    protected void uninstallKeyboardActions() {
    }

    @Override
    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    @Override
    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        AquaLookAndFeel aquaLookAndFeel = (AquaLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = aquaLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        return actionMapUIResource;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        Dimension dimension2 = this.frame.getMinimumSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    @Override
    public void setNorthPane(JComponent jComponent) {
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    @Override
    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new AquaBorderListener();
    }

    void setFrameType(String string) {
        Color color = this.frame.getBackground();
        boolean bl = color == null || color instanceof UIResource;
        Font font = this.frame.getFont();
        boolean bl2 = font == null || font instanceof UIResource;
        boolean bl3 = false;
        if (string.equals(OPTION_DIALOG)) {
            this.fAquaBorder = AquaInternalFrameBorder.dialog();
            if (bl) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.optionDialogBackground"));
            }
            if (bl2) {
                this.frame.setFont(UIManager.getFont("InternalFrame.optionDialogTitleFont"));
            }
        } else if (string.equals(PALETTE_FRAME)) {
            this.fAquaBorder = AquaInternalFrameBorder.utility();
            if (bl) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.paletteBackground"));
            }
            if (bl2) {
                this.frame.setFont(UIManager.getFont("InternalFrame.paletteTitleFont"));
            }
            bl3 = true;
        } else {
            this.fAquaBorder = AquaInternalFrameBorder.window();
            if (bl) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.background"));
            }
            if (bl2) {
                this.frame.setFont(UIManager.getFont("InternalFrame.titleFont"));
            }
        }
        this.fAquaBorder.setColors(this.fSelectedTextColor, this.fNotSelectedTextColor);
        this.frame.setBorder(this.fAquaBorder);
        this.fIsPallet = bl3;
    }

    public void setPalette(boolean bl) {
        this.setFrameType(bl ? PALETTE_FRAME : NORMAL_FRAME);
    }

    public boolean isDocumentEdited() {
        return this.fDocumentEdited;
    }

    public void setDocumentEdited(boolean bl) {
        this.fDocumentEdited = bl;
    }

    static void updateComponentTreeUIActivation(Component component, Object object) {
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("Frame.active", object);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                AquaInternalFrameUI.updateComponentTreeUIActivation(component2, object);
            }
        }
    }

    private final class ResizeBox
    extends JLabel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    ComponentListener,
    PropertyChangeListener,
    UIResource {
        private final JLayeredPane layeredPane;
        private Dimension originalSize;
        private Point originalLocation;

        ResizeBox(JLayeredPane jLayeredPane) {
            super(RESIZE_ICON.get());
            this.setSize(11, 11);
            this.layeredPane = jLayeredPane;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        void addListeners() {
            AquaInternalFrameUI.this.frame.addPropertyChangeListener("resizable", this);
        }

        void removeListeners() {
            AquaInternalFrameUI.this.frame.removePropertyChangeListener("resizable", this);
        }

        void repositionResizeBox() {
            if (AquaInternalFrameUI.this.frame == null) {
                this.setSize(0, 0);
            } else {
                this.setSize(11, 11);
            }
            this.setLocation(this.layeredPane.getWidth() - 12, this.layeredPane.getHeight() - 12);
        }

        void resizeInternalFrame(Point point) {
            if (this.originalLocation == null || AquaInternalFrameUI.this.frame == null) {
                return;
            }
            Container container = AquaInternalFrameUI.this.frame.getParent();
            if (!(container instanceof JDesktopPane)) {
                return;
            }
            Point point2 = SwingUtilities.convertPoint(this, point, AquaInternalFrameUI.this.frame);
            int n = this.originalLocation.x - point2.x;
            int n2 = this.originalLocation.y - point2.y;
            Dimension dimension = AquaInternalFrameUI.this.frame.getMinimumSize();
            Dimension dimension2 = AquaInternalFrameUI.this.frame.getMaximumSize();
            int n3 = AquaInternalFrameUI.this.frame.getX();
            int n4 = AquaInternalFrameUI.this.frame.getY();
            int n5 = AquaInternalFrameUI.this.frame.getWidth();
            int n6 = AquaInternalFrameUI.this.frame.getHeight();
            Rectangle rectangle = container.getBounds();
            if (this.originalSize.width - n < dimension.width) {
                n = this.originalSize.width - dimension.width;
            } else if (this.originalSize.width - n > dimension2.width) {
                n = -(dimension2.width - this.originalSize.width);
            }
            if (n3 + this.originalSize.width - n > rectangle.width) {
                n = n3 + this.originalSize.width - rectangle.width;
            }
            if (this.originalSize.height - n2 < dimension.height) {
                n2 = this.originalSize.height - dimension.height;
            } else if (this.originalSize.height - n2 > dimension2.height) {
                n2 = -(dimension2.height - this.originalSize.height);
            }
            if (n4 + this.originalSize.height - n2 > rectangle.height) {
                n2 = n4 + this.originalSize.height - rectangle.height;
            }
            n5 = this.originalSize.width - n;
            n6 = this.originalSize.height - n2;
            AquaInternalFrameUI.this.getDesktopManager().resizeFrame(AquaInternalFrameUI.this.frame, n3, n4, n5, n6);
        }

        boolean testGrowboxPoint(int n, int n2, int n3, int n4) {
            return n3 - n + (n4 - n2) < 12;
        }

        void forwardEventToFrame(MouseEvent mouseEvent) {
            Point point = new Point();
            Component component = this.getComponentToForwardTo(mouseEvent, point);
            if (component == null) {
                return;
            }
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }

        Component getComponentToForwardTo(MouseEvent mouseEvent, Point point) {
            if (AquaInternalFrameUI.this.frame == null) {
                return null;
            }
            Container container = AquaInternalFrameUI.this.frame.getContentPane();
            if (container == null) {
                return null;
            }
            Point point2 = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), container);
            Component component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
            if (component == null) {
                return null;
            }
            point2 = SwingUtilities.convertPoint(container, point2, component);
            if (point != null) {
                point.setLocation(point2);
            }
            return component;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.forwardEventToFrame(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AquaInternalFrameUI.this.frame == null) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isResizable() && !AquaInternalFrameUI.this.frame.isMaximum() && this.testGrowboxPoint(mouseEvent.getX(), mouseEvent.getY(), this.getWidth(), this.getHeight())) {
                this.originalLocation = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), AquaInternalFrameUI.this.frame);
                this.originalSize = AquaInternalFrameUI.this.frame.getSize();
                AquaInternalFrameUI.this.getDesktopManager().beginResizingFrame(AquaInternalFrameUI.this.frame, 4);
                return;
            }
            this.forwardEventToFrame(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.originalLocation != null) {
                this.resizeInternalFrame(mouseEvent.getPoint());
                this.originalLocation = null;
                AquaInternalFrameUI.this.getDesktopManager().endResizingFrame(AquaInternalFrameUI.this.frame);
                return;
            }
            this.forwardEventToFrame(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.resizeInternalFrame(mouseEvent.getPoint());
            this.repositionResizeBox();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Point point = new Point();
            Component component = this.getComponentToForwardTo(mouseWheelEvent, point);
            if (component == null) {
                return;
            }
            component.dispatchEvent(new MouseWheelEvent(component, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.repositionResizeBox();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.repositionResizeBox();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.repositionResizeBox();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"resizable".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            this.setVisible(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
        }
    }

    static abstract class InternalFrameShadow
    extends AquaUtils.RecyclableSingleton<Border> {
        InternalFrameShadow() {
        }

        abstract Border getForegroundShadowBorder();

        abstract Border getBackgroundShadowBorder();

        @Override
        protected Border getInstance() {
            final Border border = this.getForegroundShadowBorder();
            final Border border2 = this.getBackgroundShadowBorder();
            return new Border(){

                @Override
                public Insets getBorderInsets(Component component) {
                    return border.getBorderInsets(component);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    if (((JInternalFrame)component).isSelected()) {
                        border.paintBorder(component, graphics, n, n2, n3, n4);
                    } else {
                        border2.paintBorder(component, graphics, n, n2, n3, n4);
                    }
                }
            };
        }
    }

    static class CompoundUIBorder
    extends CompoundBorder
    implements UIResource {
        public CompoundUIBorder(Border border, Border border2) {
            super(border, border2);
        }
    }

    class PropertyListener
    implements PropertyChangeListener {
        PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (AquaInternalFrameUI.FRAME_TYPE.equals(string)) {
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    AquaInternalFrameUI.this.setFrameType((String)propertyChangeEvent.getNewValue());
                }
            } else if (AquaInternalFrameUI.IS_PALETTE_PROPERTY.equals(string)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    AquaInternalFrameUI.this.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    AquaInternalFrameUI.this.setPalette(false);
                }
            } else if ("windowModified".equals(string) || "Window.documentModified".equals(string)) {
                AquaInternalFrameUI.this.setDocumentEdited((Boolean)propertyChangeEvent.getNewValue());
                AquaInternalFrameUI.this.frame.repaint(0, 0, AquaInternalFrameUI.this.frame.getWidth(), ((AquaInternalFrameUI)AquaInternalFrameUI.this).frame.getBorder().getBorderInsets((Component)((AquaInternalFrameUI)AquaInternalFrameUI.this).frame).top);
            } else if ("resizable".equals(string) || "state".equals(string) || "iconable".equals(string) || "maximizable".equals(string) || "closable".equals(string)) {
                if ("resizable".equals(string)) {
                    AquaInternalFrameUI.this.frame.revalidate();
                }
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("title".equals(string)) {
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("componentOrientation".equals(string)) {
                AquaInternalFrameUI.this.frame.revalidate();
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("selected".equals(string)) {
                Component component = (Component)propertyChangeEvent.getSource();
                AquaInternalFrameUI.updateComponentTreeUIActivation(component, AquaInternalFrameUI.this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    protected class AquaBorderListener
    extends MouseInputAdapter {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        boolean fDraggingFrame;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        boolean isTryingToForwardEvent = false;

        protected AquaBorderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.didForwardEvent(mouseEvent)) {
                return;
            }
            if (mouseEvent.getClickCount() <= 1 || mouseEvent.getSource() != AquaInternalFrameUI.this.getNorthPane()) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isIconifiable() && AquaInternalFrameUI.this.frame.isIcon()) {
                try {
                    AquaInternalFrameUI.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (AquaInternalFrameUI.this.frame.isMaximizable()) {
                if (!AquaInternalFrameUI.this.frame.isMaximum()) {
                    try {
                        AquaInternalFrameUI.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        AquaInternalFrameUI.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public void updateRollover(MouseEvent mouseEvent) {
            boolean bl = AquaInternalFrameUI.this.fRollover;
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            boolean bl2 = AquaInternalFrameUI.this.fRollover = this.isTitleBarDraggableArea(mouseEvent) && AquaInternalFrameUI.this.fAquaBorder.getWithinRolloverArea(insets, mouseEvent.getX(), mouseEvent.getY());
            if (AquaInternalFrameUI.this.fRollover != bl) {
                this.repaintButtons();
            }
        }

        public void repaintButtons() {
            AquaInternalFrameUI.this.fAquaBorder.repaintButtonArea(AquaInternalFrameUI.this.frame);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.didForwardEvent(mouseEvent)) {
                return;
            }
            this.fDraggingFrame = false;
            if (AquaInternalFrameUI.this.fWhichButtonPressed != -1) {
                int n = AquaInternalFrameUI.this.fAquaBorder.getWhichButtonHit(AquaInternalFrameUI.this.frame, mouseEvent.getX(), mouseEvent.getY());
                int n2 = AquaInternalFrameUI.this.fWhichButtonPressed;
                AquaInternalFrameUI.this.fWhichButtonPressed = -1;
                AquaInternalFrameUI.this.fMouseOverPressedButton = false;
                if (n2 == n) {
                    AquaInternalFrameUI.this.fMouseOverPressedButton = false;
                    AquaInternalFrameUI.this.fRollover = false;
                    AquaInternalFrameUI.this.fAquaBorder.doButtonAction(AquaInternalFrameUI.this.frame, n2);
                }
                this.updateRollover(mouseEvent);
                this.repaintButtons();
                return;
            }
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                AquaInternalFrameUI.this.getDesktopManager().endDraggingFrame(AquaInternalFrameUI.this.frame);
            } else {
                Container container = AquaInternalFrameUI.this.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)AquaInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JFrame)AquaInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                AquaInternalFrameUI.this.getDesktopManager().endResizingFrame(AquaInternalFrameUI.this.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.didForwardEvent(mouseEvent)) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = AquaInternalFrameUI.this.frame.getBounds();
            this.resizeDir = 0;
            if (this.updatePressed(mouseEvent)) {
                return;
            }
            if (!AquaInternalFrameUI.this.frame.isSelected()) {
                try {
                    AquaInternalFrameUI.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (this.isTitleBarDraggableArea(mouseEvent)) {
                AquaInternalFrameUI.this.getDesktopManager().beginDraggingFrame(AquaInternalFrameUI.this.frame);
                this.fDraggingFrame = true;
                return;
            }
            if (mouseEvent.getSource() == AquaInternalFrameUI.this.getNorthPane()) {
                AquaInternalFrameUI.this.getDesktopManager().beginDraggingFrame(AquaInternalFrameUI.this.frame);
                return;
            }
            if (!AquaInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == AquaInternalFrameUI.this.frame) {
                this.discardRelease = true;
                return;
            }
        }

        public boolean updatePressed(MouseEvent mouseEvent) {
            AquaInternalFrameUI.this.fWhichButtonPressed = this.getButtonHit(mouseEvent);
            AquaInternalFrameUI.this.fMouseOverPressedButton = true;
            this.repaintButtons();
            return AquaInternalFrameUI.this.fWhichButtonPressed >= 0;
        }

        public int getButtonHit(MouseEvent mouseEvent) {
            return AquaInternalFrameUI.this.fAquaBorder.getWhichButtonHit(AquaInternalFrameUI.this.frame, mouseEvent.getX(), mouseEvent.getY());
        }

        public boolean isTitleBarDraggableArea(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() != AquaInternalFrameUI.this.frame) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            if (point.y < insets.top - AquaInternalFrameUI.this.fAquaBorder.getTitleHeight()) {
                return false;
            }
            if (point.y > insets.top) {
                return false;
            }
            if (point.x < insets.left) {
                return false;
            }
            return point.x <= AquaInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startingBounds == null) {
                return;
            }
            if (AquaInternalFrameUI.this.fWhichButtonPressed != -1) {
                int n = this.getButtonHit(mouseEvent);
                AquaInternalFrameUI.this.fMouseOverPressedButton = AquaInternalFrameUI.this.fWhichButtonPressed == n;
                this.repaintButtons();
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            int n = this._x - point.x;
            int n2 = this._y - point.y;
            if (!this.fDraggingFrame && mouseEvent.getSource() != AquaInternalFrameUI.this.getNorthPane()) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isMaximum() || (mouseEvent.getModifiers() & 0x10) != 16) {
                return;
            }
            Dimension dimension = AquaInternalFrameUI.this.frame.getParent().getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            int n5 = this.startingBounds.x - n;
            int n6 = this.startingBounds.y - n2;
            if (n5 + insets.left <= -this.__x) {
                n5 = -this.__x - insets.left;
            }
            if (n6 + insets.top <= -this.__y) {
                n6 = -this.__y - insets.top;
            }
            if (n5 + this.__x + insets.right > n3) {
                n5 = n3 - this.__x - insets.right;
            }
            if (n6 + this.__y + insets.bottom > n4) {
                n6 = n4 - this.__y - insets.bottom;
            }
            AquaInternalFrameUI.this.getDesktopManager().dragFrame(AquaInternalFrameUI.this.frame, n5, n6);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.didForwardEvent(mouseEvent)) {
                return;
            }
            this.updateRollover(mouseEvent);
        }

        boolean didForwardEvent(MouseEvent mouseEvent) {
            if (this.isTryingToForwardEvent) {
                return true;
            }
            this.isTryingToForwardEvent = true;
            boolean bl = this.didForwardEventInternal(mouseEvent);
            this.isTryingToForwardEvent = false;
            return bl;
        }

        boolean didForwardEventInternal(MouseEvent mouseEvent) {
            if (this.fDraggingFrame) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            if (!this.isEventInWindowShadow(point)) {
                return false;
            }
            Container container = AquaInternalFrameUI.this.frame.getParent();
            if (!(container instanceof JDesktopPane)) {
                return false;
            }
            JDesktopPane jDesktopPane = (JDesktopPane)container;
            Point point2 = SwingUtilities.convertPoint(AquaInternalFrameUI.this.frame, point, container);
            Component component = this.findComponentToHitBehindMe(jDesktopPane, point2);
            if (component == null || component == AquaInternalFrameUI.this.frame) {
                return false;
            }
            Point point3 = SwingUtilities.convertPoint(jDesktopPane, point2, component);
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            return true;
        }

        Component findComponentToHitBehindMe(JDesktopPane jDesktopPane, Point point) {
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            boolean bl = false;
            for (JInternalFrame jInternalFrame : jInternalFrameArray) {
                Rectangle rectangle;
                if (jInternalFrame == AquaInternalFrameUI.this.frame) {
                    bl = true;
                    continue;
                }
                if (!bl || !(rectangle = jInternalFrame.getBounds()).contains(point)) continue;
                return jInternalFrame;
            }
            return jDesktopPane;
        }

        boolean isEventInWindowShadow(Point point) {
            Rectangle rectangle = AquaInternalFrameUI.this.frame.getBounds();
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            insets.top -= AquaInternalFrameUI.this.fAquaBorder.getTitleHeight();
            if (point.x < insets.left) {
                return true;
            }
            if (point.x > rectangle.width - insets.right) {
                return true;
            }
            if (point.y < insets.top) {
                return true;
            }
            return point.y > rectangle.height - insets.bottom;
        }
    }

    static class AquaInternalFrameButtonIcon
    extends AquaIcon.JRSUIIcon {
        public AquaInternalFrameButtonIcon(JRSUIConstants.Widget widget) {
            ((JRSUIState)this.painter.state).set(widget);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ((JRSUIState)this.painter.state).set(this.getStateFor(component));
            super.paintIcon(component, graphics, n, n2);
        }

        JRSUIConstants.State getStateFor(Component component) {
            return JRSUIConstants.State.ROLLOVER;
        }

        @Override
        public int getIconWidth() {
            return 19;
        }

        @Override
        public int getIconHeight() {
            return 19;
        }
    }
}

