/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.w3c.dom.Document;

public final class MessageDigestAlgorithm
extends Algorithm {
    public static final String ALGO_ID_DIGEST_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String ALGO_ID_DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String ALGO_ID_DIGEST_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#sha224";
    public static final String ALGO_ID_DIGEST_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String ALGO_ID_DIGEST_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String ALGO_ID_DIGEST_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ALGO_ID_DIGEST_RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String ALGO_ID_DIGEST_WHIRLPOOL = "http://www.w3.org/2007/05/xmldsig-more#whirlpool";
    public static final String ALGO_ID_DIGEST_SHA3_224 = "http://www.w3.org/2007/05/xmldsig-more#sha3-224";
    public static final String ALGO_ID_DIGEST_SHA3_256 = "http://www.w3.org/2007/05/xmldsig-more#sha3-256";
    public static final String ALGO_ID_DIGEST_SHA3_384 = "http://www.w3.org/2007/05/xmldsig-more#sha3-384";
    public static final String ALGO_ID_DIGEST_SHA3_512 = "http://www.w3.org/2007/05/xmldsig-more#sha3-512";
    private final MessageDigest algorithm;

    private MessageDigestAlgorithm(Document document, String string) throws XMLSignatureException {
        super(document, string);
        this.algorithm = MessageDigestAlgorithm.getDigestInstance(string);
    }

    public static MessageDigestAlgorithm getInstance(Document document, String string) throws XMLSignatureException {
        return new MessageDigestAlgorithm(document, string);
    }

    public static MessageDigest getDigestInstance(String string) throws XMLSignatureException {
        MessageDigest messageDigest;
        String string2 = JCEMapper.translateURItoJCEID(string);
        if (string2 == null) {
            Object[] objectArray = new Object[]{string};
            throw new XMLSignatureException("algorithms.NoSuchMap", objectArray);
        }
        String string3 = JCEMapper.getProviderId();
        try {
            messageDigest = string3 == null ? MessageDigest.getInstance(string2) : MessageDigest.getInstance(string2, string3);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            Object[] objectArray = new Object[]{string2, generalSecurityException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        return messageDigest;
    }

    public MessageDigest getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return MessageDigest.isEqual(byArray, byArray2);
    }

    public byte[] digest() {
        return this.algorithm.digest();
    }

    public byte[] digest(byte[] byArray) {
        return this.algorithm.digest(byArray);
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.algorithm.digest(byArray, n, n2);
    }

    public String getJCEAlgorithmString() {
        return this.algorithm.getAlgorithm();
    }

    public Provider getJCEProvider() {
        return this.algorithm.getProvider();
    }

    public int getDigestLength() {
        return this.algorithm.getDigestLength();
    }

    public void reset() {
        this.algorithm.reset();
    }

    public void update(byte[] byArray) {
        this.algorithm.update(byArray);
    }

    public void update(byte by) {
        this.algorithm.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.algorithm.update(byArray, n, n2);
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    @Override
    public String getBaseLocalName() {
        return "DigestMethod";
    }
}

