/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayOutputStream;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(DigesterOutputStream.class);
    final MessageDigestAlgorithm mda;

    public DigesterOutputStream(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.mda = messageDigestAlgorithm;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(int n) {
        this.mda.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pre-digested input:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            LOG.debug(stringBuilder.toString());
        }
        this.mda.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

