/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.lang.ref.Reference;

public class BeanDescriptor
extends FeatureDescriptor {
    private Reference<? extends Class<?>> beanClassRef;
    private Reference<? extends Class<?>> customizerClassRef;

    public BeanDescriptor(Class<?> clazz) {
        this(clazz, null);
    }

    public BeanDescriptor(Class<?> clazz, Class<?> clazz2) {
        this.beanClassRef = BeanDescriptor.getWeakReference(clazz);
        this.customizerClassRef = BeanDescriptor.getWeakReference(clazz2);
        String string = clazz.getName();
        while (string.indexOf(46) >= 0) {
            string = string.substring(string.indexOf(46) + 1);
        }
        this.setName(string);
    }

    public Class<?> getBeanClass() {
        return this.beanClassRef != null ? this.beanClassRef.get() : null;
    }

    public Class<?> getCustomizerClass() {
        return this.customizerClassRef != null ? this.customizerClassRef.get() : null;
    }

    BeanDescriptor(BeanDescriptor beanDescriptor) {
        super(beanDescriptor);
        this.beanClassRef = beanDescriptor.beanClassRef;
        this.customizerClassRef = beanDescriptor.customizerClassRef;
    }

    @Override
    void appendTo(StringBuilder stringBuilder) {
        BeanDescriptor.appendTo(stringBuilder, "beanClass", this.beanClassRef);
        BeanDescriptor.appendTo(stringBuilder, "customizerClass", this.customizerClassRef);
    }
}

