/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleBundle;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CAccessible;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;

class CAccessibility
implements PropertyChangeListener {
    private static Set<String> ignoredRoles;
    static CAccessibility sAccessibility;
    private static final Field FIELD_KEY;
    static final int JAVA_AX_ALL_CHILDREN = -1;
    static final int JAVA_AX_SELECTED_CHILDREN = -2;
    static final int JAVA_AX_VISIBLE_CHILDREN = -3;
    private static final int JAVA_AX_ROWS = 1;
    private static final int JAVA_AX_COLS = 2;

    static synchronized CAccessibility getAccessibility(String[] stringArray) {
        if (sAccessibility != null) {
            return sAccessibility;
        }
        sAccessibility = new CAccessibility();
        if (stringArray != null) {
            ignoredRoles = new HashSet<String>(stringArray.length);
            for (String string : stringArray) {
                ignoredRoles.add(string);
            }
        } else {
            ignoredRoles = new HashSet<String>();
        }
        return sAccessibility;
    }

    private CAccessibility() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AccessibleContext accessibleContext;
        AccessibleRole accessibleRole;
        Object object = propertyChangeEvent.getNewValue();
        if (object == null) {
            return;
        }
        if (object instanceof Accessible && !ignoredRoles.contains(CAccessibility.roleKey(accessibleRole = (accessibleContext = ((Accessible)object).getAccessibleContext()).getAccessibleRole()))) {
            this.focusChanged();
        }
    }

    private native void focusChanged();

    static <T> T invokeAndWait(Callable<T> callable, Component component) {
        return CAccessibility.invokeAndWait(callable, component, null);
    }

    static <T> T invokeAndWait(Callable<T> callable, Component component, T t) {
        T t2 = null;
        try {
            t2 = LWCToolkit.invokeAndWait(callable, component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return t2 != null ? t2 : (T)t;
    }

    static void invokeLater(Runnable runnable, Component component) {
        try {
            LWCToolkit.invokeLater(runnable, component);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static String getAccessibleActionDescription(final AccessibleAction accessibleAction, final int n, Component component) {
        if (accessibleAction == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return accessibleAction.getAccessibleActionDescription(n);
            }
        }, component);
    }

    public static void doAccessibleAction(final AccessibleAction accessibleAction, final int n, Component component) {
        if (accessibleAction == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                accessibleAction.doAccessibleAction(n);
            }
        }, component);
    }

    public static Dimension getSize(final AccessibleComponent accessibleComponent, Component component) {
        if (accessibleComponent == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Dimension>(){

            @Override
            public Dimension call() throws Exception {
                return accessibleComponent.getSize();
            }
        }, component);
    }

    public static AccessibleSelection getAccessibleSelection(final AccessibleContext accessibleContext, Component component) {
        if (accessibleContext == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleSelection>(){

            @Override
            public AccessibleSelection call() throws Exception {
                return accessibleContext.getAccessibleSelection();
            }
        }, component);
    }

    public static Accessible ax_getAccessibleSelection(final AccessibleContext accessibleContext, final int n, Component component) {
        if (accessibleContext == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return null;
                }
                return accessibleSelection.getAccessibleSelection(n);
            }
        }, component);
    }

    public static void addAccessibleSelection(final AccessibleContext accessibleContext, final int n, Component component) {
        if (accessibleContext == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return;
                }
                accessibleSelection.addAccessibleSelection(n);
            }
        }, component);
    }

    public static AccessibleContext getAccessibleContext(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return accessible.getAccessibleContext();
            }
        }, component);
    }

    public static boolean isAccessibleChildSelected(final Accessible accessible, final int n, Component component) {
        if (accessible == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return Boolean.FALSE;
                }
                AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(accessibleSelection.isAccessibleChildSelected(n));
            }
        }, component, false);
    }

    public static AccessibleStateSet getAccessibleStateSet(final AccessibleContext accessibleContext, Component component) {
        if (accessibleContext == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleStateSet>(){

            @Override
            public AccessibleStateSet call() throws Exception {
                return accessibleContext.getAccessibleStateSet();
            }
        }, component);
    }

    public static boolean contains(final AccessibleContext accessibleContext, final AccessibleState accessibleState, Component component) {
        if (accessibleContext == null || accessibleState == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                if (accessibleStateSet == null) {
                    return null;
                }
                return accessibleStateSet.contains(accessibleState);
            }
        }, component, false);
    }

    static Field getAccessibleBundleKeyFieldWithReflection() {
        try {
            Field field = AccessibleBundle.class.getDeclaredField("key");
            field.setAccessible(true);
            return field;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return null;
    }

    static String getAccessibleRoleFor(Accessible accessible) {
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
        try {
            return (String)FIELD_KEY.get(accessibleRole);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public static String getAccessibleRole(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
                String string = CAccessibility.getAccessibleRoleFor(accessible);
                if (!"text".equals(string)) {
                    return string;
                }
                if (accessible2 instanceof JTextArea || accessible2 instanceof JEditorPane) {
                    return "textarea";
                }
                return string;
            }
        }, component);
    }

    public static Point getLocationOnScreen(final AccessibleComponent accessibleComponent, Component component) {
        if (accessibleComponent == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Point>(){

            @Override
            public Point call() throws Exception {
                return accessibleComponent.getLocationOnScreen();
            }
        }, component);
    }

    public static int getCharCount(final AccessibleText accessibleText, Component component) {
        if (accessibleText == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleText.getCharCount();
            }
        }, component, 0);
    }

    public static Accessible getAccessibleParent(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                return accessibleContext.getAccessibleParent();
            }
        }, component);
    }

    public static int getAccessibleIndexInParent(final Accessible accessible, Component component) {
        if (accessible == null) {
            return -1;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                return accessibleContext.getAccessibleIndexInParent();
            }
        }, component, -1);
    }

    public static AccessibleComponent getAccessibleComponent(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleComponent>(){

            @Override
            public AccessibleComponent call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                return accessibleContext.getAccessibleComponent();
            }
        }, component);
    }

    public static AccessibleValue getAccessibleValue(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleValue>(){

            @Override
            public AccessibleValue call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                return accessibleValue;
            }
        }, component);
    }

    public static String getAccessibleName(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                String string = accessibleContext.getAccessibleName();
                if (string == null) {
                    return accessibleContext.getAccessibleDescription();
                }
                String string2 = CAccessibility.getAcceleratorText(accessibleContext);
                if (!string2.isEmpty()) {
                    return string + ' ' + string2;
                }
                return string;
            }
        }, component);
    }

    public static AccessibleText getAccessibleText(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleText>(){

            @Override
            public AccessibleText call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                return accessibleText;
            }
        }, component);
    }

    private static String getAcceleratorText(AccessibleContext accessibleContext) {
        String string = "";
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible != null) {
            JMenuItem jMenuItem;
            KeyStroke keyStroke;
            int n = accessibleContext.getAccessibleIndexInParent();
            Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
            if (accessible2 instanceof JMenuItem && (keyStroke = (jMenuItem = (JMenuItem)accessible2).getAccelerator()) != null) {
                int n2;
                int n3 = keyStroke.getModifiers();
                if (n3 > 0) {
                    string = KeyEvent.getKeyModifiersText(n3);
                }
                string = (n2 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n2) : string + keyStroke.getKeyChar();
            }
        }
        return string;
    }

    public static String getAccessibleDescription(final Accessible accessible, final Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string;
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                String string2 = accessibleContext.getAccessibleDescription();
                if (string2 == null && component instanceof JComponent && (string = ((JComponent)component).getToolTipText()) != null) {
                    return string;
                }
                return string2;
            }
        }, component);
    }

    public static boolean isFocusTraversable(final Accessible accessible, Component component) {
        if (accessible == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return null;
                }
                return accessibleComponent.isFocusTraversable();
            }
        }, component, false);
    }

    public static Accessible accessibilityHitTest(final Container container, final float f, final float f2) {
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                Point point = container.getLocationOnScreen();
                Point point2 = new Point((int)((double)f - point.getX()), (int)((double)f2 - point.getY()));
                Component component = container.findComponentAt(point2);
                if (component == null) {
                    return null;
                }
                AccessibleContext accessibleContext = component.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return null;
                }
                int n = accessibleContext.getAccessibleChildrenCount();
                if (n > 0) {
                    Point point3 = accessibleComponent.getLocationOnScreen();
                    Point point4 = new Point((int)((double)f - point3.getX()), (int)((double)f2 - point3.getY()));
                    return CAccessible.getCAccessible(accessibleComponent.getAccessibleAt(point4));
                }
                if (!(component instanceof Accessible)) {
                    return null;
                }
                return CAccessible.getCAccessible((Accessible)((Object)component));
            }
        }, container);
    }

    public static AccessibleAction getAccessibleAction(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleAction>(){

            @Override
            public AccessibleAction call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                return accessibleContext.getAccessibleAction();
            }
        }, component);
    }

    public static boolean isEnabled(final Accessible accessible, Component component) {
        if (accessible == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return null;
                }
                return accessibleComponent.isEnabled();
            }
        }, component, false);
    }

    public static void requestFocus(final Accessible accessible, Component component) {
        if (accessible == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return;
                }
                accessibleComponent.requestFocus();
            }
        }, component);
    }

    public static void requestSelection(final Accessible accessible, Component component) {
        if (accessible == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return;
                }
                int n = accessibleContext.getAccessibleIndexInParent();
                if (n == -1) {
                    return;
                }
                Accessible accessible2 = accessibleContext.getAccessibleParent();
                AccessibleContext accessibleContext2 = accessible2.getAccessibleContext();
                if (accessibleContext2 == null) {
                    return;
                }
                AccessibleSelection accessibleSelection = accessibleContext2.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return;
                }
                if (accessible2 instanceof JList) {
                    ((JList)accessible2).setSelectedIndex(n);
                    return;
                }
                accessibleSelection.addAccessibleSelection(n);
            }
        }, component);
    }

    public static Number getMaximumAccessibleValue(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue == null) {
                    return null;
                }
                return accessibleValue.getMaximumAccessibleValue();
            }
        }, component);
    }

    public static Number getMinimumAccessibleValue(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue == null) {
                    return null;
                }
                return accessibleValue.getMinimumAccessibleValue();
            }
        }, component);
    }

    public static String getAccessibleRoleDisplayString(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                if (accessibleRole == null) {
                    return null;
                }
                return accessibleRole.toDisplayString();
            }
        }, component);
    }

    public static boolean setCurrentAccessibleValue(final Accessible accessible, Component component, final Number number) {
        if (accessible == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue == null) {
                    return null;
                }
                return accessibleValue.setCurrentAccessibleValue(number);
            }
        }, component, false);
    }

    public static Number getCurrentAccessibleValue(final AccessibleValue accessibleValue, Component component) {
        if (accessibleValue == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                Number number = accessibleValue.getCurrentAccessibleValue();
                return number;
            }
        }, component);
    }

    public static Accessible getFocusOwner(Component component) {
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component == null || !(component instanceof Accessible)) {
                    return null;
                }
                return CAccessible.getCAccessible((Accessible)((Object)component));
            }
        }, component);
    }

    public static boolean[] getInitialAttributeStates(final Accessible accessible, Component component) {
        final boolean[] blArray = new boolean[7];
        if (accessible == null) {
            return blArray;
        }
        return CAccessibility.invokeAndWait(new Callable<boolean[]>(){

            @Override
            public boolean[] call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return blArray;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                blArray[0] = accessibleComponent != null;
                blArray[1] = accessibleComponent != null && accessibleComponent.isFocusTraversable();
                blArray[2] = accessibleContext.getAccessibleValue() != null;
                blArray[3] = accessibleContext.getAccessibleText() != null;
                AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                blArray[4] = accessibleStateSet.contains(AccessibleState.HORIZONTAL) || accessibleStateSet.contains(AccessibleState.VERTICAL);
                blArray[5] = accessibleContext.getAccessibleName() != null;
                blArray[6] = accessibleContext.getAccessibleChildrenCount() > 0;
                return blArray;
            }
        }, component);
    }

    private static Object[] getTableRowChildrenAndRoles(Accessible accessible, Component component, int n, boolean bl, int n2) {
        return CAccessibility.invokeGetChildrenAndRoles(accessible, component, n, bl, ChildrenOperations.createForTableRow(n2));
    }

    private static Object[] getChildrenAndRoles(Accessible accessible, Component component, int n, boolean bl) {
        return CAccessibility.invokeGetChildrenAndRoles(accessible, component, n, bl, ChildrenOperations.COMMON);
    }

    private static Object[] invokeGetChildrenAndRoles(final Accessible accessible, final Component component, final int n, final boolean bl, final ChildrenOperations childrenOperations) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return CAccessibility.getChildrenAndRolesImpl(accessible, component, n, bl, childrenOperations);
            }
        }, component);
    }

    private static Object[] getChildrenAndRolesImpl(Accessible accessible, Component component, int n, boolean bl, ChildrenOperations childrenOperations) {
        AccessibleContext accessibleContext;
        if (accessible == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CAccessibility._addChildren(accessible, n, bl, arrayList, childrenOperations);
        if (n == -2 && !arrayList.isEmpty() && (accessibleContext = CAccessible.getActiveDescendant(accessible)) != null) {
            String string = accessibleContext.getAccessibleName();
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n2 = arrayList.size();
            Accessible accessible2 = null;
            AccessibleContext accessibleContext2 = null;
            String string2 = null;
            AccessibleRole accessibleRole2 = null;
            for (int i = 0; i < n2; i += 2) {
                accessible2 = (Accessible)arrayList.get(i);
                accessibleContext2 = accessible2.getAccessibleContext();
                string2 = accessibleContext2.getAccessibleName();
                accessibleRole2 = (AccessibleRole)arrayList.get(i + 1);
                if (string2 != null && string2.equals(string) && accessibleRole2.equals(accessibleRole)) {
                    arrayList2.add(0, accessible2);
                    arrayList2.add(1, accessibleRole2);
                    continue;
                }
                arrayList2.add(accessible2);
                arrayList2.add(accessibleRole2);
            }
            arrayList = arrayList2;
        }
        if (n < 0 || n * 2 >= arrayList.size()) {
            return arrayList.toArray();
        }
        return new Object[]{arrayList.get(n * 2), arrayList.get(n * 2 + 1)};
    }

    private static Object[] getChildrenAndRolesRecursive(final Accessible accessible, final Component component, final int n, final boolean bl, final int n2) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList arrayList2 = new ArrayList();
                ArrayList<Accessible> arrayList3 = new ArrayList<Accessible>();
                HashMap<Accessible, List<Object>> hashMap = new HashMap<Accessible, List<Object>>();
                arrayList3.add(accessible);
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                Integer n3 = 0;
                int n22 = n2;
                while (!arrayList3.isEmpty()) {
                    Accessible accessible3 = (Accessible)arrayList3.get(arrayList3.size() - 1);
                    if (!hashMap.containsKey(accessible3)) {
                        hashMap.put(accessible3, Arrays.asList(CAccessibility.getChildrenAndRolesImpl(accessible3, component, -1, bl, ChildrenOperations.COMMON)));
                    }
                    arrayList2.addAll((Collection)hashMap.get(accessible3));
                    if (arrayList2.size() == 0 || n3 >= arrayList2.size()) {
                        if (!arrayList3.isEmpty()) {
                            arrayList3.remove(arrayList3.size() - 1);
                        }
                        if (!arrayList4.isEmpty()) {
                            n3 = (Integer)arrayList4.remove(arrayList4.size() - 1);
                        }
                        --n22;
                        arrayList2.clear();
                        continue;
                    }
                    Accessible accessible2 = null;
                    Object e = arrayList2.get(n3);
                    if (!(e instanceof Accessible)) {
                        n3 = n3 + 2;
                        arrayList2.clear();
                        continue;
                    }
                    accessible2 = (Accessible)e;
                    Object e2 = arrayList2.get(n3 + 1);
                    arrayList2.clear();
                    AccessibleContext accessibleContext = accessible2.getAccessibleContext();
                    if (accessibleContext == null) {
                        n3 = n3 + 2;
                        continue;
                    }
                    if (accessibleContext.getAccessibleStateSet().contains(AccessibleState.SELECTED) && n == -2 || accessibleContext.getAccessibleStateSet().contains(AccessibleState.VISIBLE) && n == -3 || n == -1) {
                        arrayList.add(accessible2);
                        arrayList.add(e2);
                        arrayList.add(String.valueOf(n22));
                    }
                    n3 = n3 + 2;
                    if (!accessibleContext.getAccessibleStateSet().contains(AccessibleState.EXPANDED)) continue;
                    arrayList3.add(accessible2);
                    arrayList4.add(n3);
                    n3 = 0;
                    ++n22;
                }
                return arrayList.toArray();
            }
        }, component);
    }

    private static Accessible getCurrentAccessiblePopupMenu(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                return CAccessibility.traversePopupMenu(accessible);
            }
        }, component);
    }

    private static Accessible traversePopupMenu(Accessible accessible) {
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        if (accessibleContext != null) {
            for (int i = 0; i < accessibleContext.getAccessibleChildrenCount(); ++i) {
                JPopupMenu jPopupMenu;
                Accessible accessible2 = accessibleContext.getAccessibleChild(i);
                if (!(accessible2 instanceof JMenu) || !(jPopupMenu = ((JMenu)accessible2).getPopupMenu()).isVisible()) continue;
                return CAccessibility.traversePopupMenu(jPopupMenu);
            }
        }
        return accessible;
    }

    public static int getTableInfo(Accessible accessible, Component component, int n) {
        if (accessible == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(() -> {
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            AccessibleTable accessibleTable = accessibleContext.getAccessibleTable();
            if (accessibleTable != null) {
                if (n == 2) {
                    return accessibleTable.getAccessibleColumnCount();
                }
                if (n == 1) {
                    return accessibleTable.getAccessibleRowCount();
                }
            }
            return 0;
        }, component);
    }

    private static int[] getTableSelectedInfo(Accessible accessible, Component component, int n) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(() -> {
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            AccessibleTable accessibleTable = accessibleContext.getAccessibleTable();
            if (accessibleTable != null) {
                if (n == 2) {
                    return accessibleTable.getSelectedAccessibleColumns();
                }
                if (n == 1) {
                    return accessibleTable.getSelectedAccessibleRows();
                }
            }
            return null;
        }, component);
    }

    private static AccessibleRole getAccessibleRoleForLabel(JLabel jLabel, AccessibleRole accessibleRole) {
        String string = jLabel.getText();
        if (string != null && string.length() > 0) {
            return accessibleRole;
        }
        Icon icon = jLabel.getIcon();
        if (icon != null) {
            return AccessibleRole.ICON;
        }
        return accessibleRole;
    }

    private static AccessibleRole getAccessibleRole(Accessible accessible) {
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
        Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
        if (accessibleRole == null) {
            return null;
        }
        String string = accessibleRole.toString();
        if ("label".equals(string) && accessible2 instanceof JLabel) {
            return CAccessibility.getAccessibleRoleForLabel((JLabel)accessible2, accessibleRole);
        }
        return accessibleRole;
    }

    private static void _addChildren(Accessible accessible, int n, boolean bl, ArrayList<Object> arrayList, ChildrenOperations childrenOperations) {
        if (accessible == null) {
            return;
        }
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        if (!childrenOperations.isContextValid(accessibleContext)) {
            return;
        }
        int n2 = childrenOperations.getChildrenCount(accessibleContext);
        for (int i = 0; i < n2; ++i) {
            Object object;
            AccessibleContext accessibleContext2;
            Accessible accessible2 = childrenOperations.getAccessibleChild(accessibleContext, i);
            if (accessible2 == null || (accessibleContext2 = accessible2.getAccessibleContext()) == null || (n != -3 ? n == -2 && ((object = accessibleContext.getAccessibleSelection()) == null || !object.isAccessibleChildSelected(i)) : (object = accessibleContext2.getAccessibleComponent()) == null || !object.isVisible())) continue;
            if (!bl) {
                object = accessibleContext2.getAccessibleRole();
                if (object != null && ignoredRoles != null && ignoredRoles.contains(CAccessibility.roleKey((AccessibleRole)object))) {
                    CAccessibility._addChildren(accessible2, n, false, arrayList, ChildrenOperations.COMMON);
                } else {
                    arrayList.add(accessible2);
                    arrayList.add(CAccessibility.getAccessibleRole(accessible2));
                }
            } else {
                arrayList.add(accessible2);
                arrayList.add(CAccessibility.getAccessibleRole(accessible2));
            }
            if (n < 0 || arrayList.size() / 2 < n + 1) continue;
            return;
        }
    }

    private static native String roleKey(AccessibleRole var0);

    public static Object[] getChildren(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                int n = accessibleContext.getAccessibleChildrenCount();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = accessibleContext.getAccessibleChild(i);
                }
                return objectArray;
            }
        }, component);
    }

    private static long getAWTView(Accessible accessible) {
        final Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
        if (!(accessible2 instanceof Component)) {
            return 0L;
        }
        return CAccessibility.invokeAndWait(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                LWWindowPeer lWWindowPeer;
                Component component;
                for (component = (Component)((Object)accessible2); component != null && !(component instanceof Window); component = component.getParent()) {
                }
                if (component != null && (lWWindowPeer = (LWWindowPeer)component.getPeer()) != null) {
                    return ((CPlatformWindow)lWWindowPeer.getPlatformWindow()).getContentView().getAWTView();
                }
                return 0L;
            }
        }, (Component)((Object)accessible2));
    }

    private static boolean isTreeRootVisible(final Accessible accessible, Component component) {
        if (accessible == null) {
            return false;
        }
        return CAccessibility.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
                if (accessible2 instanceof JTree) {
                    return ((JTree)accessible2).isRootVisible();
                }
                return false;
            }
        }, component);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
        FIELD_KEY = CAccessibility.getAccessibleBundleKeyFieldWithReflection();
    }

    private static interface ChildrenOperations {
        public static final ChildrenOperations COMMON = ChildrenOperations.createForCommon();

        public boolean isContextValid(AccessibleContext var1);

        public int getChildrenCount(AccessibleContext var1);

        public Accessible getAccessibleChild(AccessibleContext var1, int var2);

        public static ChildrenOperations createForCommon() {
            return new ChildrenOperations(){

                @Override
                public boolean isContextValid(AccessibleContext accessibleContext) {
                    return accessibleContext != null;
                }

                @Override
                public int getChildrenCount(AccessibleContext accessibleContext) {
                    assert (this.isContextValid(accessibleContext));
                    return accessibleContext.getAccessibleChildrenCount();
                }

                @Override
                public Accessible getAccessibleChild(AccessibleContext accessibleContext, int n) {
                    assert (this.isContextValid(accessibleContext));
                    return accessibleContext.getAccessibleChild(n);
                }
            };
        }

        public static ChildrenOperations createForTableRow(final int n) {
            return new ChildrenOperations(){

                @Override
                public boolean isContextValid(AccessibleContext accessibleContext) {
                    return accessibleContext instanceof AccessibleTable;
                }

                @Override
                public int getChildrenCount(AccessibleContext accessibleContext) {
                    assert (this.isContextValid(accessibleContext));
                    return ((AccessibleTable)((Object)accessibleContext)).getAccessibleColumnCount();
                }

                @Override
                public Accessible getAccessibleChild(AccessibleContext accessibleContext, int n2) {
                    assert (this.isContextValid(accessibleContext));
                    return ((AccessibleTable)((Object)accessibleContext)).getAccessibleAt(n, n2);
                }
            };
        }
    }
}

