/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.KnownOIDs;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.SerialNumber;

class AdaptableX509CertSelector
extends X509CertSelector {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date startDate;
    private Date endDate;
    private byte[] ski;
    private BigInteger serial;

    AdaptableX509CertSelector() {
    }

    void setValidityPeriod(Date date, Date date2) {
        this.startDate = date;
        this.endDate = date2;
    }

    @Override
    public void setSubjectKeyIdentifier(byte[] byArray) {
        throw new IllegalArgumentException();
    }

    @Override
    public void setSerialNumber(BigInteger bigInteger) {
        throw new IllegalArgumentException();
    }

    void setSkiAndSerialNumber(AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension) throws IOException {
        this.ski = null;
        this.serial = null;
        if (authorityKeyIdentifierExtension != null) {
            this.ski = authorityKeyIdentifierExtension.getEncodedKeyIdentifier();
            SerialNumber serialNumber = (SerialNumber)authorityKeyIdentifierExtension.get("serial_number");
            if (serialNumber != null) {
                this.serial = serialNumber.getNumber();
            }
        }
    }

    @Override
    public boolean match(Certificate certificate) {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!this.matchSubjectKeyID(x509Certificate)) {
            return false;
        }
        int n = x509Certificate.getVersion();
        if (this.serial != null && n > 2 && !this.serial.equals(x509Certificate.getSerialNumber())) {
            return false;
        }
        if (n < 3) {
            if (this.startDate != null) {
                try {
                    x509Certificate.checkValidity(this.startDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
            if (this.endDate != null) {
                try {
                    x509Certificate.checkValidity(this.endDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
        }
        return super.match(certificate);
    }

    private boolean matchSubjectKeyID(X509Certificate x509Certificate) {
        if (this.ski == null) {
            return true;
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue(KnownOIDs.SubjectKeyID.value());
            if (byArray == null) {
                if (debug != null) {
                    debug.println("AdaptableX509CertSelector.match: no subject key ID extension. Subject: " + x509Certificate.getSubjectX500Principal());
                }
                return true;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            if (byArray2 == null || !Arrays.equals(this.ski, byArray2)) {
                if (debug != null) {
                    debug.println("AdaptableX509CertSelector.match: subject key IDs don't match. Expected: " + Arrays.toString(this.ski) + " Cert's: " + Arrays.toString(byArray2));
                }
                return false;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("AdaptableX509CertSelector.match: exception in subject key ID check");
            }
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        AdaptableX509CertSelector adaptableX509CertSelector = (AdaptableX509CertSelector)super.clone();
        if (this.startDate != null) {
            adaptableX509CertSelector.startDate = (Date)this.startDate.clone();
        }
        if (this.endDate != null) {
            adaptableX509CertSelector.endDate = (Date)this.endDate.clone();
        }
        if (this.ski != null) {
            adaptableX509CertSelector.ski = (byte[])this.ski.clone();
        }
        return adaptableX509CertSelector;
    }
}

