/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Locale;
import sun.misc.SharedSecrets;
import sun.security.rsa.RSAUtil;
import sun.security.util.ECUtil;
import sun.security.x509.AlgorithmId;

public class SignatureUtil {
    private static String checkName(String string) throws ProviderException {
        if (string.indexOf(".") == -1) {
            return string;
        }
        try {
            return Signature.getInstance(string).getAlgorithm();
        }
        catch (Exception exception) {
            throw new ProviderException("Error mapping algorithm name", exception);
        }
    }

    private static AlgorithmParameters createAlgorithmParameters(String string, byte[] byArray) throws ProviderException {
        try {
            string = SignatureUtil.checkName(string);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(byArray);
            return algorithmParameters;
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new ProviderException(exception);
        }
    }

    public static AlgorithmParameterSpec getParamSpec(String string, AlgorithmParameters algorithmParameters) throws ProviderException {
        string = SignatureUtil.checkName(string).toUpperCase(Locale.ENGLISH);
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            if (algorithmParameters.getAlgorithm().indexOf(".") != -1) {
                try {
                    algorithmParameters = SignatureUtil.createAlgorithmParameters(string, algorithmParameters.getEncoded());
                }
                catch (IOException iOException) {
                    throw new ProviderException(iOException);
                }
            }
            if (string.indexOf("RSA") != -1) {
                algorithmParameterSpec = RSAUtil.getParamSpec(algorithmParameters);
            } else if (string.indexOf("ECDSA") != -1) {
                try {
                    algorithmParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                }
                catch (Exception exception) {
                    throw new ProviderException("Error handling EC parameters", exception);
                }
            } else {
                throw new ProviderException("Unrecognized algorithm for signature parameters " + string);
            }
        }
        return algorithmParameterSpec;
    }

    public static AlgorithmParameterSpec getParamSpec(String string, byte[] byArray) throws ProviderException {
        string = SignatureUtil.checkName(string).toUpperCase(Locale.ENGLISH);
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (byArray != null) {
            if (string.indexOf("RSA") != -1) {
                AlgorithmParameters algorithmParameters = SignatureUtil.createAlgorithmParameters(string, byArray);
                algorithmParameterSpec = RSAUtil.getParamSpec(algorithmParameters);
            } else if (string.indexOf("ECDSA") != -1) {
                try {
                    Provider provider = Signature.getInstance(string).getProvider();
                    algorithmParameterSpec = ECUtil.getECParameterSpec(provider, byArray);
                }
                catch (Exception exception) {
                    throw new ProviderException("Error handling EC parameters", exception);
                }
                if (algorithmParameterSpec == null) {
                    throw new ProviderException("Error handling EC parameters");
                }
            } else {
                throw new ProviderException("Unrecognized algorithm for signature parameters " + string);
            }
        }
        return algorithmParameterSpec;
    }

    public static void initVerifyWithParam(Signature signature, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initVerify(signature, publicKey, algorithmParameterSpec);
    }

    public static void initVerifyWithParam(Signature signature, Certificate certificate, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initVerify(signature, certificate, algorithmParameterSpec);
    }

    public static void initSignWithParam(Signature signature, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initSign(signature, privateKey, algorithmParameterSpec, secureRandom);
    }

    public static Signature fromKey(String string, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature signature = string2 == null || string2.isEmpty() ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        return SignatureUtil.autoInitInternal(string, privateKey, signature);
    }

    public static Signature fromKey(String string, PrivateKey privateKey, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = provider == null ? Signature.getInstance(string) : Signature.getInstance(string, provider);
        return SignatureUtil.autoInitInternal(string, privateKey, signature);
    }

    private static Signature autoInitInternal(String string, PrivateKey privateKey, Signature signature) throws InvalidKeyException {
        PSSParameterSpec pSSParameterSpec = AlgorithmId.getDefaultAlgorithmParameterSpec(string, privateKey);
        try {
            SignatureUtil.initSignWithParam(signature, privateKey, pSSParameterSpec, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError("Should not happen", invalidAlgorithmParameterException);
        }
        return signature;
    }

    public static AlgorithmId fromSignature(Signature signature, PrivateKey privateKey) throws SignatureException {
        try {
            AlgorithmParameters algorithmParameters = null;
            try {
                algorithmParameters = signature.getParameters();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (algorithmParameters != null) {
                return AlgorithmId.get(signature.getParameters());
            }
            String string = signature.getAlgorithm();
            if (string.equalsIgnoreCase("EdDSA")) {
                string = privateKey.getAlgorithm();
            }
            return AlgorithmId.get(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException("Cannot derive AlgorithmIdentifier", noSuchAlgorithmException);
        }
    }
}

