/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;
import java.util.Arrays;
import java.util.List;

public class FXLoader {
    private static final String POLICY_URL = "policy.url.";
    private static final String JAVAFX_RUNTIME_PROPERTY = "javafx.runtime.home";
    private static final List<String> javafxClassNames = Arrays.asList("javafx.application.Application", "javafx.application.Platform", "javafx.application.Preloader", "javafx.embed.swing.JFXPanel");
    private static boolean printedJavaFXRemoval = false;

    public static void checkJavaFXRemoval(String string) {
        if (printedJavaFXRemoval || string == null) {
            return;
        }
        if (FXLoader.isJavaFXClass(string)) {
            System.err.println("#### " + ResourceManager.getMessage("launch.error.jfx.removed"));
            printedJavaFXRemoval = true;
        }
    }

    public static boolean isJavaFXClass(String string) {
        if (string != null && string.startsWith("javafx")) {
            String string2 = string.replace("/", ".");
            return javafxClassNames.contains(string2);
        }
        return false;
    }

    private static void registerJavaFXPolicy(JfxRuntime jfxRuntime) throws MalformedURLException {
        int n = 1;
        while (Security.getProperty(POLICY_URL + n) != null) {
            ++n;
        }
        Security.setProperty(POLICY_URL + n, jfxRuntime.getSecurityPolicy().toURI().toURL().toString());
        System.setProperty(JAVAFX_RUNTIME_PROPERTY, jfxRuntime.getHome().toString());
        Policy.getPolicy().refresh();
    }

    private static void addURL(URLClassLoader uRLClassLoader, URL uRL) throws Exception {
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    private static void loadFX(JfxRuntime jfxRuntime) throws ClassNotFoundException {
        if (null == jfxRuntime) {
            throw new ClassNotFoundException();
        }
        if (jfxRuntime.isExtensionJfx()) {
            return;
        }
        URLClassLoader uRLClassLoader = null;
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            uRLClassLoader = (URLClassLoader)classLoader;
        }
        URL[] uRLArray = jfxRuntime.getURLs();
        if (null == uRLArray) {
            throw new ClassNotFoundException();
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                FXLoader.addURL(uRLClassLoader, uRLArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Failed to add JavaFX Runtime", exception);
            }
        }
        try {
            FXLoader.registerJavaFXPolicy(jfxRuntime);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            throw new ClassNotFoundException();
        }
    }

    public static void loadFX() throws ClassNotFoundException {
        JfxRuntime jfxRuntime = JREInfo.getHomeJRE().getJfxRuntime();
        FXLoader.loadFX(jfxRuntime);
    }
}

