/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.interceptor;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lab1024.sa.admin.module.system.login.domain.RequestEmployee;
import net.lab1024.sa.admin.module.system.login.service.LoginService;
import net.lab1024.sa.base.common.annoation.NoNeedLogin;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.SystemErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.SystemEnvironment;
import net.lab1024.sa.base.common.enumeration.SystemEnvironmentEnum;
import net.lab1024.sa.base.common.enumeration.UserTypeEnum;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.common.util.SmartResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AdminInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AdminInterceptor.class);
    @Resource
    private LoginService loginService;
    @Resource
    private SystemEnvironment systemEnvironment;
    @Value(value="${sa-token.active-timeout}")
    private long tokenActiveTimeout;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (HttpMethod.OPTIONS.toString().equals(request.getMethod())) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return false;
        }
        boolean isHandler = handler instanceof HandlerMethod;
        if (!isHandler) {
            return true;
        }
        try {
            String tokenValue = StpUtil.getTokenValue();
            boolean debugNumberTokenFlag = this.isDevDebugNumberToken(tokenValue);
            String loginId = null;
            if (debugNumberTokenFlag) {
                loginId = UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + tokenValue;
                StpUtil.switchTo((Object)loginId);
            } else {
                loginId = (String)StpUtil.getLoginIdByToken((String)tokenValue);
            }
            RequestEmployee requestEmployee = this.loginService.getLoginEmployee(loginId, request);
            Method method = ((HandlerMethod)handler).getMethod();
            NoNeedLogin noNeedLogin = (NoNeedLogin)((HandlerMethod)handler).getMethodAnnotation(NoNeedLogin.class);
            if (noNeedLogin != null) {
                this.checkActiveTimeout(requestEmployee, debugNumberTokenFlag);
                return true;
            }
            if (requestEmployee == null) {
                SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)UserErrorCode.LOGIN_STATE_INVALID));
                return false;
            }
            this.checkActiveTimeout(requestEmployee, debugNumberTokenFlag);
            SmartRequestUtil.setRequestUser((RequestUser)requestEmployee);
            if (((Boolean)SaStrategy.instance.isAnnotationPresent.apply((Object)method, SaIgnore.class)).booleanValue()) {
                return true;
            }
            if (requestEmployee.getAdministratorFlag().booleanValue()) {
                return true;
            }
            SaStrategy.instance.checkMethodAnnotation.accept((Object)method);
        }
        catch (SaTokenException e) {
            int code = e.getCode();
            if (code == 11041 || code == 11051) {
                SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)UserErrorCode.NO_PERMISSION));
            } else if (code == 11016) {
                SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)UserErrorCode.LOGIN_ACTIVE_TIMEOUT));
            } else if (code >= 11011 && code <= 11015) {
                SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)UserErrorCode.LOGIN_STATE_INVALID));
            } else {
                SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)UserErrorCode.PARAM_ERROR));
            }
            return false;
        }
        catch (Throwable e) {
            SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.error((ErrorCode)SystemErrorCode.SYSTEM_ERROR));
            log.error(e.getMessage(), e);
            return false;
        }
        return true;
    }

    private void checkActiveTimeout(RequestEmployee requestEmployee, boolean debugNumberTokenFlag) {
        if (debugNumberTokenFlag) {
            return;
        }
        if (requestEmployee == null) {
            return;
        }
        if (this.tokenActiveTimeout < 1L) {
            return;
        }
        StpUtil.checkActiveTimeout();
        StpUtil.updateLastActiveToNow();
    }

    private boolean isDevDebugNumberToken(String token) {
        if (!StrUtil.isNumeric((CharSequence)token)) {
            return false;
        }
        return this.systemEnvironment.getCurrentEnvironment() == SystemEnvironmentEnum.DEV || this.systemEnvironment.getCurrentEnvironment() == SystemEnvironmentEnum.TEST;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SmartRequestUtil.remove();
        if (this.systemEnvironment.getCurrentEnvironment() == SystemEnvironmentEnum.DEV) {
            StpUtil.endSwitch();
        }
    }
}

