/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.category.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryAddForm;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryTreeQueryForm;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryUpdateForm;
import net.lab1024.sa.admin.module.business.category.domain.vo.CategoryTreeVO;
import net.lab1024.sa.admin.module.business.category.domain.vo.CategoryVO;
import net.lab1024.sa.admin.module.business.category.service.CategoryService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="ERP\u8fdb\u9500\u5b58-\u5206\u7c7b\u7ba1\u7406")
public class CategoryController {
    @Resource
    private CategoryService categoryService;

    @Operation(summary="\u6dfb\u52a0\u7c7b\u76ee @author \u80e1\u514b")
    @PostMapping(value={"/category/add"})
    @SaCheckPermission(value={"category:add"})
    public ResponseDTO<String> add(@RequestBody @Valid CategoryAddForm addForm) {
        return this.categoryService.add(addForm);
    }

    @Operation(summary="\u66f4\u65b0\u7c7b\u76ee @author \u80e1\u514b")
    @PostMapping(value={"/category/update"})
    @SaCheckPermission(value={"category:update"})
    public ResponseDTO<String> update(@RequestBody @Valid CategoryUpdateForm updateForm) {
        return this.categoryService.update(updateForm);
    }

    @Operation(summary="\u67e5\u8be2\u7c7b\u76ee\u8be6\u60c5 @author \u80e1\u514b")
    @GetMapping(value={"/category/{categoryId}"})
    public ResponseDTO<CategoryVO> queryDetail(@PathVariable Long categoryId) {
        return this.categoryService.queryDetail(categoryId);
    }

    @Operation(summary="\u67e5\u8be2\u7c7b\u76ee\u5c42\u7ea7\u6811 @author \u80e1\u514b")
    @PostMapping(value={"/category/tree"})
    @SaCheckPermission(value={"category:tree"})
    public ResponseDTO<List<CategoryTreeVO>> queryTree(@RequestBody @Valid CategoryTreeQueryForm queryForm) {
        return this.categoryService.queryTree(queryForm);
    }

    @Operation(summary="\u5220\u9664\u7c7b\u76ee @author \u80e1\u514b")
    @GetMapping(value={"/category/delete/{categoryId}"})
    @SaCheckPermission(value={"category:delete"})
    public ResponseDTO<String> delete(@PathVariable Long categoryId) {
        return this.categoryService.delete(categoryId);
    }
}

