/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.category.manager;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.category.dao.CategoryDao;
import net.lab1024.sa.admin.module.business.category.domain.entity.CategoryEntity;
import net.lab1024.sa.admin.module.business.category.domain.vo.CategoryTreeVO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class CategoryCacheManager {
    private static final Logger log = LoggerFactory.getLogger(CategoryCacheManager.class);
    @Resource
    private CategoryDao categoryDao;

    @CacheEvict(value={"category_cache", "category_sub_cache", "category_tree_cache"}, allEntries=true)
    public void removeCache() {
        log.info("clear CATEGORY ,CATEGORY_SUB ,CATEGORY_TREE");
    }

    @Cacheable(value={"category_cache"})
    public CategoryEntity queryCategory(Long categoryId) {
        return (CategoryEntity)this.categoryDao.selectById((Serializable)categoryId);
    }

    @Cacheable(value={"category_sub_cache"})
    public List<CategoryEntity> querySubCategory(Long categoryId) {
        return this.categoryDao.queryByParentId((List)Lists.newArrayList((Object[])new Long[]{categoryId}), Boolean.valueOf(false));
    }

    @Cacheable(value={"category_tree_cache"})
    public List<CategoryTreeVO> queryCategoryTree(Long parentId, Integer categoryType) {
        List allCategoryEntityList = this.categoryDao.queryByType(categoryType, Boolean.valueOf(false));
        List categoryEntityList = allCategoryEntityList.stream().filter(e -> e.getParentId().equals(parentId)).collect(Collectors.toList());
        List treeList = SmartBeanUtil.copyList(categoryEntityList, CategoryTreeVO.class);
        treeList.forEach(e -> {
            e.setLabel(e.getCategoryName());
            e.setValue(e.getCategoryId());
            e.setCategoryFullName(e.getCategoryName());
        });
        this.queryAndSetSubCategory(treeList, allCategoryEntityList);
        return treeList;
    }

    private void queryAndSetSubCategory(List<CategoryTreeVO> treeList, List<CategoryEntity> allCategoryEntityList) {
        if (CollectionUtils.isEmpty(treeList)) {
            return;
        }
        List parentIdList = treeList.stream().map(CategoryTreeVO::getValue).collect(Collectors.toList());
        List categoryEntityList = allCategoryEntityList.stream().filter(e -> parentIdList.contains(e.getParentId())).collect(Collectors.toList());
        Map<Long, List<CategoryEntity>> categorySubMap = categoryEntityList.stream().collect(Collectors.groupingBy(CategoryEntity::getParentId));
        treeList.forEach(e -> {
            List childrenEntityList = categorySubMap.getOrDefault(e.getValue(), Lists.newArrayList());
            List childrenVOList = SmartBeanUtil.copyList((List)childrenEntityList, CategoryTreeVO.class);
            childrenVOList.forEach(item -> {
                item.setLabel(item.getCategoryName());
                item.setValue(item.getCategoryId());
                item.setCategoryFullName(e.getCategoryFullName() + "/" + item.getCategoryName());
            });
            this.queryAndSetSubCategory(childrenVOList, allCategoryEntityList);
            e.setChildren(childrenVOList);
        });
    }
}

