/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.category.service;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.category.domain.dto.CategorySimpleDTO;
import net.lab1024.sa.admin.module.business.category.domain.entity.CategoryEntity;
import net.lab1024.sa.admin.module.business.category.manager.CategoryCacheManager;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CategoryQueryService {
    private static final Logger log = LoggerFactory.getLogger(CategoryQueryService.class);
    private static final Long DEFAULT_CATEGORY_PARENT_ID = 0L;
    @Resource
    private CategoryCacheManager categoryCacheManager;

    public Optional<CategoryEntity> queryCategory(Long categoryId) {
        if (null == categoryId) {
            return Optional.empty();
        }
        CategoryEntity entity = this.categoryCacheManager.queryCategory(categoryId);
        if (null == entity || entity.getDeletedFlag().booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    public Map<Long, CategoryEntity> queryCategoryList(List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return Collections.emptyMap();
        }
        categoryIdList = categoryIdList.stream().distinct().collect(Collectors.toList());
        HashMap categoryEntityMap = Maps.newHashMap();
        for (Long categoryId : categoryIdList) {
            CategoryEntity categoryEntity = this.categoryCacheManager.queryCategory(categoryId);
            if (categoryEntity == null) continue;
            categoryEntityMap.put(categoryId, categoryEntity);
        }
        return categoryEntityMap;
    }

    public List<Long> queryCategorySubId(List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return Collections.emptyList();
        }
        ArrayList categoryEntityList = Lists.newArrayList();
        categoryIdList.forEach(e -> categoryEntityList.addAll(this.categoryCacheManager.querySubCategory(e)));
        Map<Long, List<CategoryEntity>> subTypeMap = categoryEntityList.stream().collect(Collectors.groupingBy(CategoryEntity::getCategoryId));
        categoryIdList = subTypeMap.values().stream().flatMap(Collection::stream).map(CategoryEntity::getCategoryId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return Lists.newArrayList();
        }
        categoryIdList.addAll(this.queryCategorySubId(categoryIdList));
        return categoryIdList;
    }

    public List<String> queryCategoryName(List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return null;
        }
        Map categoryMap = this.queryCategoryList(categoryIdList);
        ArrayList categoryNameList = Lists.newArrayList();
        categoryIdList.forEach(e -> {
            CategoryEntity categoryEntity = (CategoryEntity)categoryMap.get(e);
            if (categoryEntity != null) {
                categoryNameList.add(((CategoryEntity)categoryMap.get(e)).getCategoryName());
            }
        });
        return categoryNameList;
    }

    public String queryCategoryName(Long categoryId) {
        CategoryEntity categoryEntity = this.categoryCacheManager.queryCategory(categoryId);
        if (null == categoryEntity || categoryEntity.getDeletedFlag().booleanValue()) {
            return null;
        }
        return categoryEntity.getCategoryName();
    }

    public CategorySimpleDTO queryCategoryInfo(Long categoryId) {
        CategoryEntity categoryEntity = this.categoryCacheManager.queryCategory(categoryId);
        if (null == categoryEntity || categoryEntity.getDeletedFlag().booleanValue()) {
            return null;
        }
        String fullName = this.queryFullName(categoryId);
        CategorySimpleDTO categoryDTO = new CategorySimpleDTO();
        categoryDTO.setCategoryId(categoryId);
        categoryDTO.setCategoryName(categoryEntity.getCategoryName());
        categoryDTO.setCategoryFullName(fullName);
        categoryDTO.setParentId(categoryEntity.getParentId());
        return categoryDTO;
    }

    public List<CategoryEntity> queryCategoryAndParent(Long categoryId) {
        ArrayList parentCategoryList = Lists.newArrayList();
        CategoryEntity categoryEntity = this.categoryCacheManager.queryCategory(categoryId);
        if (null == categoryEntity || categoryEntity.getDeletedFlag().booleanValue()) {
            return parentCategoryList;
        }
        parentCategoryList.add(0, categoryEntity);
        Long parentId = categoryEntity.getParentId();
        if (Objects.equals(DEFAULT_CATEGORY_PARENT_ID, parentId)) {
            return parentCategoryList;
        }
        parentCategoryList.addAll(0, this.queryCategoryAndParent(parentId));
        return parentCategoryList;
    }

    public String queryFullName(Long categoryId) {
        List parentCategoryList = this.queryCategoryAndParent(categoryId);
        List nameList = parentCategoryList.stream().map(CategoryEntity::getCategoryName).collect(Collectors.toList());
        return StrUtil.join((CharSequence)"/", nameList);
    }

    public Map<Long, String> queryFullName(List<Long> categoryIdList) {
        if (CollectionUtils.isEmpty(categoryIdList)) {
            return Maps.newHashMap();
        }
        return categoryIdList.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> this.queryFullName(arg_0)));
    }
}

