/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.category.service;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.category.dao.CategoryDao;
import net.lab1024.sa.admin.module.business.category.domain.entity.CategoryEntity;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryAddForm;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryTreeQueryForm;
import net.lab1024.sa.admin.module.business.category.domain.form.CategoryUpdateForm;
import net.lab1024.sa.admin.module.business.category.domain.vo.CategoryTreeVO;
import net.lab1024.sa.admin.module.business.category.domain.vo.CategoryVO;
import net.lab1024.sa.admin.module.business.category.manager.CategoryCacheManager;
import net.lab1024.sa.admin.module.business.category.service.CategoryQueryService;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    @Resource
    private CategoryDao categoryDao;
    @Resource
    private CategoryQueryService categoryQueryService;
    @Resource
    private CategoryCacheManager categoryCacheManager;

    public ResponseDTO<String> add(CategoryAddForm addForm) {
        CategoryEntity categoryEntity = (CategoryEntity)SmartBeanUtil.copy((Object)addForm, CategoryEntity.class);
        ResponseDTO res = this.checkCategory(categoryEntity, false);
        if (!res.getOk().booleanValue()) {
            return res;
        }
        Long parentId = null == addForm.getParentId() ? NumberUtils.LONG_ZERO : addForm.getParentId();
        categoryEntity.setParentId(parentId);
        categoryEntity.setSort(Integer.valueOf(null == addForm.getSort() ? 0 : addForm.getSort()));
        categoryEntity.setDeletedFlag(Boolean.valueOf(false));
        this.categoryDao.insert((Object)categoryEntity);
        this.categoryCacheManager.removeCache();
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> update(CategoryUpdateForm updateForm) {
        Long categoryId = updateForm.getCategoryId();
        Optional optional = this.categoryQueryService.queryCategory(categoryId);
        if (!optional.isPresent()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        CategoryEntity categoryEntity = (CategoryEntity)SmartBeanUtil.copy((Object)updateForm, CategoryEntity.class);
        Integer categoryType = ((CategoryEntity)optional.get()).getCategoryType();
        categoryEntity.setCategoryType(categoryType);
        categoryEntity.setParentId(((CategoryEntity)optional.get()).getParentId());
        ResponseDTO responseDTO = this.checkCategory(categoryEntity, true);
        if (!responseDTO.getOk().booleanValue()) {
            return responseDTO;
        }
        this.categoryDao.updateById((Object)categoryEntity);
        this.categoryCacheManager.removeCache();
        return ResponseDTO.ok();
    }

    private ResponseDTO<String> checkCategory(CategoryEntity categoryEntity, boolean isUpdate) {
        Long parentId = categoryEntity.getParentId();
        Integer categoryType = categoryEntity.getCategoryType();
        if (null != parentId) {
            if (Objects.equals(categoryEntity.getCategoryId(), parentId)) {
                return ResponseDTO.userErrorParam((String)"\u7236\u7ea7\u7c7b\u76ee\u600e\u4e48\u548c\u81ea\u5df1\u76f8\u540c\u4e86");
            }
            if (!Objects.equals(parentId, NumberUtils.LONG_ZERO)) {
                Optional optional = this.categoryQueryService.queryCategory(parentId);
                if (!optional.isPresent()) {
                    return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST, (String)"\u7236\u7ea7\u7c7b\u76ee\u4e0d\u5b58\u5728~");
                }
                CategoryEntity parent = (CategoryEntity)optional.get();
                if (!Objects.equals(categoryType, parent.getCategoryType())) {
                    return ResponseDTO.userErrorParam((String)"\u4e0e\u7236\u7ea7\u7c7b\u76ee\u7c7b\u578b\u4e0d\u4e00\u81f4");
                }
            }
        } else {
            parentId = NumberUtils.LONG_ZERO;
        }
        CategoryEntity queryEntity = new CategoryEntity();
        queryEntity.setParentId(parentId);
        queryEntity.setCategoryType(categoryType);
        queryEntity.setCategoryName(categoryEntity.getCategoryName());
        queryEntity.setDeletedFlag(Boolean.valueOf(false));
        queryEntity = this.categoryDao.selectOne(queryEntity);
        if (null != queryEntity) {
            if (isUpdate) {
                if (!Objects.equals(queryEntity.getCategoryId(), categoryEntity.getCategoryId())) {
                    return ResponseDTO.userErrorParam((String)"\u540c\u7ea7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u76ee~");
                }
            } else {
                return ResponseDTO.userErrorParam((String)"\u540c\u7ea7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u76ee~");
            }
        }
        return ResponseDTO.ok();
    }

    public ResponseDTO<CategoryVO> queryDetail(Long categoryId) {
        Optional optional = this.categoryQueryService.queryCategory(categoryId);
        if (!optional.isPresent()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        CategoryVO adminVO = (CategoryVO)SmartBeanUtil.copy(optional.get(), CategoryVO.class);
        return ResponseDTO.ok((Object)adminVO);
    }

    public ResponseDTO<List<CategoryTreeVO>> queryTree(CategoryTreeQueryForm queryForm) {
        if (null == queryForm.getParentId()) {
            if (null == queryForm.getCategoryType()) {
                return ResponseDTO.userErrorParam((String)"\u7c7b\u76ee\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            queryForm.setParentId(NumberUtils.LONG_ZERO);
        }
        List treeList = this.categoryCacheManager.queryCategoryTree(queryForm.getParentId(), queryForm.getCategoryType());
        return ResponseDTO.ok((Object)treeList);
    }

    public ResponseDTO<String> delete(Long categoryId) {
        Optional optional = this.categoryQueryService.queryCategory(categoryId);
        if (!optional.isPresent()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        List categorySubId = this.categoryQueryService.queryCategorySubId((List)Lists.newArrayList((Object[])new Long[]{categoryId}));
        if (CollectionUtils.isNotEmpty((Collection)categorySubId)) {
            return ResponseDTO.userErrorParam((String)"\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u7c7b\u76ee");
        }
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryEntity.setCategoryId(categoryId);
        categoryEntity.setDeletedFlag(Boolean.valueOf(true));
        this.categoryDao.updateById((Object)categoryEntity);
        this.categoryCacheManager.removeCache();
        return ResponseDTO.ok();
    }
}

