/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.CostQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CostExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CostVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.NCostExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.service.CostService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import net.lab1024.sa.base.common.util.SmartExcelUtil;
import net.lab1024.sa.base.common.util.SmartResponseUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u8868\u5355-\u6210\u672c\u8868\uff08\u6807\u51c6\u4e1a\u52a1and\u975e\u6807\u4e1a\u52a1\uff09")
@RestController
public class CostController {
    @Resource
    private CostService costService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author \u80e1\u514b")
    @PostMapping(value={"/ncost/query"})
    @SaCheckPermission(value={"ncost:query"})
    public ResponseDTO<PageResult<CostVO>> queryn(@RequestBody @Valid CostQueryForm queryForm) {
        return this.costService.queryn(queryForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author \u5353\u5927")
    @PostMapping(value={"/ncost/batchDelete"})
    @SaCheckPermission(value={"ncost:batchDelete"})
    public ResponseDTO<String> batchDeleten(@RequestBody @Valid ValidateList<Long> idList) {
        return this.costService.batchDeleten(idList);
    }

    @Operation(summary="\u5bfc\u5165 @author \u5353\u5927")
    @PostMapping(value={"/ncost/importCost"})
    @SaCheckPermission(value={"ncost:importCost"})
    public ResponseDTO<String> importnCost(@RequestParam MultipartFile file, @RequestParam String employeeID) {
        return this.costService.importnCost(file, employeeID);
    }

    @Operation(summary="\u5bfc\u51fa @author \u5353\u5927")
    @PostMapping(value={"/ncost/exportCost"})
    @SaCheckPermission(value={"ncost:exportCost"})
    public void exportCostn(HttpServletResponse response, @RequestBody Map<String, String> params) throws IOException {
        String userId = params.get("userId");
        List costList = this.costService.getAllnCost(userId);
        SmartExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6210\u672c\u8868-\u5ba2\u6237\u7ef4\u5ea6.xlsx", (String)"\u6210\u672c\u8868-\u5ba2\u6237\u7ef4\u5ea6", NCostExcelVO.class, (Collection)costList);
    }

    @Operation(summary="\u4e0b\u8f7dexcel\u6a21\u677f")
    @GetMapping(value={"/ncost/downloadCost"})
    public void downloadn(HttpServletResponse response) throws IOException {
        String filename = "\u6210\u672c\u8868\u6a21\u677f-\u975e\u6807\u4e1a\u52a1.xlsx";
        String filepath = "sa-admin/src/files/\u6210\u672c\u8868\u6a21\u677f-\u975e\u6807\u4e1a\u52a1.xlsx";
        try {
            SmartResponseUtil.setDownloadFileHeader((HttpServletResponse)response, (String)filename, null);
            SmartExcelUtil.downloadExcel((HttpServletResponse)response, (String)filename, (String)filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author \u80e1\u514b")
    @PostMapping(value={"/cost/query"})
    @SaCheckPermission(value={"cost:query"})
    public ResponseDTO<PageResult<CostVO>> query(@RequestBody @Valid CostQueryForm queryForm) {
        return this.costService.query(queryForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author \u5353\u5927")
    @PostMapping(value={"/cost/batchDelete"})
    @SaCheckPermission(value={"cost:batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody @Valid ValidateList<Long> idList) {
        return this.costService.batchDelete(idList);
    }

    @Operation(summary="\u5bfc\u5165 @author \u5353\u5927")
    @PostMapping(value={"/cost/importCost"})
    @SaCheckPermission(value={"cost:importCost"})
    public ResponseDTO<String> importCost(@RequestParam MultipartFile file, @RequestParam String employeeID) {
        return this.costService.importCost(file, employeeID);
    }

    @Operation(summary="\u5bfc\u51fa @author \u5353\u5927")
    @PostMapping(value={"/cost/exportCost"})
    @SaCheckPermission(value={"cost:exportCost"})
    public void exportCost(HttpServletResponse response, @RequestBody Map<String, String> params) throws IOException {
        String userId = params.get("userId");
        System.out.println(userId);
        List costList = this.costService.getAllCost(userId);
        System.out.println(costList);
        SmartExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6210\u672c\u8868-\u4ea7\u54c1\u7ef4\u5ea6.xlsx", (String)"\u6210\u672c\u8868-\u4ea7\u54c1\u7ef4\u5ea6", CostExcelVO.class, (Collection)costList);
    }

    @Operation(summary="\u4e0b\u8f7dexcel\u6a21\u677f")
    @GetMapping(value={"/cost/downloadCost"})
    public void download(HttpServletResponse response) throws IOException {
        String filename = "\u6210\u672c\u8868\u6a21\u677f-\u6807\u51c6\u4e1a\u52a1.xlsx";
        String filepath = "sa-admin/src/files/\u6210\u672c\u8868\u6a21\u677f-\u6807\u51c6\u4e1a\u52a1.xlsx";
        try {
            SmartResponseUtil.setDownloadFileHeader((HttpServletResponse)response, (String)filename, null);
            SmartExcelUtil.downloadExcel((HttpServletResponse)response, (String)filename, (String)filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

