/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.CwbbQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CwbbExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CwbbVO;
import net.lab1024.sa.admin.module.business.datafrom.service.CwbbService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import net.lab1024.sa.base.common.util.SmartExcelUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u8868\u5355-\u8d22\u52a1\u62a5\u8868(\u5f03\u7528)")
@RestController
public class CwbbController {
    @Resource
    private CwbbService cwbbService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 ")
    @PostMapping(value={"/cwbb/query"})
    @SaCheckPermission(value={"cwbb:query"})
    public ResponseDTO<PageResult<CwbbVO>> query(@RequestBody @Valid CwbbQueryForm queryForm) {
        return this.cwbbService.query(queryForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author \u5353\u5927")
    @PostMapping(value={"/cwbb/batchDelete"})
    @SaCheckPermission(value={"cwbb:batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody @Valid ValidateList<Long> idList) {
        return this.cwbbService.batchDelete(idList);
    }

    @Operation(summary="\u5bfc\u5165 @author \u5353\u5927")
    @PostMapping(value={"/cwbb/importCwbb"})
    @SaCheckPermission(value={"cwbb:importCwbb"})
    public ResponseDTO<String> importCost(@RequestParam MultipartFile file, @RequestParam String employeeID) {
        return this.cwbbService.importCwbb(file, employeeID);
    }

    @Operation(summary="\u5bfc\u51fa @author \u5353\u5927")
    @GetMapping(value={"/cwbb/exportCwbb"})
    @SaCheckPermission(value={"cwbb:exportCwbb"})
    public void exportCost(HttpServletResponse response) throws IOException {
        List cwbbList = this.cwbbService.getAllCwbb();
        SmartExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u8d22\u52a1\u62a5\u8868.xlsx", (String)"\u8d22\u52a1\u62a5\u8868", CwbbExcelVO.class, (Collection)cwbbList);
    }

    @Operation(summary="\u4e0b\u8f7dexcel\u6a21\u677f")
    @GetMapping(value={"/cwbb/downloadCwbb"})
    public void download(HttpServletResponse response) {
        String filename = "\u8d22\u52a1\u62a5\u8868\u6a21\u677f.xlsx";
        String filepath = "sa-admin/src/files/\u8d22\u52a1\u62a5\u8868\u6a21\u677f.xlsx";
        try {
            SmartExcelUtil.downloadExcel((HttpServletResponse)response, (String)filename, (String)filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

