/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.controller;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.lab1024.sa.admin.module.business.datafrom.service.ImportExcelService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u8868\u5355-\u8d22\u52a1\u62a5\u8868(\u5f03\u7528)")
@RestController
public class ImportExcelController {
    @Autowired
    private ImportExcelService importExcelService;

    @Operation(summary="\u4e0a\u4f20Excel\u5e76\u8fd4\u56de\u8868\u5934\u5bf9\u5e94\u7684\u5b57\u6bb5")
    @PostMapping(value={"/importExcel/excelUpload"})
    public ResponseDTO<List<Map<String, String>>> uploadExcelFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="employeeID") String employeeId) {
        if (file.isEmpty()) {
            throw new BusinessException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            return ResponseDTO.ok((Object)this.importExcelService.processExcelFile(file, employeeId));
        }
        catch (IOException e) {
            System.out.println(e);
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="\u63d0\u4ea4\u6620\u5c04\u4fe1\u606f\u5e76\u5bfc\u5165\u6570\u636e\u5230\u6570\u636e\u5e93")
    @PostMapping(value={"/importExcel/submitMapping"})
    public ResponseDTO<String> submitMapping(@RequestBody Map<String, String> mappings) {
        Gson gson = new Gson();
        Type mappingListType = new /* Unavailable Anonymous Inner Class!! */.getType();
        List mappingList = (List)gson.fromJson(mappings.get("mappingsData"), mappingListType);
        String employeeId = mappings.get("employeeID");
        return this.importExcelService.submitMapping(mappingList, employeeId);
    }
}

