/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.OrderQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.OrderExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.OrderVO;
import net.lab1024.sa.admin.module.business.datafrom.service.OrderService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import net.lab1024.sa.base.common.util.SmartExcelUtil;
import net.lab1024.sa.base.common.util.SmartResponseUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u8868\u5355-\u8ba2\u5355\u8868\uff08\u6807\u51c6\u4e1a\u52a1\uff09")
@RestController
public class OrderController {
    @Resource
    private OrderService orderService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author \u80e1\u514b")
    @PostMapping(value={"/order/query"})
    @SaCheckPermission(value={"order:query"})
    public ResponseDTO<PageResult<OrderVO>> query(@RequestBody @Valid OrderQueryForm queryForm) {
        return this.orderService.query(queryForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author \u5353\u5927")
    @PostMapping(value={"/order/batchDelete"})
    @SaCheckPermission(value={"order:batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody @Valid ValidateList<Long> idList) {
        return this.orderService.batchDelete(idList);
    }

    @Operation(summary="\u5bfc\u5165 @author \u5353\u5927")
    @PostMapping(value={"/order/importOrder"})
    @SaCheckPermission(value={"order:importOrder"})
    public ResponseDTO<String> importGoods(@RequestParam MultipartFile file, @RequestParam String userId) {
        return this.orderService.importOrder(file, userId);
    }

    @Operation(summary="\u5bfc\u51fa @author \u5353\u5927")
    @PostMapping(value={"/order/exportOrder"})
    @SaCheckPermission(value={"order:exportOrder"})
    public void exportGoods(HttpServletResponse response, @RequestBody Map<String, String> params) throws IOException {
        String userId = params.get("userId");
        List orderList = this.orderService.getAllOrder(userId);
        SmartExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u8ba2\u5355\u8868-\u4ea7\u54c1\u7ef4\u5ea6.xlsx", (String)"\u8ba2\u5355\u8868-\u4ea7\u54c1\u7ef4\u5ea6", OrderExcelVO.class, (Collection)orderList);
    }

    @Operation(summary="\u4e0b\u8f7dexcel\u6a21\u677f")
    @GetMapping(value={"/order/downloadOrder"})
    public void download(HttpServletResponse response) throws IOException {
        String filename = "\u8ba2\u5355\u8868\u6a21\u677f-\u6807\u51c6\u4e1a\u52a1.xlsx";
        String filepath = "sa-admin/src/files/\u8ba2\u5355\u8868-\u6807\u51c6\u4e1a\u52a1.xlsx";
        try {
            SmartResponseUtil.setDownloadFileHeader((HttpServletResponse)response, (String)filename, null);
            SmartExcelUtil.downloadExcel((HttpServletResponse)response, (String)filename, (String)filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

