/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.dao.CostDao;
import net.lab1024.sa.admin.module.business.datafrom.dao.NCostDao;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.CostEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.CostImportForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.CostQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.NCostImportForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CostExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.CostVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.NCostExcelVO;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.exception.BusinessException;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CostService {
    private static final Logger log = LoggerFactory.getLogger(CostService.class);
    @Resource
    private CostDao costDao;
    @Resource
    private NCostDao ncostDao;

    public ResponseDTO<PageResult<CostVO>> query(CostQueryForm queryForm) {
        List list;
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)(list = this.costDao.query(page, queryForm)));
        if (pageResult.getEmptyFlag().booleanValue()) {
            return ResponseDTO.ok((Object)pageResult);
        }
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<PageResult<CostVO>> queryn(CostQueryForm queryForm) {
        List list;
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)(list = this.costDao.queryn(page, queryForm)));
        if (pageResult.getEmptyFlag().booleanValue()) {
            return ResponseDTO.ok((Object)pageResult);
        }
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<String> batchDelete(List<Long> costIdList) {
        if (CollectionUtils.isEmpty(costIdList)) {
            return ResponseDTO.ok();
        }
        this.costDao.batchUpdateDeleted(costIdList);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchDeleten(List<Long> costIdList) {
        if (CollectionUtils.isEmpty(costIdList)) {
            return ResponseDTO.ok();
        }
        this.costDao.batchUpdateDeletedn(costIdList);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> importCost(MultipartFile file, String employeeID) {
        ArrayList dataList = new ArrayList();
        ArrayList headerList = new ArrayList();
        List<String> costheaderList = Arrays.asList("\u6536\u5165\u786e\u8ba4\u6708\u4efd", "\u4ea7\u54c1\u540d\u79f0", "\u6750\u6599\u6210\u672c", "\u4eba\u5de5\u6210\u672c", "\u5236\u9020\u8d39\u7528");
        try {
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(CostImportForm.class)).sheet().registerReadListener((ReadListener)new /* Unavailable Anonymous Inner Class!! */)).doReadSync();
            if (!headerList.equals(costheaderList)) {
                throw new BusinessException("\u5217\u540d\u4e0d\u5339\u914d");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        this.costDao.deleteAll(Long.parseLong(employeeID));
        this.costDao.insertBatch(dataList);
        return ResponseDTO.okMsg((String)("\u6210\u529f\u5bfc\u5165" + dataList.size() + "\u6761\u6570\u636e"));
    }

    public ResponseDTO<String> importnCost(MultipartFile file, String employeeID) {
        ArrayList dataList = new ArrayList();
        ArrayList headerList = new ArrayList();
        List<String> costheaderList = Arrays.asList("\u6536\u5165\u786e\u8ba4\u6708\u4efd", "\u5ba2\u6237\u540d\u79f0", "\u6750\u6599\u6210\u672c", "\u4eba\u5de5\u6210\u672c", "\u5236\u9020\u8d39\u7528");
        try {
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(NCostImportForm.class)).sheet().registerReadListener((ReadListener)new /* Unavailable Anonymous Inner Class!! */)).doReadSync();
            if (!headerList.equals(costheaderList)) {
                throw new BusinessException("\u5217\u540d\u4e0d\u5339\u914d");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        this.costDao.deleteAlln(Long.parseLong(employeeID));
        System.out.println(dataList);
        this.costDao.insertBatchn(dataList);
        return ResponseDTO.okMsg((String)("\u6210\u529f\u5bfc\u5165" + dataList.size() + "\u6761\u6570\u636e"));
    }

    private ResponseDTO<String> parseOrderTime(NCostImportForm orderImportForm, AnalysisContext analysisContext) {
        String costTime = String.valueOf(orderImportForm.getCostTime());
        if (costTime == null || costTime.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u6536\u5165\u786e\u8ba4\u6708\u4efd\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        try {
            LocalDateTime orderDateTime = LocalDateTime.parse(costTime.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setCostTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + costTime + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        return ResponseDTO.ok();
    }

    private void processOrderJg(NCostImportForm orderImportForm) {
        String costCl = orderImportForm.getCostCl();
        String costRg = orderImportForm.getCostRg();
        String costFy = orderImportForm.getCostFy();
        if (costCl != null && !costCl.isEmpty()) {
            costCl = costCl.replaceAll(",", "");
            orderImportForm.setCostCl(costCl);
        }
        if (costRg != null && !costRg.isEmpty()) {
            costRg = costRg.replaceAll(",", "");
            orderImportForm.setCostRg(costRg);
        }
        if (costFy != null && !costFy.isEmpty()) {
            costFy = costFy.replaceAll(",", "");
            orderImportForm.setCostFy(costFy);
        }
    }

    private ResponseDTO<String> parseOrderTime2(CostImportForm orderImportForm, AnalysisContext analysisContext) {
        String costTime = String.valueOf(orderImportForm.getCostTime());
        if (costTime == null || costTime.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u6536\u5165\u786e\u8ba4\u6708\u4efd\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        try {
            LocalDateTime orderDateTime = LocalDateTime.parse(costTime.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setCostTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + costTime + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        return ResponseDTO.ok();
    }

    private void processOrderJg2(CostImportForm orderImportForm) {
        String costCl = orderImportForm.getCostCl();
        String costRg = orderImportForm.getCostRg();
        String costFy = orderImportForm.getCostFy();
        if (costCl != null && !costCl.isEmpty()) {
            costCl = costCl.replaceAll(",", "");
            orderImportForm.setCostCl(costCl);
        }
        if (costRg != null && !costRg.isEmpty()) {
            costRg = costRg.replaceAll(",", "");
            orderImportForm.setCostRg(costRg);
        }
        if (costFy != null && !costFy.isEmpty()) {
            costFy = costFy.replaceAll(",", "");
            orderImportForm.setCostFy(costFy);
        }
    }

    public void saveCosts(List<CostImportForm> costs) {
        List costEntities = costs.stream().map(costForm -> {
            CostEntity cost = new CostEntity();
            return cost;
        }).collect(Collectors.toList());
    }

    public List<CostExcelVO> getAllCost(String userId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)userId);
        List CostEntityList = this.costDao.selectList(wrapper);
        return CostEntityList.stream().map(e -> CostExcelVO.builder().costTime(e.getCostTime()).costCp(e.getCostCp()).costCl(e.getCostCl()).costRg(e.getCostRg()).costFy(e.getCostFy()).build()).collect(Collectors.toList());
    }

    public List<NCostExcelVO> getAllnCost(String userId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId);
        List CostEntityList = this.ncostDao.selectList(wrapper);
        return CostEntityList.stream().map(e -> NCostExcelVO.builder().costTime(e.getCostTime()).ncostKh(e.getNcostKh()).costCl(e.getCostCl()).costRg(e.getCostRg()).costFy(e.getCostFy()).build()).collect(Collectors.toList());
    }

    static /* synthetic */ ResponseDTO access$000(CostService x0, CostImportForm x1, AnalysisContext x2) {
        return x0.parseOrderTime2(x1, x2);
    }

    static /* synthetic */ void access$100(CostService x0, CostImportForm x1) {
        x0.processOrderJg2(x1);
    }

    static /* synthetic */ ResponseDTO access$200(CostService x0, NCostImportForm x1, AnalysisContext x2) {
        return x0.parseOrderTime(x1, x2);
    }

    static /* synthetic */ void access$300(CostService x0, NCostImportForm x1) {
        x0.processOrderJg(x1);
    }
}

