/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.service;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.dao.NewCwbbDao;
import net.lab1024.sa.admin.module.business.datafrom.dao.SLXDao;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.SLXEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.NewCwbbImportForm;
import net.lab1024.sa.admin.module.business.datafrom.service.ImportExcelService;
import net.lab1024.sa.admin.module.business.datafrom.service.NewCwbbService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.redis.RedisService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportExcelService {
    private static final Logger logger = LoggerFactory.getLogger(ImportExcelService.class);
    @Resource
    private RedisService redisService;
    @Resource
    private NewCwbbDao newCwbbDao;
    @Resource
    private SLXDao slxDao;
    @Resource
    private NewCwbbService newCwbbService;

    @Operation(summary="\u4e0a\u4f20Excel\u5e76\u8fd4\u56de\u8868\u5934\u5bf9\u5e94\u7684\u5b57\u6bb5")
    public List<Map<String, String>> processExcelFile(MultipartFile file, String employeeId) throws IOException {
        InputStream inputStream = file.getInputStream();
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        ArrayList excelData = new ArrayList();
        ArrayList<Map<String, String>> colList = new ArrayList<Map<String, String>>();
        int id = 0;
        for (int sheetNum = 0; sheetNum < 3; ++sheetNum) {
            Sheet sheet = workbook.getSheetAt(sheetNum);
            if (sheet == null) continue;
            for (int rowNum = 0; rowNum < sheet.getPhysicalNumberOfRows(); ++rowNum) {
                Row row = sheet.getRow(rowNum);
                if (row == null) continue;
                ArrayList<String> cellList = new ArrayList<String>();
                for (int celNum = 0; celNum < row.getPhysicalNumberOfCells(); ++celNum) {
                    Cell cell = row.getCell(celNum);
                    String cellValue = ImportExcelService.getCellValue((Cell)cell).trim();
                    cellList.add(celNum, cellValue);
                    if (celNum != 0 || rowNum == 0 || cell == null || cell.getCellType() != CellType.STRING) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", String.valueOf(id++));
                    map.put("name", cellValue);
                    colList.add(map);
                }
                excelData.add(rowNum, cellList);
            }
        }
        this.redisService.set((Object)(employeeId + "excel"), excelData, 108000L);
        workbook.close();
        return colList;
    }

    @Operation(summary="\u83b7\u53d6Excel\u6620\u5c04\u5e76\u5c06\u5bf9\u5e94Excel\u6570\u636e\u5b58\u5165\u6570\u636e\u5e93")
    public ResponseDTO<String> submitMapping(List<Map<String, String>> mappingList, String employeeId) {
        Gson gson = new Gson();
        Type excelDataType = new /* Unavailable Anonymous Inner Class!! */.getType();
        List excelData = (List)gson.fromJson(this.redisService.get(employeeId + "excel"), excelDataType);
        if (excelData == null) {
            logger.error("\u4eceRedis\u83b7\u53d6\u7684excelData\u4e3anull\uff0cemployeeId: {}", (Object)employeeId);
            return ResponseDTO.userErrorParam((String)"Excel\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6");
        }
        logger.info("\u4eceRedis\u83b7\u53d6\u7684excelData\u5927\u5c0f: {}", (Object)excelData.size());
        if (excelData.isEmpty()) {
            return ResponseDTO.userErrorParam((String)"Excel\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6");
        }
        List excelDateTitle = (List)excelData.get(0);
        HashMap<String, Integer> dbindex = new HashMap<String, Integer>();
        block2: for (Map<String, String> mapping : mappingList) {
            String excelTitle = mapping.get("excelTitle");
            for (int rowNum = 0; rowNum < excelData.size(); ++rowNum) {
                List excelvalue = (List)excelData.get(rowNum);
                if (excelvalue.isEmpty() || ((String)excelvalue.get(0)).equals("") || !((String)excelvalue.get(0)).equals(excelTitle)) continue;
                dbindex.put(mapping.get("dataIndex"), rowNum);
                continue block2;
            }
        }
        ArrayList<NewCwbbImportForm> newCwbbEntities = new ArrayList<NewCwbbImportForm>();
        ArrayList<SLXEntity> slxEntityList = new ArrayList<SLXEntity>();
        for (int cellNum = 1; cellNum < excelDateTitle.size(); ++cellNum) {
            NewCwbbImportForm newCwbbEntity;
            block9: {
                newCwbbEntity = new NewCwbbImportForm();
                String dateStr = (String)excelDateTitle.get(cellNum);
                if (dateStr != null && !dateStr.trim().isEmpty()) {
                    try {
                        newCwbbEntity.setNcwbbTime(LocalDateTime.parse(dateStr + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        break block9;
                    }
                    catch (DateTimeParseException e) {
                        System.err.println("\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: " + dateStr + "\uff0c\u9519\u8bef\u4fe1\u606f: " + e.getMessage());
                        continue;
                    }
                }
                System.err.println("\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5f53\u524d\u5355\u5143\u683c");
                continue;
            }
            newCwbbEntity.setUserId(Long.valueOf(employeeId));
            newCwbbEntity.setLdzczj(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbLdzczj"))).get(cellNum))));
            newCwbbEntity.setYszk(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYszk"))).get(cellNum))));
            newCwbbEntity.setCh(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbCh"))).get(cellNum))));
            newCwbbEntity.setFldzczj(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbFldzczj"))).get(cellNum))));
            newCwbbEntity.setYfzk(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYfzk"))).get(cellNum))));
            newCwbbEntity.setLdzcfzzj(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbLdzcfzzj"))).get(cellNum))));
            newCwbbEntity.setFldfz(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbFldfz"))).get(cellNum))));
            newCwbbEntity.setSyzqy(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbSyzqy"))).get(cellNum))));
            newCwbbEntity.setYysr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYysr"))).get(cellNum))));
            newCwbbEntity.setYycb(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYycb"))).get(cellNum))));
            newCwbbEntity.setXsfy(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbXsfy"))).get(cellNum))));
            newCwbbEntity.setGlfy(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbGlfy"))).get(cellNum))));
            newCwbbEntity.setCwfy(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbCwfy"))).get(cellNum))));
            newCwbbEntity.setYffy(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYffy"))).get(cellNum))));
            newCwbbEntity.setYysjjfj(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYysjjfj"))).get(cellNum))));
            newCwbbEntity.setYylr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbYylr"))).get(cellNum))));
            newCwbbEntity.setJlr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbJlr"))).get(cellNum))));
            newCwbbEntity.setJyhdxjlr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbJyhdxjlr"))).get(cellNum))));
            newCwbbEntity.setJyhdxjlc(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbJyhdxjlc"))).get(cellNum))));
            newCwbbEntity.setTzhdxjlr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbTzhdxjlr"))).get(cellNum))));
            newCwbbEntity.setTzhdxjlc(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbTzhdxjlc"))).get(cellNum))));
            newCwbbEntity.setCzhdxjlr(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbCzhdxjlr"))).get(cellNum))));
            newCwbbEntity.setCzhdxjlc(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbCzhdxjlc"))).get(cellNum))));
            newCwbbEntity.setXjjxjdjwjzje(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbXjjxjdjwjzje"))).get(cellNum))));
            newCwbbEntity.setJcqxjjxjdjwye(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbJcqxjjxjdjwye"))).get(cellNum))));
            newCwbbEntity.setQmxjjxjdjwye(ImportExcelService.convertToBigDecimal((String)((String)((List)excelData.get((Integer)dbindex.get("ncwbbQmxjjxjdjwye"))).get(cellNum))));
            BigDecimal xjl = null;
            if (newCwbbEntity.getJyhdxjlr() != null && newCwbbEntity.getJyhdxjlc() != null && newCwbbEntity.getTzhdxjlr() != null && newCwbbEntity.getTzhdxjlc() != null) {
                xjl = newCwbbEntity.getJyhdxjlr().subtract(newCwbbEntity.getJyhdxjlc()).add(newCwbbEntity.getTzhdxjlr().subtract(newCwbbEntity.getTzhdxjlc()));
            }
            SLXEntity slxEntity = new SLXEntity();
            slxEntity.setUserId(Long.valueOf(employeeId));
            slxEntity.setSlxTime(newCwbbEntity.getNcwbbTime());
            slxEntity.setSlxSr(newCwbbEntity.getYysr());
            slxEntity.setSlxLr(newCwbbEntity.getJlr());
            slxEntity.setSlxXjl(xjl);
            slxEntityList.add(slxEntity);
            newCwbbEntities.add(newCwbbEntity);
        }
        this.newCwbbDao.deleteAll(Long.parseLong(employeeId));
        this.newCwbbDao.insertBatch(newCwbbEntities);
        this.slxDao.deleteAll(Long.parseLong(employeeId));
        this.slxDao.insertBatch(slxEntityList);
        return ResponseDTO.okMsg((String)"\u5bfc\u5165\u6210\u529f");
    }

    @Operation(summary="Excel\u7edf\u4e00\u5927\u6570\u5b57\u8f6c\u6362")
    public static BigDecimal convertToBigDecimal(String input) {
        if (input == null || input.trim().isEmpty() || "--".equals(input.trim())) {
            return BigDecimal.ZERO;
        }
        Pattern pattern = Pattern.compile("(-?\\d+\\.\\d+|-?\\d+)([\u4e07\u4ebf\u5343]*)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String numberPart = matcher.group(1);
            String unitPart = matcher.group(2);
            BigDecimal multiplier = BigDecimal.ONE;
            switch (unitPart) {
                case "\u4ebf": {
                    multiplier = new BigDecimal("100000000");
                    break;
                }
                case "\u4e07": {
                    multiplier = new BigDecimal("10000");
                    break;
                }
                case "\u5343": {
                    multiplier = new BigDecimal("1000");
                    break;
                }
            }
            return new BigDecimal(numberPart).multiply(multiplier);
        }
        throw new IllegalArgumentException("String\u8f6cBigDecimal\u5931\u8d25\uff0c\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + input);
    }

    @Operation(summary="Excel\u7edf\u4e00\u5b57\u7b26\u4e32\u53d6\u503c")
    private static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (2.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 2: {
                return cell.getStringCellValue().trim();
            }
            case 1: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    return sdf.format(cell.getDateCellValue());
                }
                DecimalFormat df = new DecimalFormat("0");
                df.setMaximumFractionDigits(3);
                return df.format(cell.getNumericCellValue());
            }
            case 3: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 4: {
                Workbook workbook = cell.getSheet().getWorkbook();
                FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (2.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cellValue.getCellType().ordinal()]) {
                    case 1: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            return sdf.format(DateUtil.getJavaDate((double)cellValue.getNumberValue()));
                        }
                        DecimalFormat df = new DecimalFormat("0");
                        df.setMaximumFractionDigits(3);
                        return df.format(cellValue.getNumberValue());
                    }
                    case 2: {
                        return cellValue.getStringValue().trim();
                    }
                    case 3: {
                        return String.valueOf(cellValue.getBooleanValue());
                    }
                }
                return "";
            }
        }
        return "";
    }
}

