/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.dao.NSOrderDao;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.NSOrderEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.NSOrderImportForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.NSOrderQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.NSOrderExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.NSOrderVO;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NSOrderService {
    private static final Logger log = LoggerFactory.getLogger(NSOrderService.class);
    @Resource
    private NSOrderDao nsorderDao;

    public ResponseDTO<PageResult<NSOrderVO>> query(NSOrderQueryForm queryForm) {
        List list;
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)(list = this.nsorderDao.query(page, queryForm)));
        if (pageResult.getEmptyFlag().booleanValue()) {
            return ResponseDTO.ok((Object)pageResult);
        }
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<String> batchDelete(List<Long> nsorderIdList) {
        if (CollectionUtils.isEmpty(nsorderIdList)) {
            return ResponseDTO.ok();
        }
        this.nsorderDao.batchUpdateDeleted(nsorderIdList);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> importNSOrder(MultipartFile file, String userId) {
        ArrayList dataList = new ArrayList();
        ArrayList headerList = new ArrayList();
        List<String> nsorderheaderList = Arrays.asList("\u8ba2\u5355\u65e5\u671f", "\u8ba2\u5355\u7f16\u53f7", "\u5ba2\u6237\u540d\u79f0", "\u6e20\u9053\u540d\u79f0", "\u8ba2\u5355\u91d1\u989d", "\u6536\u5165\u786e\u8ba4\u65e5\u671f", "\u6536\u5165\u91d1\u989d", "\u56de\u6b3e\u65e5\u671f", "\u56de\u6b3e\u91d1\u989d");
        try {
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(NSOrderImportForm.class)).sheet().registerReadListener((ReadListener)new /* Unavailable Anonymous Inner Class!! */)).doReadSync();
            if (!headerList.equals(nsorderheaderList)) {
                return ResponseDTO.userErrorParam((String)"\u5217\u540d\u4e0d\u5339\u914d");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        this.nsorderDao.deleteAll(Long.parseLong(userId));
        this.nsorderDao.insertBatch(dataList);
        return ResponseDTO.okMsg((String)("\u6210\u529f\u5bfc\u5165" + dataList.size() + "\u6761\u6570\u636e"));
    }

    private ResponseDTO<String> parseOrderTime(NSOrderImportForm orderImportForm, AnalysisContext analysisContext) {
        LocalDateTime orderDateTime;
        String nsorderSignTime = String.valueOf(orderImportForm.getNsorderSignTime());
        String nsorderIncomeTime = String.valueOf(orderImportForm.getNsorderIncomeTime());
        String nsorderHkTime = String.valueOf(orderImportForm.getNsorderHkTime());
        if (nsorderSignTime == null || nsorderSignTime.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        if (nsorderIncomeTime == null || nsorderIncomeTime.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u6536\u5165\u786e\u8ba4\u65e5\u671f\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        if (nsorderHkTime == null || nsorderHkTime.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u56de\u6b3e\u65e5\u671f\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        try {
            orderDateTime = LocalDateTime.parse(nsorderSignTime.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setNsorderSignTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + nsorderSignTime + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        try {
            orderDateTime = LocalDateTime.parse(nsorderIncomeTime.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setNsorderIncomeTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u6536\u5165\u786e\u8ba4\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + nsorderIncomeTime + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        try {
            orderDateTime = LocalDateTime.parse(nsorderHkTime.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setNsorderHkTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u56de\u6b3e\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + nsorderHkTime + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        return ResponseDTO.ok();
    }

    private void processOrderJg(NSOrderImportForm orderImportForm) {
        String nsorderDdje = orderImportForm.getNsorderDdje();
        String nsorderSre = orderImportForm.getNsorderSre();
        String nsorderHke = orderImportForm.getNsorderHke();
        if (nsorderDdje != null && !nsorderDdje.isEmpty()) {
            nsorderDdje = nsorderDdje.replaceAll(",", "");
            orderImportForm.setNsorderDdje(nsorderDdje);
        }
        if (nsorderSre != null && !nsorderSre.isEmpty()) {
            nsorderSre = nsorderSre.replaceAll(",", "");
            orderImportForm.setNsorderSre(nsorderSre);
        }
        if (nsorderHke != null && !nsorderHke.isEmpty()) {
            nsorderHke = nsorderHke.replaceAll(",", "");
            orderImportForm.setNsorderHke(nsorderHke);
        }
    }

    public void saveNSOrders(List<NSOrderImportForm> nsorders) {
        List nsorderEntities = nsorders.stream().map(orderForm -> {
            NSOrderEntity nsorder = new NSOrderEntity();
            return nsorder;
        }).collect(Collectors.toList());
    }

    public List<NSOrderExcelVO> getAllNSOrder(String userId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId);
        List goodsEntityList = this.nsorderDao.selectList(wrapper);
        return goodsEntityList.stream().map(e -> NSOrderExcelVO.builder().nsorderSignTime(e.getNsorderSignTime()).nsorderNumber(e.getNsorderNumber()).nsorderKhmc(e.getNsorderKhmc()).nsorderQdmc(e.getNsorderQdmc()).nsorderDdje(e.getNsorderDdje()).nsorderIncomeTime(e.getNsorderIncomeTime()).nsorderSre(e.getNsorderSre()).nsorderHkTime(e.getNsorderHkTime()).nsorderHke(e.getNsorderHke()).build()).collect(Collectors.toList());
    }

    static /* synthetic */ ResponseDTO access$000(NSOrderService x0, NSOrderImportForm x1, AnalysisContext x2) {
        return x0.parseOrderTime(x1, x2);
    }

    static /* synthetic */ void access$100(NSOrderService x0, NSOrderImportForm x1) {
        x0.processOrderJg(x1);
    }
}

