/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.datafrom.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.dao.OrderDao;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.OrderEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.OrderImportForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.OrderQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.OrderExcelVO;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.OrderVO;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderService.class);
    @Resource
    private OrderDao orderDao;

    public ResponseDTO<PageResult<OrderVO>> query(OrderQueryForm queryForm) {
        List list;
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)(list = this.orderDao.query(page, queryForm)));
        if (pageResult.getEmptyFlag().booleanValue()) {
            return ResponseDTO.ok((Object)pageResult);
        }
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<String> batchDelete(List<Long> orderIdList) {
        if (CollectionUtils.isEmpty(orderIdList)) {
            return ResponseDTO.ok();
        }
        this.orderDao.batchUpdateDeleted(orderIdList);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> importOrder(MultipartFile file, String userId) {
        ArrayList dataList = new ArrayList();
        ArrayList headerList = new ArrayList();
        List<String> orderheaderList = Arrays.asList("\u8ba2\u5355\u65e5\u671f", "\u8ba2\u5355\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u6e20\u9053\u540d\u79f0", "\u9500\u91cf", "\u603b\u91d1\u989d");
        try {
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(OrderImportForm.class)).sheet().registerReadListener((ReadListener)new /* Unavailable Anonymous Inner Class!! */)).doReadSync();
            if (!headerList.equals(orderheaderList)) {
                return ResponseDTO.userErrorParam((String)"\u5217\u540d\u4e0d\u5339\u914d");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        this.orderDao.deleteAll(Long.parseLong(userId));
        this.orderDao.insertBatch(dataList);
        return ResponseDTO.okMsg((String)("\u6210\u529f\u5bfc\u5165" + dataList.size() + "\u6761\u6570\u636e"));
    }

    private ResponseDTO<String> parseOrderTime(OrderImportForm orderImportForm, AnalysisContext analysisContext) {
        String orderTimeStr = String.valueOf(orderImportForm.getOrderTime());
        if (orderTimeStr == null || orderTimeStr.trim().isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u4e3a\u7a7a\uff0c\u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}"));
        }
        try {
            LocalDateTime orderDateTime = LocalDateTime.parse(orderTimeStr.trim(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            orderImportForm.setOrderTime(orderDateTime);
        }
        catch (DateTimeParseException e) {
            return ResponseDTO.userErrorParam((String)("\u8ba2\u5355\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u65e5\u671f\u5b57\u7b26\u4e32: {" + orderTimeStr + "}, \u884c\u53f7: {" + analysisContext.readRowHolder().getRowIndex() + 1 + "}, \u9519\u8bef\u4fe1\u606f: {" + e.getMessage() + "}"));
        }
        return ResponseDTO.ok();
    }

    private void processOrderJg(OrderImportForm orderImportForm) {
        String orderJg = orderImportForm.getOrderJg();
        if (orderJg != null && !orderJg.isEmpty()) {
            orderJg = orderJg.replaceAll(",", "");
            orderImportForm.setOrderJg(orderJg);
        }
    }

    public void saveOrders(List<OrderImportForm> orders) {
        List orderEntities = orders.stream().map(orderForm -> {
            OrderEntity order = new OrderEntity();
            LocalDateTime orderTimeString = orderForm.getOrderTime();
            order.setOrderTime(orderTimeString);
            order.setOrderCp(order.getOrderCp());
            order.setOrderQd(order.getOrderQd());
            order.setOrderJg(order.getOrderJg());
            return order;
        }).collect(Collectors.toList());
    }

    public List<OrderExcelVO> getAllOrder(String userId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId);
        List goodsEntityList = this.orderDao.selectList(wrapper);
        return goodsEntityList.stream().map(e -> OrderExcelVO.builder().orderTime(e.getOrderTime()).orderNumber(e.getOrderNumber()).orderCp(e.getOrderCp()).orderQd(e.getOrderQd()).orderJg(e.getOrderJg()).orderXl(e.getOrderXl()).build()).collect(Collectors.toList());
    }

    static /* synthetic */ ResponseDTO access$000(OrderService x0, OrderImportForm x1, AnalysisContext x2) {
        return x0.parseOrderTime(x1, x2);
    }

    static /* synthetic */ void access$100(OrderService x0, OrderImportForm x1) {
        x0.processOrderJg(x1);
    }
}

