/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.goods.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsAddForm;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsQueryForm;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsUpdateForm;
import net.lab1024.sa.admin.module.business.goods.domain.vo.GoodsExcelVO;
import net.lab1024.sa.admin.module.business.goods.domain.vo.GoodsVO;
import net.lab1024.sa.admin.module.business.goods.service.GoodsService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import net.lab1024.sa.base.common.util.SmartExcelUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="ERP\u8fdb\u9500\u5b58-\u5546\u54c1\u7ba1\u7406")
public class GoodsController {
    @Resource
    private GoodsService goodsService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author \u80e1\u514b")
    @PostMapping(value={"/goods/query"})
    @SaCheckPermission(value={"goods:query"})
    public ResponseDTO<PageResult<GoodsVO>> query(@RequestBody @Valid GoodsQueryForm queryForm) {
        return this.goodsService.query(queryForm);
    }

    @Operation(summary="\u6dfb\u52a0\u5546\u54c1 @author \u80e1\u514b")
    @PostMapping(value={"/goods/add"})
    @SaCheckPermission(value={"goods:add"})
    public ResponseDTO<String> add(@RequestBody @Valid GoodsAddForm addForm) {
        return this.goodsService.add(addForm);
    }

    @Operation(summary="\u66f4\u65b0\u5546\u54c1 @author \u80e1\u514b")
    @PostMapping(value={"/goods/update"})
    @SaCheckPermission(value={"goods:update"})
    public ResponseDTO<String> update(@RequestBody @Valid GoodsUpdateForm updateForm) {
        return this.goodsService.update(updateForm);
    }

    @Operation(summary="\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/goods/delete/{goodsId}"})
    @SaCheckPermission(value={"goods:delete"})
    public ResponseDTO<String> delete(@PathVariable Long goodsId) {
        return this.goodsService.delete(goodsId);
    }

    @Operation(summary="\u6279\u91cf @author \u5353\u5927")
    @PostMapping(value={"/goods/batchDelete"})
    @SaCheckPermission(value={"goods:batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody @Valid ValidateList<Long> idList) {
        return this.goodsService.batchDelete(idList);
    }

    @Operation(summary="\u5bfc\u5165 @author \u5353\u5927")
    @PostMapping(value={"/goods/importGoods"})
    @SaCheckPermission(value={"goods:importGoods"})
    public ResponseDTO<String> importGoods(@RequestParam MultipartFile file) {
        return this.goodsService.importGoods(file);
    }

    @Operation(summary="\u5bfc\u51fa @author \u5353\u5927")
    @GetMapping(value={"/goods/exportGoods"})
    @SaCheckPermission(value={"goods:exportGoods"})
    public void exportGoods(HttpServletResponse response) throws IOException {
        List goodsList = this.goodsService.getAllGoods();
        SmartExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u5546\u54c1\u5217\u8868.xlsx", (String)"\u5546\u54c1", GoodsExcelVO.class, (Collection)goodsList);
    }

    @Operation(summary="\u4e0b\u8f7dexcel\u6a21\u677f")
    @GetMapping(value={"/goods/downloadOrder"})
    public void download(HttpServletResponse response) {
        String filename = "\u8ba2\u5355\u8868-\u6807\u51c6\u4e1a\u52a1.xlsx";
        String filepath = "sa-admin/src/files/\u8ba2\u5355\u8868-\u6807\u51c6\u4e1a\u52a1.xlsx";
        try {
            SmartExcelUtil.downloadExcel((HttpServletResponse)response, (String)filename, (String)filepath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

