/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.goods.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.category.constant.CategoryTypeEnum;
import net.lab1024.sa.admin.module.business.category.domain.entity.CategoryEntity;
import net.lab1024.sa.admin.module.business.category.service.CategoryQueryService;
import net.lab1024.sa.admin.module.business.goods.constant.GoodsStatusEnum;
import net.lab1024.sa.admin.module.business.goods.dao.GoodsDao;
import net.lab1024.sa.admin.module.business.goods.domain.entity.GoodsEntity;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsAddForm;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsImportForm;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsQueryForm;
import net.lab1024.sa.admin.module.business.goods.domain.form.GoodsUpdateForm;
import net.lab1024.sa.admin.module.business.goods.domain.vo.GoodsExcelVO;
import net.lab1024.sa.admin.module.business.goods.domain.vo.GoodsVO;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.exception.BusinessException;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartEnumUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import net.lab1024.sa.base.module.support.dict.service.DictCacheService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsService.class);
    @Resource
    private GoodsDao goodsDao;
    @Resource
    private CategoryQueryService categoryQueryService;
    @Resource
    private DataTracerService dataTracerService;
    @Resource
    private DictCacheService dictCacheService;

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> add(GoodsAddForm addForm) {
        ResponseDTO res = this.checkGoods(addForm);
        if (!res.getOk().booleanValue()) {
            return res;
        }
        GoodsEntity goodsEntity = (GoodsEntity)SmartBeanUtil.copy((Object)addForm, GoodsEntity.class);
        goodsEntity.setDeletedFlag(Boolean.FALSE);
        this.goodsDao.insert((Object)goodsEntity);
        this.dataTracerService.insert(goodsEntity.getGoodsId(), DataTracerTypeEnum.GOODS);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> update(GoodsUpdateForm updateForm) {
        ResponseDTO res = this.checkGoods((GoodsAddForm)updateForm);
        if (!res.getOk().booleanValue()) {
            return res;
        }
        GoodsEntity originEntity = (GoodsEntity)this.goodsDao.selectById((Serializable)updateForm.getGoodsId());
        GoodsEntity goodsEntity = (GoodsEntity)SmartBeanUtil.copy((Object)updateForm, GoodsEntity.class);
        this.goodsDao.updateById((Object)goodsEntity);
        this.dataTracerService.update(updateForm.getGoodsId(), DataTracerTypeEnum.GOODS, (Object)originEntity, (Object)goodsEntity);
        return ResponseDTO.ok();
    }

    private ResponseDTO<String> checkGoods(GoodsAddForm addForm) {
        Long categoryId = addForm.getCategoryId();
        Optional optional = this.categoryQueryService.queryCategory(categoryId);
        if (!optional.isPresent() || !CategoryTypeEnum.GOODS.equalsValue((Object)((CategoryEntity)optional.get()).getCategoryType())) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST, (String)"\u5546\u54c1\u7c7b\u76ee\u4e0d\u5b58\u5728~");
        }
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> delete(Long goodsId) {
        GoodsEntity goodsEntity = (GoodsEntity)this.goodsDao.selectById((Serializable)goodsId);
        if (goodsEntity == null) {
            return ResponseDTO.userErrorParam((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!goodsEntity.getGoodsStatus().equals(GoodsStatusEnum.SELL_OUT.getValue())) {
            return ResponseDTO.userErrorParam((String)"\u53ea\u6709\u552e\u7f44\u7684\u5546\u54c1\u624d\u53ef\u4ee5\u5220\u9664");
        }
        this.batchDelete(Collections.singletonList(goodsId));
        this.dataTracerService.batchDelete(Collections.singletonList(goodsId), DataTracerTypeEnum.GOODS);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchDelete(List<Long> goodsIdList) {
        if (CollectionUtils.isEmpty(goodsIdList)) {
            return ResponseDTO.ok();
        }
        this.goodsDao.batchUpdateDeleted(goodsIdList, Boolean.TRUE);
        return ResponseDTO.ok();
    }

    public ResponseDTO<PageResult<GoodsVO>> query(GoodsQueryForm queryForm) {
        queryForm.setDeletedFlag(Boolean.valueOf(false));
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List list = this.goodsDao.query(page, queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)list);
        if (pageResult.getEmptyFlag().booleanValue()) {
            return ResponseDTO.ok((Object)pageResult);
        }
        List categoryIdList = list.stream().map(GoodsVO::getCategoryId).distinct().collect(Collectors.toList());
        Map categoryMap = this.categoryQueryService.queryCategoryList(categoryIdList);
        list.forEach(e -> {
            CategoryEntity categoryEntity = (CategoryEntity)categoryMap.get(e.getCategoryId());
            if (categoryEntity != null) {
                e.setCategoryName(categoryEntity.getCategoryName());
            }
        });
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<String> importGoods(MultipartFile file) {
        List dataList;
        try {
            dataList = ((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(GoodsImportForm.class)).sheet().doReadSync();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u6570\u636e\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u65e0\u6cd5\u8bfb\u53d6");
        }
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        return ResponseDTO.okMsg((String)("\u6210\u529f\u5bfc\u5165" + dataList.size() + "\u6761\uff0c\u5177\u4f53\u6570\u636e\u4e3a\uff1a" + JSON.toJSONString((Object)dataList)));
    }

    public List<GoodsExcelVO> getAllGoods() {
        List goodsEntityList = this.goodsDao.selectList(null);
        return goodsEntityList.stream().map(e -> GoodsExcelVO.builder().goodsStatus(SmartEnumUtil.getEnumDescByValue((Object)e.getGoodsStatus(), GoodsStatusEnum.class)).categoryName(this.categoryQueryService.queryCategoryName(e.getCategoryId())).place(this.dictCacheService.selectValueNameByValueCode(e.getPlace())).price(e.getPrice()).goodsName(e.getGoodsName()).remark(e.getRemark()).build()).collect(Collectors.toList());
    }
}

