/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.bank;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.oa.bank.BankService;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankCreateForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankQueryForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankUpdateForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankVO;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="OA\u529e\u516c-\u94f6\u884c\u5361\u4fe1\u606f")
public class BankController {
    @Resource
    private BankService bankService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u94f6\u884c\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/bank/page/query"})
    public ResponseDTO<PageResult<BankVO>> queryByPage(@RequestBody @Valid BankQueryForm queryForm) {
        return this.bankService.queryByPage(queryForm);
    }

    @Operation(summary="\u6839\u636e\u4f01\u4e1aID\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u5217\u8868 @author \u5584\u9038")
    @GetMapping(value={"/oa/bank/query/list/{enterpriseId}"})
    public ResponseDTO<List<BankVO>> queryList(@PathVariable Long enterpriseId) {
        return this.bankService.queryList(enterpriseId);
    }

    @Operation(summary="\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u8be6\u60c5 @author \u5584\u9038")
    @GetMapping(value={"/oa/bank/get/{bankId}"})
    public ResponseDTO<BankVO> getDetail(@PathVariable Long bankId) {
        return this.bankService.getDetail(bankId);
    }

    @Operation(summary="\u65b0\u5efa\u94f6\u884c\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/bank/create"})
    public ResponseDTO<String> createBank(@RequestBody @Valid BankCreateForm createVO) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        createVO.setCreateUserId(requestUser.getUserId());
        createVO.setCreateUserName(requestUser.getUserName());
        return this.bankService.createBank(createVO);
    }

    @Operation(summary="\u7f16\u8f91\u94f6\u884c\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/bank/update"})
    public ResponseDTO<String> updateBank(@RequestBody @Valid BankUpdateForm updateVO) {
        return this.bankService.updateBank(updateVO);
    }

    @Operation(summary="\u5220\u9664\u94f6\u884c\u4fe1\u606f @author \u5584\u9038")
    @GetMapping(value={"/oa/bank/delete/{bankId}"})
    public ResponseDTO<String> deleteBank(@PathVariable Long bankId) {
        return this.bankService.deleteBank(bankId);
    }
}

