/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.bank;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.bank.BankDao;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankCreateForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankEntity;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankQueryForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankUpdateForm;
import net.lab1024.sa.admin.module.business.oa.bank.domain.BankVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.dao.EnterpriseDao;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.entity.EnterpriseEntity;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BankService {
    private static final Logger log = LoggerFactory.getLogger(BankService.class);
    @Resource
    private BankDao bankDao;
    @Resource
    private EnterpriseDao enterpriseDao;
    @Resource
    private DataTracerService dataTracerService;

    public ResponseDTO<PageResult<BankVO>> queryByPage(BankQueryForm queryForm) {
        queryForm.setDeletedFlag(Boolean.FALSE);
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List bankList = this.bankDao.queryPage(page, queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)bankList);
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<List<BankVO>> queryList(Long enterpriseId) {
        BankQueryForm queryForm = new BankQueryForm();
        queryForm.setEnterpriseId(enterpriseId);
        queryForm.setDeletedFlag(Boolean.FALSE);
        List bankList = this.bankDao.queryPage(null, queryForm);
        return ResponseDTO.ok((Object)bankList);
    }

    public ResponseDTO<BankVO> getDetail(Long bankId) {
        BankVO bankVO = this.bankDao.getDetail(bankId, Boolean.FALSE);
        if (Objects.isNull(bankVO)) {
            return ResponseDTO.userErrorParam((String)"\u94f6\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return ResponseDTO.ok((Object)bankVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> createBank(BankCreateForm createVO) {
        Long enterpriseId = createVO.getEnterpriseId();
        EnterpriseEntity enterpriseDetail = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (Objects.isNull(enterpriseDetail) || enterpriseDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        BankEntity validateBank = this.bankDao.queryByAccountNumber(enterpriseId, createVO.getAccountNumber(), null, Boolean.FALSE);
        if (Objects.nonNull(validateBank)) {
            return ResponseDTO.userErrorParam((String)"\u94f6\u884c\u4fe1\u606f\u8d26\u53f7\u91cd\u590d");
        }
        BankEntity insertBank = (BankEntity)SmartBeanUtil.copy((Object)createVO, BankEntity.class);
        this.bankDao.insert((Object)insertBank);
        this.dataTracerService.addTrace(enterpriseId, DataTracerTypeEnum.OA_ENTERPRISE, "\u65b0\u589e\u94f6\u884c:<br/>" + this.dataTracerService.getChangeContent((Object)insertBank));
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> updateBank(BankUpdateForm updateVO) {
        Long enterpriseId = updateVO.getEnterpriseId();
        EnterpriseEntity enterpriseDetail = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (Objects.isNull(enterpriseDetail) || enterpriseDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        Long bankId = updateVO.getBankId();
        BankEntity bankDetail = (BankEntity)this.bankDao.selectById((Serializable)bankId);
        if (Objects.isNull(bankDetail) || bankDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u94f6\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BankEntity validateBank = this.bankDao.queryByAccountNumber(updateVO.getEnterpriseId(), updateVO.getAccountNumber(), bankId, Boolean.FALSE);
        if (Objects.nonNull(validateBank)) {
            return ResponseDTO.userErrorParam((String)"\u94f6\u884c\u4fe1\u606f\u8d26\u53f7\u91cd\u590d");
        }
        BankEntity updateBank = (BankEntity)SmartBeanUtil.copy((Object)updateVO, BankEntity.class);
        this.bankDao.updateById((Object)updateBank);
        this.dataTracerService.addTrace(enterpriseId, DataTracerTypeEnum.OA_ENTERPRISE, "\u66f4\u65b0\u94f6\u884c:<br/>" + this.dataTracerService.getChangeContent((Object)bankDetail, (Object)updateBank));
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> deleteBank(Long bankId) {
        BankEntity bankDetail = (BankEntity)this.bankDao.selectById((Serializable)bankId);
        if (Objects.isNull(bankDetail) || bankDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u94f6\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.bankDao.deleteBank(bankId, Boolean.TRUE);
        this.dataTracerService.addTrace(bankDetail.getEnterpriseId(), DataTracerTypeEnum.OA_ENTERPRISE, "\u5220\u9664\u94f6\u884c:<br/>" + this.dataTracerService.getChangeContent((Object)bankDetail));
        return ResponseDTO.ok();
    }
}

