/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.enterprise;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.oa.enterprise.EnterpriseService;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseCreateForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseEmployeeForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseEmployeeQueryForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseQueryForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseUpdateForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseEmployeeVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseExcelVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseListVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseVO;
import net.lab1024.sa.admin.util.AdminRequestUtil;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartDateFormatterEnum;
import net.lab1024.sa.base.common.util.SmartExcelUtil;
import net.lab1024.sa.base.common.util.SmartLocalDateUtil;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.common.util.SmartResponseUtil;
import net.lab1024.sa.base.module.support.operatelog.annotation.OperateLog;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="OA\u529e\u516c-\u4f01\u4e1a")
@OperateLog
public class EnterpriseController {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseController.class);
    @Resource
    private EnterpriseService enterpriseService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u6a21\u5757 @author \u5f00\u4e91")
    @PostMapping(value={"/oa/enterprise/page/query"})
    @SaCheckPermission(value={"oa:enterprise:query"})
    public ResponseDTO<PageResult<EnterpriseVO>> queryByPage(@RequestBody @Valid EnterpriseQueryForm queryForm) {
        return this.enterpriseService.queryByPage(queryForm);
    }

    @Operation(summary="\u5bfc\u51fa\u4f01\u4e1a\u4fe1\u606f @author \u5353\u5927")
    @PostMapping(value={"/oa/enterprise/exportExcel"})
    public void exportExcel(@RequestBody @Valid EnterpriseQueryForm queryForm, HttpServletResponse response) throws IOException {
        List data = this.enterpriseService.getExcelExportData(queryForm);
        if (CollectionUtils.isEmpty((Collection)data)) {
            SmartResponseUtil.write((HttpServletResponse)response, (ResponseDTO)ResponseDTO.userErrorParam((String)"\u6682\u65e0\u6570\u636e"));
            return;
        }
        String watermark = AdminRequestUtil.getRequestUser().getActualName();
        watermark = watermark + SmartLocalDateUtil.format((LocalDateTime)LocalDateTime.now(), (SmartDateFormatterEnum)SmartDateFormatterEnum.YMD_HMS);
        SmartExcelUtil.exportExcelWithWatermark((HttpServletResponse)response, (String)"\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f.xlsx", (String)"\u4f01\u4e1a\u4fe1\u606f", EnterpriseExcelVO.class, (Collection)data, (String)watermark);
    }

    @Operation(summary="\u67e5\u8be2\u4f01\u4e1a\u8be6\u60c5 @author \u5f00\u4e91")
    @GetMapping(value={"/oa/enterprise/get/{enterpriseId}"})
    @SaCheckPermission(value={"oa:enterprise:detail"})
    public ResponseDTO<EnterpriseVO> getDetail(@PathVariable Long enterpriseId) {
        return ResponseDTO.ok((Object)this.enterpriseService.getDetail(enterpriseId));
    }

    @Operation(summary="\u65b0\u5efa\u4f01\u4e1a @author \u5f00\u4e91")
    @PostMapping(value={"/oa/enterprise/create"})
    @SaCheckPermission(value={"oa:enterprise:add"})
    public ResponseDTO<String> createEnterprise(@RequestBody @Valid EnterpriseCreateForm createVO) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        createVO.setCreateUserId(requestUser.getUserId());
        createVO.setCreateUserName(requestUser.getUserName());
        return this.enterpriseService.createEnterprise(createVO);
    }

    @Operation(summary="\u7f16\u8f91\u4f01\u4e1a @author \u5f00\u4e91")
    @PostMapping(value={"/oa/enterprise/update"})
    @SaCheckPermission(value={"oa:enterprise:update"})
    public ResponseDTO<String> updateEnterprise(@RequestBody @Valid EnterpriseUpdateForm updateVO) {
        return this.enterpriseService.updateEnterprise(updateVO);
    }

    @Operation(summary="\u5220\u9664\u4f01\u4e1a @author \u5f00\u4e91")
    @GetMapping(value={"/oa/enterprise/delete/{enterpriseId}"})
    @SaCheckPermission(value={"oa:enterprise:delete"})
    public ResponseDTO<String> deleteEnterprise(@PathVariable Long enterpriseId) {
        return this.enterpriseService.deleteEnterprise(enterpriseId);
    }

    @Operation(summary="\u6309\u7167\u7c7b\u578b\u67e5\u8be2\u4f01\u4e1a @author \u5f00\u4e91")
    @GetMapping(value={"/oa/enterprise/query/list"})
    public ResponseDTO<List<EnterpriseListVO>> queryList(@RequestParam(value="type", required=false) Integer type) {
        return this.enterpriseService.queryList(type);
    }

    @Operation(summary="\u4f01\u4e1a\u6dfb\u52a0\u5458\u5de5 @author \u7f57\u4f0a")
    @PostMapping(value={"/oa/enterprise/employee/add"})
    @SaCheckPermission(value={"oa:enterprise:addEmployee"})
    public ResponseDTO<String> addEmployee(@RequestBody @Valid EnterpriseEmployeeForm enterpriseEmployeeForm) {
        return this.enterpriseService.addEmployee(enterpriseEmployeeForm);
    }

    @Operation(summary="\u67e5\u8be2\u4f01\u4e1a\u5168\u90e8\u5458\u5de5 @author \u7f57\u4f0a")
    @PostMapping(value={"/oa/enterprise/employee/list"})
    public ResponseDTO<List<EnterpriseEmployeeVO>> employeeList(@RequestBody @Valid List<Long> enterpriseIdList) {
        return ResponseDTO.ok((Object)this.enterpriseService.employeeList(enterpriseIdList));
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u5458\u5de5 @author \u5353\u5927")
    @PostMapping(value={"/oa/enterprise/employee/queryPage"})
    public ResponseDTO<PageResult<EnterpriseEmployeeVO>> queryPageEmployeeList(@RequestBody @Valid EnterpriseEmployeeQueryForm queryForm) {
        return ResponseDTO.ok((Object)this.enterpriseService.queryPageEmployeeList(queryForm));
    }

    @Operation(summary="\u4f01\u4e1a\u5220\u9664\u5458\u5de5 @author \u7f57\u4f0a")
    @PostMapping(value={"/oa/enterprise/employee/delete"})
    @SaCheckPermission(value={"oa:enterprise:deleteEmployee"})
    public ResponseDTO<String> deleteEmployee(@RequestBody @Valid EnterpriseEmployeeForm enterpriseEmployeeForm) {
        return this.enterpriseService.deleteEmployee(enterpriseEmployeeForm);
    }
}

