/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.enterprise;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.enterprise.EnterpriseEmployeeManager;
import net.lab1024.sa.admin.module.business.oa.enterprise.dao.EnterpriseDao;
import net.lab1024.sa.admin.module.business.oa.enterprise.dao.EnterpriseEmployeeDao;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.entity.EnterpriseEmployeeEntity;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.entity.EnterpriseEntity;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseCreateForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseEmployeeForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseEmployeeQueryForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseQueryForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.form.EnterpriseUpdateForm;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseEmployeeVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseExcelVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseListVO;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseVO;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.domain.form.DataTracerForm;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriseService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseService.class);
    @Resource
    private EnterpriseDao enterpriseDao;
    @Resource
    private EnterpriseEmployeeDao enterpriseEmployeeDao;
    @Resource
    private EnterpriseEmployeeManager enterpriseEmployeeManager;
    @Resource
    private DataTracerService dataTracerService;
    @Resource
    private DepartmentService departmentService;

    public ResponseDTO<PageResult<EnterpriseVO>> queryByPage(EnterpriseQueryForm queryForm) {
        queryForm.setDeletedFlag(Boolean.FALSE);
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List enterpriseList = this.enterpriseDao.queryPage(page, queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)enterpriseList);
        return ResponseDTO.ok((Object)pageResult);
    }

    public List<EnterpriseExcelVO> getExcelExportData(EnterpriseQueryForm queryForm) {
        queryForm.setDeletedFlag(Boolean.valueOf(false));
        return this.enterpriseDao.selectExcelExportData(queryForm);
    }

    public EnterpriseVO getDetail(Long enterpriseId) {
        return this.enterpriseDao.getDetail(enterpriseId, Boolean.FALSE);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> createEnterprise(EnterpriseCreateForm createVO) {
        EnterpriseEntity validateEnterprise = this.enterpriseDao.queryByEnterpriseName(createVO.getEnterpriseName(), null, Boolean.FALSE);
        if (Objects.nonNull(validateEnterprise)) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u540d\u79f0\u91cd\u590d");
        }
        EnterpriseEntity insertEnterprise = (EnterpriseEntity)SmartBeanUtil.copy((Object)createVO, EnterpriseEntity.class);
        this.enterpriseDao.insert((Object)insertEnterprise);
        this.dataTracerService.insert(insertEnterprise.getEnterpriseId(), DataTracerTypeEnum.OA_ENTERPRISE);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> updateEnterprise(EnterpriseUpdateForm updateVO) {
        Long enterpriseId = updateVO.getEnterpriseId();
        EnterpriseEntity enterpriseDetail = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (Objects.isNull(enterpriseDetail) || enterpriseDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        EnterpriseEntity validateEnterprise = this.enterpriseDao.queryByEnterpriseName(updateVO.getEnterpriseName(), enterpriseId, Boolean.FALSE);
        if (Objects.nonNull(validateEnterprise)) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u540d\u79f0\u91cd\u590d");
        }
        EnterpriseEntity updateEntity = (EnterpriseEntity)SmartBeanUtil.copy((Object)enterpriseDetail, EnterpriseEntity.class);
        SmartBeanUtil.copyProperties((Object)updateVO, (Object)updateEntity);
        this.enterpriseDao.updateById((Object)updateEntity);
        DataTracerForm dataTracerForm = DataTracerForm.builder().dataId(updateVO.getEnterpriseId()).type(DataTracerTypeEnum.OA_ENTERPRISE).content("\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f").diffOld(this.dataTracerService.getChangeContent((Object)enterpriseDetail)).diffNew(this.dataTracerService.getChangeContent((Object)updateEntity)).build();
        this.dataTracerService.addTrace(dataTracerForm);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> deleteEnterprise(Long enterpriseId) {
        EnterpriseEntity enterpriseDetail = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (Objects.isNull(enterpriseDetail) || enterpriseDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        this.enterpriseDao.deleteEnterprise(enterpriseId, Boolean.TRUE);
        this.dataTracerService.delete(enterpriseId, DataTracerTypeEnum.OA_ENTERPRISE);
        return ResponseDTO.ok();
    }

    public ResponseDTO<List<EnterpriseListVO>> queryList(Integer type) {
        List enterpriseList = this.enterpriseDao.queryList(type, Boolean.FALSE, Boolean.FALSE);
        return ResponseDTO.ok((Object)enterpriseList);
    }

    public synchronized ResponseDTO<String> addEmployee(EnterpriseEmployeeForm enterpriseEmployeeForm) {
        Long enterpriseId = enterpriseEmployeeForm.getEnterpriseId();
        EnterpriseEntity enterpriseEntity = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (enterpriseEntity == null || enterpriseEntity.getDeletedFlag().booleanValue()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        List waitAddEmployeeIdList = enterpriseEmployeeForm.getEmployeeIdList();
        List enterpriseEmployeeEntityList = this.enterpriseEmployeeDao.selectByEnterpriseAndEmployeeIdList(enterpriseId, (Collection)waitAddEmployeeIdList);
        if (CollectionUtils.isNotEmpty((Collection)enterpriseEmployeeEntityList)) {
            List existEmployeeIdList = enterpriseEmployeeEntityList.stream().map(EnterpriseEmployeeEntity::getEmployeeId).collect(Collectors.toList());
            waitAddEmployeeIdList = waitAddEmployeeIdList.stream().filter(e -> !existEmployeeIdList.contains(e)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)waitAddEmployeeIdList)) {
            return ResponseDTO.ok();
        }
        ArrayList batchAddList = Lists.newArrayList();
        for (Long employeeId : waitAddEmployeeIdList) {
            EnterpriseEmployeeEntity enterpriseEmployeeEntity = new EnterpriseEmployeeEntity();
            enterpriseEmployeeEntity.setEnterpriseId(enterpriseId);
            enterpriseEmployeeEntity.setEmployeeId(employeeId);
            batchAddList.add(enterpriseEmployeeEntity);
        }
        this.enterpriseEmployeeManager.saveBatch((Collection)batchAddList);
        return ResponseDTO.ok();
    }

    public synchronized ResponseDTO<String> deleteEmployee(EnterpriseEmployeeForm enterpriseEmployeeForm) {
        Long enterpriseId = enterpriseEmployeeForm.getEnterpriseId();
        EnterpriseEntity enterpriseEntity = (EnterpriseEntity)this.enterpriseDao.selectById((Serializable)enterpriseId);
        if (enterpriseEntity == null || enterpriseEntity.getDeletedFlag().booleanValue()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        List waitDeleteEmployeeIdList = enterpriseEmployeeForm.getEmployeeIdList();
        this.enterpriseEmployeeDao.deleteByEnterpriseAndEmployeeIdList(enterpriseId, (Collection)waitDeleteEmployeeIdList);
        return ResponseDTO.ok();
    }

    public List<EnterpriseEmployeeVO> employeeList(List<Long> enterpriseIdList) {
        if (CollectionUtils.isEmpty(enterpriseIdList)) {
            return Lists.newArrayList();
        }
        return this.enterpriseEmployeeDao.selectByEnterpriseIdList(enterpriseIdList);
    }

    public PageResult<EnterpriseEmployeeVO> queryPageEmployeeList(EnterpriseEmployeeQueryForm queryForm) {
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List enterpriseEmployeeVOList = this.enterpriseEmployeeDao.queryPageEmployeeList(page, queryForm);
        for (EnterpriseEmployeeVO enterpriseEmployeeVO : enterpriseEmployeeVOList) {
            enterpriseEmployeeVO.setDepartmentName(this.departmentService.getDepartmentPath(enterpriseEmployeeVO.getDepartmentId()));
        }
        return SmartPageUtil.convert2PageResult((Page)page, (List)enterpriseEmployeeVOList);
    }
}

