/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.invoice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.oa.invoice.InvoiceService;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceAddForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceQueryForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceUpdateForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceVO;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.module.support.operatelog.annotation.OperateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="OA\u529e\u516c-\u53d1\u7968\u4fe1\u606f")
public class InvoiceController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceController.class);
    @Resource
    private InvoiceService invoiceService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u53d1\u7968\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/invoice/page/query"})
    public ResponseDTO<PageResult<InvoiceVO>> queryByPage(@RequestBody @Valid InvoiceQueryForm queryForm) {
        return this.invoiceService.queryByPage(queryForm);
    }

    @Operation(summary="\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u8be6\u60c5 @author \u5584\u9038")
    @GetMapping(value={"/oa/invoice/get/{invoiceId}"})
    public ResponseDTO<InvoiceVO> getDetail(@PathVariable Long invoiceId) {
        return this.invoiceService.getDetail(invoiceId);
    }

    @Operation(summary="\u65b0\u5efa\u53d1\u7968\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/invoice/create"})
    public ResponseDTO<String> createInvoice(@RequestBody @Valid InvoiceAddForm createVO) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        createVO.setCreateUserId(requestUser.getUserId());
        createVO.setCreateUserName(requestUser.getUserName());
        return this.invoiceService.createInvoice(createVO);
    }

    @Operation(summary="\u7f16\u8f91\u53d1\u7968\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/oa/invoice/update"})
    @OperateLog
    public ResponseDTO<String> updateInvoice(@RequestBody @Valid InvoiceUpdateForm updateVO) {
        return this.invoiceService.updateInvoice(updateVO);
    }

    @Operation(summary="\u5220\u9664\u53d1\u7968\u4fe1\u606f @author \u5584\u9038")
    @GetMapping(value={"/invoice/delete/{invoiceId}"})
    public ResponseDTO<String> deleteInvoice(@PathVariable Long invoiceId) {
        return this.invoiceService.deleteInvoice(invoiceId);
    }

    @Operation(summary="\u67e5\u8be2\u5217\u8868 @author lidoudou")
    @GetMapping(value={"/oa/invoice/query/list/{enterpriseId}"})
    public ResponseDTO<List<InvoiceVO>> queryList(@PathVariable Long enterpriseId) {
        return this.invoiceService.queryList(enterpriseId);
    }
}

