/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.invoice;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.enterprise.EnterpriseService;
import net.lab1024.sa.admin.module.business.oa.enterprise.domain.vo.EnterpriseVO;
import net.lab1024.sa.admin.module.business.oa.invoice.InvoiceDao;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceAddForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceEntity;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceQueryForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceUpdateForm;
import net.lab1024.sa.admin.module.business.oa.invoice.domain.InvoiceVO;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceService.class);
    @Resource
    private InvoiceDao invoiceDao;
    @Resource
    private EnterpriseService enterpriseService;
    @Resource
    private DataTracerService dataTracerService;

    public ResponseDTO<PageResult<InvoiceVO>> queryByPage(InvoiceQueryForm queryForm) {
        queryForm.setDeletedFlag(Boolean.FALSE);
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List invoiceList = this.invoiceDao.queryPage(page, queryForm);
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, (List)invoiceList);
        return ResponseDTO.ok((Object)pageResult);
    }

    public ResponseDTO<List<InvoiceVO>> queryList(Long enterpriseId) {
        InvoiceQueryForm queryForm = new InvoiceQueryForm();
        queryForm.setDeletedFlag(Boolean.FALSE);
        queryForm.setDisabledFlag(Boolean.FALSE);
        queryForm.setEnterpriseId(enterpriseId);
        List invoiceList = this.invoiceDao.queryPage(null, queryForm);
        return ResponseDTO.ok((Object)invoiceList);
    }

    public ResponseDTO<InvoiceVO> getDetail(Long invoiceId) {
        InvoiceVO invoiceVO = this.invoiceDao.getDetail(invoiceId, Boolean.FALSE);
        if (Objects.isNull(invoiceVO)) {
            return ResponseDTO.userErrorParam((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return ResponseDTO.ok((Object)invoiceVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> createInvoice(InvoiceAddForm createVO) {
        Long enterpriseId = createVO.getEnterpriseId();
        EnterpriseVO enterpriseVO = this.enterpriseService.getDetail(enterpriseId);
        if (Objects.isNull(enterpriseVO)) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        InvoiceEntity validateInvoice = this.invoiceDao.queryByAccountNumber(enterpriseId, createVO.getAccountNumber(), null, Boolean.FALSE);
        if (Objects.nonNull(validateInvoice)) {
            return ResponseDTO.userErrorParam((String)"\u53d1\u7968\u4fe1\u606f\u8d26\u53f7\u91cd\u590d");
        }
        InvoiceEntity insertInvoice = (InvoiceEntity)SmartBeanUtil.copy((Object)createVO, InvoiceEntity.class);
        this.invoiceDao.insert((Object)insertInvoice);
        this.dataTracerService.addTrace(enterpriseId, DataTracerTypeEnum.OA_ENTERPRISE, "\u65b0\u589e\u53d1\u7968\uff1a<br/>" + this.dataTracerService.getChangeContent((Object)insertInvoice));
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> updateInvoice(InvoiceUpdateForm updateVO) {
        Long enterpriseId = updateVO.getEnterpriseId();
        EnterpriseVO enterpriseVO = this.enterpriseService.getDetail(enterpriseId);
        if (Objects.isNull(enterpriseVO)) {
            return ResponseDTO.userErrorParam((String)"\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        Long invoiceId = updateVO.getInvoiceId();
        InvoiceEntity invoiceDetail = (InvoiceEntity)this.invoiceDao.selectById((Serializable)invoiceId);
        if (Objects.isNull(invoiceDetail) || invoiceDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        InvoiceEntity validateInvoice = this.invoiceDao.queryByAccountNumber(updateVO.getEnterpriseId(), updateVO.getAccountNumber(), invoiceId, Boolean.FALSE);
        if (Objects.nonNull(validateInvoice)) {
            return ResponseDTO.userErrorParam((String)"\u53d1\u7968\u4fe1\u606f\u8d26\u53f7\u91cd\u590d");
        }
        InvoiceEntity updateInvoice = (InvoiceEntity)SmartBeanUtil.copy((Object)updateVO, InvoiceEntity.class);
        this.invoiceDao.updateById((Object)updateInvoice);
        this.dataTracerService.addTrace(enterpriseId, DataTracerTypeEnum.OA_ENTERPRISE, "\u66f4\u65b0\u53d1\u7968\uff1a<br/>" + this.dataTracerService.getChangeContent((Object)invoiceDetail, (Object)updateInvoice));
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> deleteInvoice(Long invoiceId) {
        InvoiceEntity invoiceDetail = (InvoiceEntity)this.invoiceDao.selectById((Serializable)invoiceId);
        if (Objects.isNull(invoiceDetail) || invoiceDetail.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.invoiceDao.deleteInvoice(invoiceId, Boolean.TRUE);
        this.dataTracerService.addTrace(invoiceDetail.getEnterpriseId(), DataTracerTypeEnum.OA_ENTERPRISE, "\u5220\u9664\u53d1\u7968\uff1a<br/>" + this.dataTracerService.getChangeContent((Object)invoiceDetail));
        return ResponseDTO.ok();
    }
}

