/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.notice.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.hutool.extra.servlet.ServletUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeAddForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeEmployeeQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeUpdateForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeViewRecordQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeDetailVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeEmployeeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeTypeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeUpdateFormVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeViewRecordVO;
import net.lab1024.sa.admin.module.business.oa.notice.service.NoticeEmployeeService;
import net.lab1024.sa.admin.module.business.oa.notice.service.NoticeService;
import net.lab1024.sa.admin.module.business.oa.notice.service.NoticeTypeService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.module.support.operatelog.annotation.OperateLog;
import net.lab1024.sa.base.module.support.repeatsubmit.annoation.RepeatSubmit;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="OA\u529e\u516c-\u901a\u77e5\u516c\u544a")
@RestController
@OperateLog
public class NoticeController {
    @Resource
    private NoticeService noticeService;
    @Resource
    private NoticeTypeService noticeTypeService;
    @Resource
    private NoticeEmployeeService noticeEmployeeService;

    @Operation(summary="\u901a\u77e5\u516c\u544a\u7c7b\u578b-\u83b7\u53d6\u5168\u90e8 @author \u5353\u5927")
    @GetMapping(value={"/oa/noticeType/getAll"})
    public ResponseDTO<List<NoticeTypeVO>> getAll() {
        return ResponseDTO.ok((Object)this.noticeTypeService.getAll());
    }

    @Operation(summary="\u901a\u77e5\u516c\u544a\u7c7b\u578b-\u6dfb\u52a0 @author \u5353\u5927")
    @GetMapping(value={"/oa/noticeType/add/{name}"})
    public ResponseDTO<String> add(@PathVariable String name) {
        return this.noticeTypeService.add(name);
    }

    @Operation(summary="\u901a\u77e5\u516c\u544a\u7c7b\u578b-\u4fee\u6539 @author \u5353\u5927")
    @GetMapping(value={"/oa/noticeType/update/{noticeTypeId}/{name}"})
    public ResponseDTO<String> update(@PathVariable Long noticeTypeId, @PathVariable String name) {
        return this.noticeTypeService.update(noticeTypeId, name);
    }

    @Operation(summary="\u901a\u77e5\u516c\u544a\u7c7b\u578b-\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/oa/noticeType/delete/{noticeTypeId}"})
    public ResponseDTO<String> deleteNoticeType(@PathVariable Long noticeTypeId) {
        return this.noticeTypeService.delete(noticeTypeId);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u901a\u77e5\u516c\u544a-\u5206\u9875\u67e5\u8be2 @author \u5353\u5927")
    @PostMapping(value={"/oa/notice/query"})
    @SaCheckPermission(value={"oa:notice:query"})
    public ResponseDTO<PageResult<NoticeVO>> query(@RequestBody @Valid NoticeQueryForm queryForm) {
        return ResponseDTO.ok((Object)this.noticeService.query(queryForm));
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u901a\u77e5\u516c\u544a-\u6dfb\u52a0 @author \u5353\u5927")
    @PostMapping(value={"/oa/notice/add"})
    @RepeatSubmit
    @SaCheckPermission(value={"oa:notice:add"})
    public ResponseDTO<String> add(@RequestBody @Valid NoticeAddForm addForm) {
        addForm.setCreateUserId(SmartRequestUtil.getRequestUserId());
        return this.noticeService.add(addForm);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u901a\u77e5\u516c\u544a-\u66f4\u65b0 @author \u5353\u5927")
    @PostMapping(value={"/oa/notice/update"})
    @RepeatSubmit
    @SaCheckPermission(value={"oa:notice:update"})
    public ResponseDTO<String> update(@RequestBody @Valid NoticeUpdateForm updateForm) {
        return this.noticeService.update(updateForm);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u901a\u77e5\u516c\u544a-\u66f4\u65b0\u8be6\u60c5 @author \u5353\u5927")
    @GetMapping(value={"/oa/notice/getUpdateVO/{noticeId}"})
    @SaCheckPermission(value={"oa:notice:update"})
    public ResponseDTO<NoticeUpdateFormVO> getUpdateFormVO(@PathVariable Long noticeId) {
        return ResponseDTO.ok((Object)this.noticeService.getUpdateFormVO(noticeId));
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u901a\u77e5\u516c\u544a-\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/oa/notice/delete/{noticeId}"})
    @SaCheckPermission(value={"oa:notice:delete"})
    public ResponseDTO<String> delete(@PathVariable Long noticeId) {
        return this.noticeService.delete(noticeId);
    }

    @Operation(summary="\u3010\u5458\u5de5\u3011\u901a\u77e5\u516c\u544a-\u67e5\u770b\u8be6\u60c5 @author \u5353\u5927")
    @GetMapping(value={"/oa/notice/employee/view/{noticeId}"})
    public ResponseDTO<NoticeDetailVO> view(@PathVariable Long noticeId, HttpServletRequest request) {
        return this.noticeEmployeeService.view(SmartRequestUtil.getRequestUserId(), noticeId, ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]), request.getHeader("User-Agent"));
    }

    @Operation(summary="\u3010\u5458\u5de5\u3011\u901a\u77e5\u516c\u544a-\u67e5\u8be2\u5168\u90e8 @author \u5353\u5927")
    @PostMapping(value={"/oa/notice/employee/query"})
    public ResponseDTO<PageResult<NoticeEmployeeVO>> queryEmployeeNotice(@RequestBody @Valid NoticeEmployeeQueryForm noticeEmployeeQueryForm) {
        return this.noticeEmployeeService.queryList(SmartRequestUtil.getRequestUserId(), noticeEmployeeQueryForm);
    }

    @Operation(summary="\u3010\u5458\u5de5\u3011\u901a\u77e5\u516c\u544a-\u67e5\u8be2 \u67e5\u770b\u8bb0\u5f55 @author \u5353\u5927")
    @PostMapping(value={"/oa/notice/employee/queryViewRecord"})
    public ResponseDTO<PageResult<NoticeViewRecordVO>> queryViewRecord(@RequestBody @Valid NoticeViewRecordQueryForm noticeViewRecordQueryForm) {
        return ResponseDTO.ok((Object)this.noticeEmployeeService.queryViewRecord(noticeViewRecordQueryForm));
    }
}

