/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.notice.manager;

import java.util.List;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.notice.dao.NoticeDao;
import net.lab1024.sa.admin.module.business.oa.notice.domain.entity.NoticeEntity;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeVisibleRangeForm;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoticeManager {
    @Resource
    private NoticeDao noticeDao;
    @Resource
    private DataTracerService dataTracerService;

    @Transactional(rollbackFor={Throwable.class})
    public void save(NoticeEntity noticeEntity, List<NoticeVisibleRangeForm> visibleRangeFormList) {
        this.noticeDao.insert((Object)noticeEntity);
        Long noticeId = noticeEntity.getNoticeId();
        if (CollectionUtils.isNotEmpty(visibleRangeFormList)) {
            this.noticeDao.insertVisibleRange(noticeId, visibleRangeFormList);
        }
        this.dataTracerService.insert(noticeId, DataTracerTypeEnum.OA_NOTICE);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void update(NoticeEntity old, NoticeEntity noticeEntity, List<NoticeVisibleRangeForm> visibleRangeList) {
        this.noticeDao.updateById((Object)noticeEntity);
        Long noticeId = noticeEntity.getNoticeId();
        if (CollectionUtils.isNotEmpty(visibleRangeList)) {
            this.noticeDao.deleteVisibleRange(noticeId);
            this.noticeDao.insertVisibleRange(noticeId, visibleRangeList);
        }
        this.dataTracerService.update(noticeId, DataTracerTypeEnum.OA_NOTICE, (Object)old, (Object)noticeEntity);
    }
}

