/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.notice.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.notice.constant.NoticeVisibleRangeDataTypeEnum;
import net.lab1024.sa.admin.module.business.oa.notice.dao.NoticeDao;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeEmployeeQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeViewRecordQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeDetailVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeEmployeeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeUpdateFormVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeViewRecordVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeVisibleRangeVO;
import net.lab1024.sa.admin.module.business.oa.notice.service.NoticeService;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.admin.module.system.employee.service.EmployeeService;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import org.springframework.stereotype.Service;

@Service
public class NoticeEmployeeService {
    @Resource
    private NoticeDao noticeDao;
    @Resource
    private NoticeService noticeService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private EmployeeService employeeService;

    public ResponseDTO<PageResult<NoticeEmployeeVO>> queryList(Long requestEmployeeId, NoticeEmployeeQueryForm noticeEmployeeQueryForm) {
        Page page = SmartPageUtil.convert2PageQuery((PageParam)noticeEmployeeQueryForm);
        List employeeDepartmentIdList = Lists.newArrayList();
        EmployeeEntity employeeEntity = this.employeeService.getById(requestEmployeeId);
        if (employeeEntity.getDepartmentId() != null) {
            employeeDepartmentIdList = this.departmentService.selfAndChildrenIdList(employeeEntity.getDepartmentId());
        }
        List noticeList = null;
        noticeList = noticeEmployeeQueryForm.getNotViewFlag() != null && noticeEmployeeQueryForm.getNotViewFlag() != false ? this.noticeDao.queryEmployeeNotViewNotice(page, requestEmployeeId, noticeEmployeeQueryForm, employeeDepartmentIdList, false, employeeEntity.getAdministratorFlag().booleanValue(), NoticeVisibleRangeDataTypeEnum.DEPARTMENT.getValue(), NoticeVisibleRangeDataTypeEnum.EMPLOYEE.getValue()) : this.noticeDao.queryEmployeeNotice(page, requestEmployeeId, noticeEmployeeQueryForm, employeeDepartmentIdList, false, employeeEntity.getAdministratorFlag().booleanValue(), NoticeVisibleRangeDataTypeEnum.DEPARTMENT.getValue(), NoticeVisibleRangeDataTypeEnum.EMPLOYEE.getValue());
        noticeList.forEach(notice -> notice.setPublishDate(notice.getPublishTime().toLocalDate()));
        return ResponseDTO.ok((Object)SmartPageUtil.convert2PageResult((Page)page, (List)noticeList));
    }

    public ResponseDTO<NoticeDetailVO> view(Long requestEmployeeId, Long noticeId, String ip, String userAgent) {
        NoticeUpdateFormVO updateFormVO = this.noticeService.getUpdateFormVO(noticeId);
        if (updateFormVO == null || Boolean.TRUE.equals(updateFormVO.getDeletedFlag())) {
            return ResponseDTO.userErrorParam((String)"\u901a\u77e5\u516c\u544a\u4e0d\u5b58\u5728");
        }
        EmployeeEntity employeeEntity = this.employeeService.getById(requestEmployeeId);
        if (!updateFormVO.getAllVisibleFlag().booleanValue() && !this.checkVisibleRange(updateFormVO.getVisibleRangeList(), requestEmployeeId, employeeEntity.getDepartmentId())) {
            return ResponseDTO.userErrorParam((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5185\u5bb9");
        }
        NoticeDetailVO noticeDetailVO = (NoticeDetailVO)SmartBeanUtil.copy((Object)updateFormVO, NoticeDetailVO.class);
        long viewCount = this.noticeDao.viewRecordCount(noticeId, requestEmployeeId);
        if (viewCount == 0L) {
            this.noticeDao.insertViewRecord(noticeId, requestEmployeeId, ip, userAgent, Integer.valueOf(1));
        } else {
            this.noticeDao.updateViewRecord(noticeId, requestEmployeeId, ip, userAgent);
        }
        return ResponseDTO.ok((Object)noticeDetailVO);
    }

    public boolean checkVisibleRange(List<NoticeVisibleRangeVO> visibleRangeList, Long employeeId, Long departmentId) {
        boolean anyMatch = visibleRangeList.stream().anyMatch(e -> NoticeVisibleRangeDataTypeEnum.EMPLOYEE.equalsValue((Object)e.getDataType()) && Objects.equals(e.getDataId(), employeeId));
        if (anyMatch) {
            return true;
        }
        List visibleDepartmentIdList = visibleRangeList.stream().filter(e -> NoticeVisibleRangeDataTypeEnum.DEPARTMENT.equalsValue((Object)e.getDataType())).map(NoticeVisibleRangeVO::getDataId).collect(Collectors.toList());
        for (Long visibleDepartmentId : visibleDepartmentIdList) {
            List departmentIdList = this.departmentService.selfAndChildrenIdList(visibleDepartmentId);
            if (!departmentIdList.contains(departmentId)) continue;
            return true;
        }
        return false;
    }

    public PageResult<NoticeViewRecordVO> queryViewRecord(NoticeViewRecordQueryForm noticeViewRecordQueryForm) {
        Page page = SmartPageUtil.convert2PageQuery((PageParam)noticeViewRecordQueryForm);
        List noticeViewRecordList = this.noticeDao.queryNoticeViewRecordList(page, noticeViewRecordQueryForm);
        return SmartPageUtil.convert2PageResult((Page)page, (List)noticeViewRecordList);
    }
}

