/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.oa.notice.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.oa.notice.constant.NoticeVisibleRangeDataTypeEnum;
import net.lab1024.sa.admin.module.business.oa.notice.dao.NoticeDao;
import net.lab1024.sa.admin.module.business.oa.notice.domain.entity.NoticeEntity;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeAddForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeQueryForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeUpdateForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.form.NoticeVisibleRangeForm;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeTypeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeUpdateFormVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeVO;
import net.lab1024.sa.admin.module.business.oa.notice.domain.vo.NoticeVisibleRangeVO;
import net.lab1024.sa.admin.module.business.oa.notice.manager.NoticeManager;
import net.lab1024.sa.admin.module.business.oa.notice.service.NoticeTypeService;
import net.lab1024.sa.admin.module.system.department.dao.DepartmentDao;
import net.lab1024.sa.admin.module.system.department.domain.entity.DepartmentEntity;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.admin.module.system.employee.dao.EmployeeDao;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.datatracer.constant.DataTracerTypeEnum;
import net.lab1024.sa.base.module.support.datatracer.service.DataTracerService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class NoticeService {
    @Resource
    private NoticeDao noticeDao;
    @Resource
    private NoticeManager noticeManager;
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private NoticeTypeService noticeTypeService;
    @Resource
    private DataTracerService dataTracerService;

    public PageResult<NoticeVO> query(NoticeQueryForm queryForm) {
        Page page = SmartPageUtil.convert2PageQuery((PageParam)queryForm);
        List list = this.noticeDao.query(page, queryForm);
        LocalDateTime now = LocalDateTime.now();
        list.forEach(e -> e.setPublishFlag(Boolean.valueOf(e.getPublishTime().isBefore(now))));
        return SmartPageUtil.convert2PageResult((Page)page, (List)list);
    }

    public ResponseDTO<String> add(NoticeAddForm addForm) {
        ResponseDTO validate = this.checkAndBuildVisibleRange(addForm);
        if (!validate.getOk().booleanValue()) {
            return ResponseDTO.error((ResponseDTO)validate);
        }
        NoticeEntity noticeEntity = (NoticeEntity)SmartBeanUtil.copy((Object)addForm, NoticeEntity.class);
        if (!addForm.getScheduledPublishFlag().booleanValue()) {
            noticeEntity.setPublishTime(LocalDateTime.now());
        }
        this.noticeManager.save(noticeEntity, addForm.getVisibleRangeList());
        return ResponseDTO.ok();
    }

    private ResponseDTO<String> checkAndBuildVisibleRange(NoticeAddForm form) {
        List dbDeptIdList;
        Collection subtract;
        List dbEmployeeIdList;
        Collection subtract2;
        NoticeTypeVO noticeType = this.noticeTypeService.getByNoticeTypeId(form.getNoticeTypeId());
        if (noticeType == null) {
            return ResponseDTO.userErrorParam((String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        if (form.getAllVisibleFlag().booleanValue()) {
            return ResponseDTO.ok();
        }
        List visibleRangeUpdateList = form.getVisibleRangeList();
        if (CollectionUtils.isEmpty((Collection)visibleRangeUpdateList)) {
            return ResponseDTO.userErrorParam((String)"\u672a\u8bbe\u7f6e\u53ef\u89c1\u8303\u56f4");
        }
        List employeeIdList = visibleRangeUpdateList.stream().filter(e -> NoticeVisibleRangeDataTypeEnum.EMPLOYEE.equalsValue((Object)e.getDataType())).map(NoticeVisibleRangeForm::getDataId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(employeeIdList) && !(subtract2 = CollectionUtils.subtract(employeeIdList = employeeIdList.stream().distinct().collect(Collectors.toList()), dbEmployeeIdList = this.employeeDao.selectBatchIds(employeeIdList).stream().map(EmployeeEntity::getEmployeeId).collect(Collectors.toList()))).isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u5458\u5de5id\u4e0d\u5b58\u5728\uff1a" + subtract2));
        }
        List deptIdList = visibleRangeUpdateList.stream().filter(e -> NoticeVisibleRangeDataTypeEnum.DEPARTMENT.equalsValue((Object)e.getDataType())).map(NoticeVisibleRangeForm::getDataId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deptIdList) && !(subtract = CollectionUtils.subtract(deptIdList = deptIdList.stream().distinct().collect(Collectors.toList()), dbDeptIdList = this.departmentDao.selectBatchIds(deptIdList).stream().map(DepartmentEntity::getDepartmentId).collect(Collectors.toList()))).isEmpty()) {
            return ResponseDTO.userErrorParam((String)("\u90e8\u95e8id\u4e0d\u5b58\u5728\uff1a" + subtract));
        }
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> update(NoticeUpdateForm updateForm) {
        NoticeEntity oldNoticeEntity = (NoticeEntity)this.noticeDao.selectById((Serializable)updateForm.getNoticeId());
        if (oldNoticeEntity == null) {
            return ResponseDTO.userErrorParam((String)"\u901a\u77e5\u4e0d\u5b58\u5728");
        }
        ResponseDTO res = this.checkAndBuildVisibleRange((NoticeAddForm)updateForm);
        if (!res.getOk().booleanValue()) {
            return ResponseDTO.error((ResponseDTO)res);
        }
        NoticeEntity noticeEntity = (NoticeEntity)SmartBeanUtil.copy((Object)updateForm, NoticeEntity.class);
        this.noticeManager.update(oldNoticeEntity, noticeEntity, updateForm.getVisibleRangeList());
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> delete(Long noticeId) {
        NoticeEntity noticeEntity = (NoticeEntity)this.noticeDao.selectById((Serializable)noticeId);
        if (null == noticeEntity || noticeEntity.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u901a\u77e5\u516c\u544a\u4e0d\u5b58\u5728");
        }
        this.noticeDao.updateDeletedFlag(noticeId);
        this.dataTracerService.delete(noticeId, DataTracerTypeEnum.OA_NOTICE);
        return ResponseDTO.ok();
    }

    public NoticeUpdateFormVO getUpdateFormVO(Long noticeId) {
        NoticeEntity noticeEntity = (NoticeEntity)this.noticeDao.selectById((Serializable)noticeId);
        if (null == noticeEntity) {
            return null;
        }
        NoticeUpdateFormVO updateFormVO = (NoticeUpdateFormVO)SmartBeanUtil.copy((Object)noticeEntity, NoticeUpdateFormVO.class);
        if (!updateFormVO.getAllVisibleFlag().booleanValue()) {
            List noticeVisibleRangeList = this.noticeDao.queryVisibleRange(noticeId);
            List employeeIdList = noticeVisibleRangeList.stream().filter(e -> NoticeVisibleRangeDataTypeEnum.EMPLOYEE.getValue().equals(e.getDataType())).map(NoticeVisibleRangeVO::getDataId).collect(Collectors.toList());
            Map<Object, Object> employeeMap = null;
            employeeMap = CollectionUtils.isNotEmpty(employeeIdList) ? this.employeeDao.selectBatchIds(employeeIdList).stream().collect(Collectors.toMap(EmployeeEntity::getEmployeeId, Function.identity())) : Maps.newHashMap();
            for (NoticeVisibleRangeVO noticeVisibleRange : noticeVisibleRangeList) {
                if (noticeVisibleRange.getDataType().equals(NoticeVisibleRangeDataTypeEnum.EMPLOYEE.getValue())) {
                    EmployeeEntity employeeEntity = (EmployeeEntity)employeeMap.get(noticeVisibleRange.getDataId());
                    noticeVisibleRange.setDataName(employeeEntity == null ? "" : employeeEntity.getActualName());
                    continue;
                }
                DepartmentVO departmentVO = this.departmentService.getDepartmentById(noticeVisibleRange.getDataId());
                noticeVisibleRange.setDataName(departmentVO == null ? "" : departmentVO.getName());
            }
            updateFormVO.setVisibleRangeList(noticeVisibleRangeList);
        }
        return updateFormVO;
    }
}

