/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.SLXEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.IndustryEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.PfbSheetEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.TreeNode;
import net.lab1024.sa.admin.module.business.xmfmodel.service.IndustryService;
import net.lab1024.sa.admin.module.business.xmfmodel.service.ZhpfSurveyService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7efc\u5408\u8bc4\u5206")
@RestController
public class ZhpfController {
    @Resource
    private ZhpfSurveyService zhpfSurveyService;
    @Resource
    private IndustryService industryService;

    @Operation(summary="\u83b7\u53d6\u884c\u4e1a\u6570\u636e")
    @PostMapping(value={"/zhpf/getIndustry"})
    public ResponseDTO<List<IndustryEntity>> getIndustry(@RequestBody Map<String, String> params) {
        String userId = params.get("userId");
        return this.industryService.query(Long.parseLong(userId));
    }

    @Operation(summary="\u83b7\u53d6\u884c\u4e1a\u6811")
    @PostMapping(value={"/zhpf/getATTIAData"})
    @SaCheckPermission(value={"industry:query"})
    public ResponseDTO<List<TreeNode>> getATTIAData() {
        return this.industryService.queryATTIAData();
    }

    @Operation(summary="\u83b7\u53d6\u884c\u4e1a\u5177\u4f53\u6570\u636e")
    @PostMapping(value={"/zhpf/getATTIADataTarget"})
    @SaCheckPermission(value={"industry:query"})
    public ResponseDTO<List<IndustryEntity>> getATTIADataTarget(@RequestBody Map<String, String> params) {
        String industryID = params.get("industryID");
        return this.industryService.getATTIADataTarget(industryID);
    }

    @Operation(summary="\u4fdd\u5b58\u884c\u4e1a\u5177\u4f53\u6570\u636e")
    @PostMapping(value={"/zhpf/saveATTIADataTarget"})
    @SaCheckPermission(value={"industry:submit"})
    public ResponseDTO<List<IndustryEntity>> saveATTIADataTarget(@RequestBody Map<String, String> params) {
        String industryID = params.get("industryID");
        String userID = params.get("userID");
        return this.industryService.saveATTIADataTarget(industryID, userID);
    }

    @Operation(summary="\u66f4\u65b0\u884c\u4e1a\u6570\u636e")
    @PostMapping(value={"/zhpf/updateIndustry"})
    public ResponseDTO<String> updateIndustry(@RequestBody Map<String, String> params) {
        String userId = params.get("industryID");
        return this.industryService.update(params);
    }

    @Operation(summary="\u83b7\u53d6\u8bc4\u5206\u8868")
    @PostMapping(value={"/zhpf/getPfbSheet"})
    public ResponseDTO<List<PfbSheetEntity>> getPfbSheet(@RequestBody Map<String, String> params) {
        String userId = params.get("userId");
        return this.zhpfSurveyService.queryPfbSheet(Long.parseLong(userId));
    }

    @Operation(summary="\u83b7\u53d6\u6536\u5165\u76ee\u6807\u5b8c\u6210\u7387\u7684\u503c")
    @PostMapping(value={"/zhpf/getSrmbwcl"})
    public ResponseDTO<BigDecimal> getSrmbwcl(@RequestBody Map<String, String> params) {
        String employeeID = params.get("employeeID");
        return this.zhpfSurveyService.getSrmbwcl(employeeID);
    }

    @Operation(summary="\u83b7\u53d6\u6536\u5165\u76ee\u6807\u5b8c\u6210\u7387\u7684\u503c")
    @PostMapping(value={"/zhpf/getLrmbwcl"})
    public ResponseDTO<BigDecimal> getLrmbwcl(@RequestBody Map<String, String> params) {
        String userId = params.get("employeeID");
        return this.zhpfSurveyService.getLrmbwcl(userId);
    }

    @Operation(summary="\u83b7\u53d6\u6536\u5165\u5229\u6da6\u73b0\u91d1\u6d41\u67f1\u72b6\u56fe\u6240\u9700\u7684\u6570\u636e")
    @PostMapping(value={"/zhpf/getSLXData"})
    public ResponseDTO<List<SLXEntity>> getSLXData(@RequestBody Map<String, String> params) {
        String userId = params.get("employeeID");
        return this.zhpfSurveyService.getSLXData(userId);
    }

    @Operation(summary="\u83b7\u53d6\u96f7\u8fbe\u56fe\u6240\u9700\u6570\u636e")
    @PostMapping(value={"/zhpf/getJddfData"})
    public ResponseDTO<Map<Integer, List<BigDecimal>>> getJddfData(@RequestBody Map<String, String> params) {
        return this.zhpfSurveyService.getPFBData(params);
    }

    @Operation(summary="\u83b7\u53d6\u96f7\u8fbe\u56fe\u94bb\u53d6\u6570\u636e")
    @PostMapping(value={"/zhpf/getDrillData"})
    public ResponseDTO<List<PfbSheetEntity>> getDrillData(@RequestBody Map<String, String> params) {
        return this.zhpfSurveyService.getDrillData(params);
    }
}

