/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.MonthDataDao;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.CostMonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.CwbbMonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.GlbbData;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.GlbbDataTwo;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.MaoriMonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.OrderMonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.QueryField;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.GlbbDataN;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.GlbbDataN2;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.MonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.utils.ReportTypeService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GlbbService {
    private static final Logger log = LoggerFactory.getLogger(GlbbService.class);
    @Resource
    private MonthDataDao monthDataDao;

    public ResponseDTO<List<GlbbDataN>> getMonthDataNorm(String userId, String selectedValue) {
        List srmonthEntities = this.monthDataDao.querySrFromCwbb(Long.parseLong(userId));
        List cbmonthEntities = this.monthDataDao.queryCbFromCwbb(Long.parseLong(userId));
        List mlmonthEntities = this.monthDataDao.queryMlFromCwbb(Long.parseLong(userId));
        List mllmonthEntities = this.monthDataDao.queryMllFromCwbb(Long.parseLong(userId));
        List fymonthEntities = this.monthDataDao.queryFyDataById(Long.parseLong(userId));
        List fylmonthEntities = this.monthDataDao.queryFylDataById(Long.parseLong(userId));
        List jlmonthEntities = this.monthDataDao.queryJlDataById(Long.parseLong(userId));
        List jllmonthEntities = this.monthDataDao.queryJllDataById(Long.parseLong(userId));
        ArrayList<GlbbDataN> glbbDataNList = new ArrayList<GlbbDataN>();
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userId));
        if (cwbbTimeList == null || cwbbTimeList.isEmpty()) {
            return ResponseDTO.userErrorParam((String)"\u8d22\u52a1\u62a5\u8868\u672a\u5bfc\u5165\uff0c\u8bf7\u5bfc\u5165\u8d22\u52a1\u62a5\u8868");
        }
        String grading = "";
        if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.YEARLY) {
            grading = "2";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.QUARTERLY) {
            grading = "1";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.MONTHLY) {
            grading = "0";
        } else {
            return ResponseDTO.userErrorParam((String)"\u8d22\u52a1\u62a5\u8868\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u5bfc\u5165\u6708\u5ea6/\u5b63\u5ea6/\u5e74\u5ea6\u62a5\u8868");
        }
        GlbbDataN Sr = GlbbService.calculateYoYAndMoM_NCP((List)srmonthEntities, (String)"\u6536\u5165", (String)"A", (String)grading);
        glbbDataNList.add(Sr);
        GlbbDataN Cb = GlbbService.calculateYoYAndMoM_NCP((List)cbmonthEntities, (String)"\u6210\u672c", (String)"A", (String)grading);
        glbbDataNList.add(Cb);
        GlbbDataN Ml = GlbbService.calculateYoYAndMoM_NCP((List)mlmonthEntities, (String)"\u6bdb\u5229", (String)"A", (String)grading);
        glbbDataNList.add(Ml);
        GlbbDataN Mll = GlbbService.calculateYoYAndMoM_NCP((List)mllmonthEntities, (String)"\u6bdb\u5229\u7387", (String)"B", (String)grading);
        glbbDataNList.add(Mll);
        GlbbDataN Fy = GlbbService.calculateYoYAndMoM_NCP((List)fymonthEntities, (String)"\u8d39\u7528", (String)"A", (String)grading);
        glbbDataNList.add(Fy);
        GlbbDataN Fyl = GlbbService.calculateYoYAndMoM_NCP((List)fylmonthEntities, (String)"\u8d39\u7528\u7387", (String)"C", (String)grading);
        glbbDataNList.add(Fyl);
        GlbbDataN Jl = GlbbService.calculateYoYAndMoM_NCP((List)jlmonthEntities, (String)"\u51c0\u5229", (String)"A", (String)grading);
        glbbDataNList.add(Jl);
        GlbbDataN Jll = GlbbService.calculateYoYAndMoM_NCP((List)jllmonthEntities, (String)"\u51c0\u5229\u7387", (String)"C", (String)grading);
        glbbDataNList.add(Jll);
        YearMonth maxTime = glbbDataNList.stream().map(GlbbDataN::getCurrentTime).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("\u672a\u627e\u5230\u6700\u5927\u7684 currentTime"));
        for (GlbbDataN data : glbbDataNList) {
            if (data.getCurrentTime().equals(maxTime)) continue;
            data.setCurrentTime(maxTime);
            data.setCurrentmonthData(BigDecimal.ZERO);
            data.setCurrentmonthDataHB(BigDecimal.ZERO);
            data.setCurrentmonthDataTB(BigDecimal.ZERO);
        }
        return ResponseDTO.ok(glbbDataNList);
    }

    public ResponseDTO<List<GlbbDataN>> getMonthDataNotNorm(String userId, String selectedValue) {
        List ddsmonthEntities = this.monthDataDao.querynDdsDataById(Long.parseLong(userId));
        List ddemonthEntities = this.monthDataDao.querynDdeDataById(Long.parseLong(userId));
        List hkemonthEntities = this.monthDataDao.querynHkeDataById(Long.parseLong(userId));
        List sremonthEntities = this.monthDataDao.querySrFromCwbb(Long.parseLong(userId));
        List ncbmonthEntities = this.monthDataDao.queryCbFromCwbb(Long.parseLong(userId));
        List nmlmonthEntities = this.monthDataDao.queryMlFromCwbb(Long.parseLong(userId));
        List nmllmonthEntities = this.monthDataDao.queryMllFromCwbb(Long.parseLong(userId));
        List fymonthEntities = this.monthDataDao.queryFyDataById(Long.parseLong(userId));
        List fylmonthEntities = this.monthDataDao.queryFylDataById(Long.parseLong(userId));
        List jlmonthEntities = this.monthDataDao.queryJlDataById(Long.parseLong(userId));
        List jllmonthEntities = this.monthDataDao.queryJllDataById(Long.parseLong(userId));
        ArrayList<GlbbDataN> glbbDataNList = new ArrayList<GlbbDataN>();
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userId));
        if (cwbbTimeList == null || cwbbTimeList.isEmpty()) {
            return ResponseDTO.userErrorParam((String)"\u8d22\u52a1\u62a5\u8868\u672a\u5bfc\u5165\uff0c\u8bf7\u5bfc\u5165\u8d22\u52a1\u62a5\u8868");
        }
        String grading = "";
        if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.YEARLY) {
            grading = "2";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.QUARTERLY) {
            grading = "1";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.MONTHLY) {
            grading = "0";
        } else {
            return ResponseDTO.userErrorParam((String)"\u672a\u77e5\u62a5\u8868\uff0c\u8bf7\u5bfc\u5165\u6708\u5ea6/\u5b63\u5ea6/\u5e74\u5ea6\u62a5\u8868");
        }
        GlbbDataN Sre = GlbbService.calculateYoYAndMoM_NCP((List)sremonthEntities, (String)"\u6536\u5165\u989d", (String)"A", (String)grading);
        glbbDataNList.add(Sre);
        GlbbDataN Dds = GlbbService.calculateYoYAndMoM_NCP((List)ddsmonthEntities, (String)"\u8ba2\u5355\u6570", (String)"A", (String)grading);
        glbbDataNList.add(Dds);
        GlbbDataN Dde = GlbbService.calculateYoYAndMoM_NCP((List)ddemonthEntities, (String)"\u8ba2\u5355\u989d", (String)"A", (String)grading);
        glbbDataNList.add(Dde);
        GlbbDataN Hke = GlbbService.calculateYoYAndMoM_NCP((List)hkemonthEntities, (String)"\u56de\u6b3e\u989d", (String)"A", (String)grading);
        glbbDataNList.add(Hke);
        GlbbDataN nCb = GlbbService.calculateYoYAndMoM_NCP((List)ncbmonthEntities, (String)"\u6210\u672c", (String)"A", (String)grading);
        glbbDataNList.add(nCb);
        GlbbDataN nMl = GlbbService.calculateYoYAndMoM_NCP((List)nmlmonthEntities, (String)"\u6bdb\u5229", (String)"A", (String)grading);
        glbbDataNList.add(nMl);
        GlbbDataN nMll = GlbbService.calculateYoYAndMoM_NCP((List)nmllmonthEntities, (String)"\u6bdb\u5229\u7387", (String)"B", (String)grading);
        glbbDataNList.add(nMll);
        GlbbDataN Fy = GlbbService.calculateYoYAndMoM_NCP((List)fymonthEntities, (String)"\u8d39\u7528", (String)"A", (String)grading);
        glbbDataNList.add(Fy);
        GlbbDataN Fyl = GlbbService.calculateYoYAndMoM_NCP((List)fylmonthEntities, (String)"\u8d39\u7528\u7387", (String)"C", (String)grading);
        glbbDataNList.add(Fyl);
        GlbbDataN Jl = GlbbService.calculateYoYAndMoM_NCP((List)jlmonthEntities, (String)"\u51c0\u5229", (String)"A", (String)grading);
        glbbDataNList.add(Jl);
        GlbbDataN Jll = GlbbService.calculateYoYAndMoM_NCP((List)jllmonthEntities, (String)"\u51c0\u5229\u7387", (String)"C", (String)grading);
        glbbDataNList.add(Jll);
        YearMonth maxTime = glbbDataNList.stream().map(GlbbDataN::getCurrentTime).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("\u672a\u627e\u5230\u6700\u5927\u7684 currentTime"));
        for (GlbbDataN data : glbbDataNList) {
            if (data.getCurrentTime().equals(maxTime)) continue;
            data.setCurrentTime(maxTime);
            data.setCurrentmonthData(BigDecimal.ZERO);
            data.setCurrentmonthDataHB(BigDecimal.ZERO);
            data.setCurrentmonthDataTB(BigDecimal.ZERO);
        }
        return ResponseDTO.ok(glbbDataNList);
    }

    public static GlbbDataN calculateYoYAndMoM_NCP(List<MonthEntity> monthEntities, String type, String method, String grading) {
        BigDecimal currentYearSr;
        ArrayList<YearMonth> months = new ArrayList<YearMonth>();
        for (MonthEntity monthEntity : monthEntities) {
            months.add(monthEntity.getDataMonth());
        }
        Collections.sort(months);
        YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
        YearMonth previousMonthTime = currentTime.minusMonths(1L);
        YearMonth previousQuarterTime = currentTime.minusMonths(4L);
        YearMonth previousYearTime = currentTime.minusYears(1L);
        BigDecimal currentMonthData = new BigDecimal(0);
        BigDecimal previousMonthData = new BigDecimal(0);
        BigDecimal previousYearData = new BigDecimal(0);
        if (grading.equals("0")) {
            currentMonthData = GlbbService.getMonthData(monthEntities, (YearMonth)currentTime);
            previousMonthData = GlbbService.getMonthData(monthEntities, (YearMonth)previousMonthTime);
            previousYearData = GlbbService.getMonthData(monthEntities, (YearMonth)previousYearTime);
        } else if (grading.equals("1")) {
            BigDecimal previousYearSr;
            BigDecimal previousSr;
            BigDecimal currentSr;
            if (method.equals("A")) {
                currentMonthData = GlbbService.getQuarterData(monthEntities, (YearMonth)currentTime);
                previousMonthData = GlbbService.getQuarterData(monthEntities, (YearMonth)previousQuarterTime);
                previousYearData = GlbbService.getQuarterData(monthEntities, (YearMonth)previousYearTime);
            } else if (method.equals("B")) {
                currentSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)currentTime);
                previousSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)previousQuarterTime);
                previousYearSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)previousYearTime);
                BigDecimal currentCb = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)currentTime);
                BigDecimal previousCb = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)previousQuarterTime);
                BigDecimal previousYearCb = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)previousYearTime);
                currentMonthData = currentSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentSr.subtract(currentCb).divide(currentSr, 10, RoundingMode.HALF_UP);
                previousMonthData = previousSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : previousSr.subtract(previousCb).divide(previousSr, 10, RoundingMode.HALF_UP);
                previousYearData = previousYearSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : previousYearSr.subtract(previousYearCb).divide(previousYearSr, 10, RoundingMode.HALF_UP);
            } else if (method.equals("C")) {
                currentSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)currentTime);
                previousSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)previousQuarterTime);
                previousYearSr = GlbbService.getQuarterAssist1(monthEntities, (YearMonth)previousYearTime);
                BigDecimal currentFyorJl = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)currentTime);
                BigDecimal previousFyorJl = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)previousQuarterTime);
                BigDecimal previousYearFyorJl = GlbbService.getQuarterAssist2(monthEntities, (YearMonth)previousYearTime);
                currentMonthData = currentSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentFyorJl.divide(currentSr, 10, RoundingMode.HALF_UP);
                previousMonthData = previousSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : previousFyorJl.divide(previousSr, 10, RoundingMode.HALF_UP);
                previousYearData = previousYearSr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : previousYearFyorJl.divide(previousYearSr, 10, RoundingMode.HALF_UP);
            }
        } else if (grading.equals("2")) {
            currentMonthData = GlbbService.getMonthData(monthEntities, (YearMonth)currentTime);
            previousMonthData = previousYearData = GlbbService.getMonthData(monthEntities, (YearMonth)previousYearTime);
        }
        BigDecimal yoy = new BigDecimal(0);
        BigDecimal mom = new BigDecimal(0);
        if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
            mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
        } else {
            mom = BigDecimal.ZERO;
            System.out.println("\u4e0a\u4e2a\u6708\u6ca1\u6709\u6570\u636e\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
        }
        if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
            yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
        } else {
            mom = BigDecimal.ZERO;
            System.out.println("\u4e0a\u5e74\u540c\u671f\u6ca1\u6709\u6570\u636e\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
        }
        BigDecimal currentYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearyoy = BigDecimal.ZERO;
        if (method.equals("A")) {
            for (YearMonth yearMonth : months) {
                if (yearMonth.getYear() == currentTime.getYear()) {
                    currentYearCumulative = currentYearCumulative.add(GlbbService.getMonthData(monthEntities, (YearMonth)yearMonth));
                    continue;
                }
                if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                previousYearCumulative = previousYearCumulative.add(GlbbService.getMonthData(monthEntities, (YearMonth)yearMonth));
            }
            if (previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0) {
                previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
            } else {
                previousYearyoy = BigDecimal.ZERO;
                System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
            }
        } else if (method.equals("B")) {
            currentYearSr = BigDecimal.ZERO;
            BigDecimal currentYearCb = BigDecimal.ZERO;
            BigDecimal previousYearSr = BigDecimal.ZERO;
            BigDecimal previousYearCb = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                if (yearMonth.getYear() == currentTime.getYear()) {
                    currentYearSr = currentYearSr.add(GlbbService.getMonthDataAssist1(monthEntities, (YearMonth)yearMonth));
                    currentYearCb = currentYearCb.add(GlbbService.getMonthDataAssist2(monthEntities, (YearMonth)yearMonth));
                    continue;
                }
                if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                previousYearSr = previousYearSr.add(GlbbService.getMonthDataAssist1(monthEntities, (YearMonth)yearMonth));
                previousYearCb = previousYearCb.add(GlbbService.getMonthDataAssist2(monthEntities, (YearMonth)yearMonth));
            }
            currentYearCumulative = currentYearSr.compareTo(BigDecimal.valueOf(0L)) != 0 ? currentYearSr.subtract(currentYearCb).divide(currentYearSr, 10, 4) : BigDecimal.ZERO;
            previousYearCumulative = previousYearSr.compareTo(BigDecimal.valueOf(0L)) != 0 ? previousYearSr.subtract(previousYearCb).divide(previousYearSr, 10, 4) : BigDecimal.ZERO;
            previousYearyoy = previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0 ? currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        } else if (method.equals("C")) {
            currentYearSr = BigDecimal.ZERO;
            BigDecimal currentYearFyorJl = BigDecimal.ZERO;
            BigDecimal previousYearSr = BigDecimal.ZERO;
            BigDecimal previousYearFyorJl = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                if (yearMonth.getYear() == currentTime.getYear()) {
                    currentYearSr = currentYearSr.add(GlbbService.getMonthDataAssist1(monthEntities, (YearMonth)yearMonth));
                    currentYearFyorJl = currentYearFyorJl.add(GlbbService.getMonthDataAssist2(monthEntities, (YearMonth)yearMonth));
                    continue;
                }
                if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                previousYearSr = previousYearSr.add(GlbbService.getMonthDataAssist1(monthEntities, (YearMonth)yearMonth));
                previousYearFyorJl = previousYearFyorJl.add(GlbbService.getMonthDataAssist2(monthEntities, (YearMonth)yearMonth));
            }
            currentYearCumulative = currentYearSr.compareTo(BigDecimal.valueOf(0L)) != 0 ? currentYearFyorJl.divide(currentYearSr, 10, 4) : BigDecimal.ZERO;
            previousYearCumulative = previousYearSr.compareTo(BigDecimal.valueOf(0L)) != 0 ? previousYearFyorJl.divide(previousYearSr, 10, 4) : BigDecimal.ZERO;
            previousYearyoy = previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0 ? currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        }
        GlbbDataN glbbDataN = new GlbbDataN();
        glbbDataN.setDataType(type);
        glbbDataN.setCurrentTime(currentTime);
        glbbDataN.setCurrentmonthData(currentMonthData.setScale(2, 4));
        glbbDataN.setCurrentmonthDataHB(mom.setScale(2, 4));
        glbbDataN.setCurrentmonthDataTB(yoy.setScale(2, 4));
        glbbDataN.setCurrentYearData(currentYearCumulative.setScale(2, 4));
        glbbDataN.setCurrentYearDataTB(previousYearyoy.setScale(2, 4));
        glbbDataN.setCwbbType(grading);
        return glbbDataN;
    }

    public ResponseDTO<Map<String, List<GlbbDataN2>>> getNameMonthDataNorm(String userId, String selectedValue) {
        List srmonthEntities = this.monthDataDao.querySrNameDataById(Long.parseLong(userId), null);
        List cbmonthEntities = this.monthDataDao.queryCbNameDataById(Long.parseLong(userId), null);
        List mlmonthEntities = this.monthDataDao.queryMlNameDataById(Long.parseLong(userId), null);
        List mllmonthEntities = this.monthDataDao.queryMllNameDataById(Long.parseLong(userId), null);
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userId));
        if (cwbbTimeList == null || cwbbTimeList.isEmpty()) {
            return ResponseDTO.userErrorParam((String)"\u8d22\u52a1\u62a5\u8868\u672a\u5bfc\u5165\uff0c\u8bf7\u5bfc\u5165\u8d22\u52a1\u62a5\u8868");
        }
        String grading = "";
        if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.YEARLY) {
            grading = "2";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.QUARTERLY) {
            grading = "1";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.MONTHLY) {
            grading = "0";
        } else {
            return ResponseDTO.userErrorParam((String)"\u672a\u77e5\u62a5\u8868\uff0c\u8bf7\u5bfc\u5165\u6708\u5ea6/\u5b63\u5ea6/\u5e74\u5ea6\u62a5\u8868");
        }
        List sr = GlbbService.calculateYoYAndMoM_CP((List)srmonthEntities, (String)"\u6536\u5165", (String)"A", (String)grading);
        List cb = GlbbService.calculateYoYAndMoM_CP((List)cbmonthEntities, (String)"\u6210\u672c", (String)"A", (String)grading);
        List ml = GlbbService.calculateYoYAndMoM_CP((List)mlmonthEntities, (String)"\u6bdb\u5229", (String)"A", (String)grading);
        List mll = GlbbService.calculateYoYAndMoM_CP((List)mllmonthEntities, (String)"\u6bdb\u5229\u7387", (String)"B", (String)grading);
        ArrayList allList = new ArrayList();
        allList.addAll(sr);
        allList.addAll(cb);
        allList.addAll(ml);
        allList.addAll(mll);
        Map categorizedData = this.adjustList(allList);
        YearMonth maxTime = categorizedData.values().stream().flatMap(Collection::stream).map(GlbbDataN2::getCurrentTime).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("\u672a\u627e\u5230\u6700\u5927\u7684 currentTime"));
        for (List productDataList : categorizedData.values()) {
            for (GlbbDataN2 glbbDataN2 : productDataList) {
                if (glbbDataN2.getCurrentTime().equals(maxTime)) continue;
                glbbDataN2.setCurrentTime(maxTime);
                glbbDataN2.setCurrentmonthData(BigDecimal.ZERO);
                glbbDataN2.setCurrentmonthDataHB(BigDecimal.ZERO);
                glbbDataN2.setCurrentmonthDataTB(BigDecimal.ZERO);
            }
        }
        ArrayList sortedEntries = new ArrayList(categorizedData.entrySet());
        sortedEntries.sort((entry1, entry2) -> {
            BigDecimal revenue1 = this.getRevenueValue((List)entry1.getValue());
            BigDecimal revenue2 = this.getRevenueValue((List)entry2.getValue());
            return revenue2.compareTo(revenue1);
        });
        LinkedHashMap sortedCategorizedData = new LinkedHashMap();
        for (Map.Entry entry : sortedEntries) {
            sortedCategorizedData.put(entry.getKey(), entry.getValue());
        }
        return ResponseDTO.ok(sortedCategorizedData);
    }

    private BigDecimal getRevenueValue(List<GlbbDataN2> dataList) {
        for (GlbbDataN2 data : dataList) {
            if (!"\u6536\u5165".equals(data.getDataType())) continue;
            return data.getCurrentmonthData();
        }
        return BigDecimal.ZERO;
    }

    private Map<String, List<GlbbDataN2>> adjustList(List<GlbbDataN2> allList) {
        if (allList == null) {
            return Collections.emptyMap();
        }
        return allList.stream().collect(Collectors.groupingBy(GlbbDataN2::getDataName, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(GlbbDataN2::getCurrentmonthData, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList()))));
    }

    public ResponseDTO<Map<String, List<GlbbDataN2>>> getNameMonthDataNotNorm(String userId, String selectedValue) {
        List sremonthEntities = this.monthDataDao.querynSreNameDataById(Long.parseLong(userId), null);
        List ddsmonthEntities = this.monthDataDao.querynDdsNameDataById(Long.parseLong(userId), null);
        List ddemonthEntities = this.monthDataDao.querynDdeNameDataById(Long.parseLong(userId), null);
        List hkemonthEntities = this.monthDataDao.querynHkeNameDataById(Long.parseLong(userId), null);
        List ncbmonthEntities = this.monthDataDao.querynCbNameDataById(Long.parseLong(userId), null);
        List nmlmonthEntities = this.monthDataDao.querynMlNameDataById(Long.parseLong(userId), null);
        List nmllmonthEntities = this.monthDataDao.querynMllNameDataById(Long.parseLong(userId), null);
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userId));
        if (cwbbTimeList == null || cwbbTimeList.isEmpty()) {
            return ResponseDTO.userErrorParam((String)"\u8d22\u52a1\u62a5\u8868\u672a\u5bfc\u5165\uff0c\u8bf7\u5bfc\u5165\u8d22\u52a1\u62a5\u8868");
        }
        String grading = "";
        if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.YEARLY) {
            grading = "2";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.QUARTERLY) {
            grading = "1";
        } else if (ReportTypeService.determineReportType((List)cwbbTimeList) == ReportTypeService.ReportType.MONTHLY) {
            grading = "0";
        } else {
            return ResponseDTO.userErrorParam((String)"\u672a\u77e5\u62a5\u8868\uff0c\u8bf7\u5bfc\u5165\u6708\u5ea6/\u5b63\u5ea6/\u5e74\u5ea6\u62a5\u8868");
        }
        List Sre = GlbbService.calculateYoYAndMoM_CP((List)sremonthEntities, (String)"\u6536\u5165\u989d", (String)"A", (String)grading);
        List Dds = GlbbService.calculateYoYAndMoM_CP((List)ddsmonthEntities, (String)"\u8ba2\u5355\u6570", (String)"A", (String)grading);
        List Dde = GlbbService.calculateYoYAndMoM_CP((List)ddemonthEntities, (String)"\u8ba2\u5355\u989d", (String)"A", (String)grading);
        List Hke = GlbbService.calculateYoYAndMoM_CP((List)hkemonthEntities, (String)"\u56de\u6b3e\u989d", (String)"A", (String)grading);
        List nCb = GlbbService.calculateYoYAndMoM_CP((List)ncbmonthEntities, (String)"\u6210\u672c", (String)"A", (String)grading);
        List nMl = GlbbService.calculateYoYAndMoM_CP((List)nmlmonthEntities, (String)"\u6bdb\u5229", (String)"A", (String)grading);
        List nMll = GlbbService.calculateYoYAndMoM_CP((List)nmllmonthEntities, (String)"\u6bdb\u5229\u7387", (String)"B", (String)grading);
        ArrayList allList = new ArrayList();
        allList.addAll(Sre);
        allList.addAll(Dds);
        allList.addAll(Dde);
        allList.addAll(Hke);
        allList.addAll(nCb);
        allList.addAll(nMl);
        allList.addAll(nMll);
        Map categorizedData = this.adjustList(allList);
        YearMonth maxTime = categorizedData.values().stream().flatMap(Collection::stream).map(GlbbDataN2::getCurrentTime).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("\u672a\u627e\u5230\u6700\u5927\u7684 currentTime"));
        for (List productDataList : categorizedData.values()) {
            for (GlbbDataN2 glbbDataN2 : productDataList) {
                if (glbbDataN2.getCurrentTime().equals(maxTime)) continue;
                glbbDataN2.setCurrentTime(maxTime);
                glbbDataN2.setCurrentmonthData(BigDecimal.ZERO);
                glbbDataN2.setCurrentmonthDataHB(BigDecimal.ZERO);
                glbbDataN2.setCurrentmonthDataTB(BigDecimal.ZERO);
            }
        }
        ArrayList sortedEntries = new ArrayList(categorizedData.entrySet());
        sortedEntries.sort((entry1, entry2) -> {
            BigDecimal revenue1 = this.getRevenueValue2((List)entry1.getValue(), "\u6536\u5165\u989d");
            BigDecimal revenue2 = this.getRevenueValue2((List)entry2.getValue(), "\u6536\u5165\u989d");
            return revenue2.compareTo(revenue1);
        });
        LinkedHashMap sortedCategorizedData = new LinkedHashMap();
        for (Map.Entry entry : sortedEntries) {
            sortedCategorizedData.put(entry.getKey(), entry.getValue());
        }
        return ResponseDTO.ok(sortedCategorizedData);
    }

    private BigDecimal getRevenueValue2(List<GlbbDataN2> dataList, String dataType) {
        for (GlbbDataN2 data : dataList) {
            if (!dataType.equals(data.getDataType())) continue;
            return data.getCurrentmonthData();
        }
        return BigDecimal.ZERO;
    }

    public static List<GlbbDataN2> calculateYoYAndMoM_CP(List<MonthEntity> monthEntities, String type, String method, String grading) {
        Map<String, Map<YearMonth, MonthEntity>> productMonthlySales = monthEntities.stream().collect(Collectors.groupingBy(MonthEntity::getDataName, Collectors.toMap(MonthEntity::getDataMonth, entity -> entity)));
        ArrayList<GlbbDataN2> glbbDataN2s = new ArrayList<GlbbDataN2>();
        for (Map.Entry<String, Map<YearMonth, MonthEntity>> productEntry : productMonthlySales.entrySet()) {
            MonthEntity currentData;
            BigDecimal previousYearSr;
            BigDecimal currentYearSr;
            String product = productEntry.getKey();
            Map<YearMonth, MonthEntity> monthlySales = productEntry.getValue();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = currentTime.minusMonths(1L);
            YearMonth previousQuarterTime = currentTime.minusMonths(4L);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            BigDecimal currentMonthData = new BigDecimal(0);
            BigDecimal previousMonthData = new BigDecimal(0);
            BigDecimal previousYearData = new BigDecimal(0);
            if (grading.equals("0")) {
                if (monthlySales.containsKey(currentTime)) {
                    currentMonthData = monthlySales.get(currentTime).getDataValue();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousMonthTime)) {
                    previousMonthData = monthlySales.get(previousMonthTime).getDataValue();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousYearTime)) {
                    previousYearData = monthlySales.get(previousYearTime).getDataValue();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
            } else if (grading.equals("1")) {
                BigDecimal previousYearSr2;
                BigDecimal previousSr;
                BigDecimal currentSr;
                ArrayList<MonthEntity> monthEntityList = new ArrayList<MonthEntity>(monthlySales.values());
                if (method.equals("A")) {
                    currentMonthData = GlbbService.getQuarterData(monthEntityList, (YearMonth)currentTime);
                    previousMonthData = GlbbService.getQuarterData(monthEntityList, (YearMonth)previousQuarterTime);
                    previousYearData = GlbbService.getQuarterData(monthEntityList, (YearMonth)previousYearTime);
                } else if (method.equals("B")) {
                    currentSr = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)currentTime);
                    previousSr = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)previousQuarterTime);
                    previousYearSr2 = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)previousYearTime);
                    BigDecimal currentCb = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)currentTime);
                    BigDecimal previousCb = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)previousQuarterTime);
                    BigDecimal previousYearCb = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)previousYearTime);
                    if (currentSr.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        currentMonthData = currentSr.subtract(currentCb).divide(currentSr, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                    if (previousSr.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        previousMonthData = previousSr.subtract(previousCb).divide(previousSr, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                    if (previousYearSr2.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        previousYearData = previousYearSr2.subtract(previousYearCb).divide(previousYearSr2, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                } else if (method.equals("C")) {
                    currentSr = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)currentTime);
                    previousSr = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)previousQuarterTime);
                    previousYearSr2 = GlbbService.getQuarterAssist1(monthEntityList, (YearMonth)previousYearTime);
                    BigDecimal currentFyorJl = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)currentTime);
                    BigDecimal previousFyorJl = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)previousQuarterTime);
                    BigDecimal previousYearFyorJl = GlbbService.getQuarterAssist2(monthEntityList, (YearMonth)previousYearTime);
                    if (currentSr.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        currentMonthData = currentFyorJl.divide(currentSr, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                    if (previousSr.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        previousMonthData = previousFyorJl.divide(previousSr, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                    if (previousYearSr2.compareTo(BigDecimal.valueOf(0L)) != 0) {
                        previousYearData = previousYearFyorJl.divide(previousYearSr2, 10, RoundingMode.HALF_UP);
                    } else {
                        System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                    }
                }
            } else if (grading.equals("2")) {
                try {
                    currentMonthData = monthlySales.get(currentTime).getDataValue();
                }
                catch (NullPointerException e) {
                    currentMonthData = BigDecimal.valueOf(0L);
                    System.out.println("\u6570\u636e\u7f3a\u5931: currentTime=" + currentTime);
                }
                try {
                    previousYearData = monthlySales.get(previousYearTime).getDataValue();
                }
                catch (NullPointerException e) {
                    previousYearData = BigDecimal.valueOf(0L);
                }
                try {
                    previousMonthData = monthlySales.get(previousMonthTime).getDataValue();
                }
                catch (NullPointerException e) {
                    previousMonthData = BigDecimal.valueOf(0L);
                }
            }
            BigDecimal mom = new BigDecimal(0);
            BigDecimal yoy = new BigDecimal(0);
            if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
            } else {
                System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
            }
            if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
            } else {
                System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
            }
            Integer CurrentYear = currentTime.getYear();
            BigDecimal currentYearCumulative = BigDecimal.ZERO;
            BigDecimal previousYearCumulative = BigDecimal.ZERO;
            BigDecimal previousYearyoy = BigDecimal.ZERO;
            if (method.equals("A")) {
                for (YearMonth yearMonth : months) {
                    MonthEntity currentData2 = monthlySales.get(yearMonth);
                    if (currentData2 != null && currentData2.getDataValue() != null) {
                        if (yearMonth.getYear() == currentTime.getYear()) {
                            currentYearCumulative = currentYearCumulative.add(currentData2.getDataValue());
                            continue;
                        }
                        if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                        previousYearCumulative = previousYearCumulative.add(currentData2.getDataValue());
                        continue;
                    }
                    System.err.println("\u8b66\u544a\uff1a\u7f3a\u5c11" + yearMonth + "\u7684\u6570\u636e");
                }
                if (previousYearCumulative.compareTo(BigDecimal.ZERO) != 0) {
                    previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97\uff1a\u4e0a\u5e74\u540c\u671f\u6570\u636e\u4e3a\u96f6");
                }
            } else if (method.equals("B")) {
                currentYearSr = BigDecimal.ZERO;
                BigDecimal currentYearCb = BigDecimal.ZERO;
                previousYearSr = BigDecimal.ZERO;
                BigDecimal previousYearCb = BigDecimal.ZERO;
                for (YearMonth yearMonth : months) {
                    currentData = monthlySales.get(yearMonth);
                    if (currentData != null && currentData.getDataAssist1() != null && currentData.getDataAssist2() != null) {
                        if (yearMonth.getYear() == currentTime.getYear()) {
                            currentYearSr = currentYearSr.add(currentData.getDataAssist1());
                            currentYearCb = currentYearCb.add(currentData.getDataAssist2());
                            continue;
                        }
                        if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                        previousYearSr = previousYearSr.add(currentData.getDataAssist1());
                        previousYearCb = previousYearCb.add(currentData.getDataAssist2());
                        continue;
                    }
                    System.err.println("\u8b66\u544a\uff1a\u7f3a\u5c11" + yearMonth + "\u7684\u8f85\u52a9\u6570\u636e");
                }
                try {
                    if (currentYearSr.compareTo(BigDecimal.ZERO) != 0) {
                        currentYearCumulative = currentYearSr.subtract(currentYearCb).divide(currentYearSr, 10, 4);
                    } else {
                        System.out.println("\u5f53\u524d\u5e74\u6536\u5165\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6bdb\u5229\u7387");
                        currentYearCumulative = BigDecimal.ZERO;
                    }
                    if (previousYearSr.compareTo(BigDecimal.ZERO) != 0) {
                        previousYearCumulative = previousYearSr.subtract(previousYearCb).divide(previousYearSr, 10, 4);
                    } else {
                        System.out.println("\u4e0a\u4e00\u5e74\u6536\u5165\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6bdb\u5229\u7387");
                        previousYearCumulative = BigDecimal.ZERO;
                    }
                }
                catch (Exception e) {
                    System.err.println("\u8ba1\u7b97\u6bdb\u5229\u7387\u65f6\u51fa\u9519: " + e.getMessage());
                    currentYearCumulative = BigDecimal.ZERO;
                    previousYearCumulative = BigDecimal.ZERO;
                }
                if (previousYearCumulative.compareTo(BigDecimal.ZERO) != 0) {
                    previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u5e74\u540c\u671f\u6bdb\u5229\u7387\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4\u53d8\u5316\u7387");
                    previousYearyoy = BigDecimal.ZERO;
                }
            } else if (method.equals("C")) {
                currentYearSr = BigDecimal.ZERO;
                BigDecimal currentYearFyorJl = BigDecimal.ZERO;
                previousYearSr = BigDecimal.ZERO;
                BigDecimal previousYearFyorJl = BigDecimal.ZERO;
                for (YearMonth yearMonth : months) {
                    currentData = monthlySales.get(yearMonth);
                    if (currentData != null && currentData.getDataAssist1() != null && currentData.getDataAssist2() != null) {
                        if (yearMonth.getYear() == currentTime.getYear()) {
                            currentYearSr = currentYearSr.add(currentData.getDataAssist1());
                            currentYearFyorJl = currentYearFyorJl.add(currentData.getDataAssist2());
                            continue;
                        }
                        if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                        previousYearSr = previousYearSr.add(currentData.getDataAssist1());
                        previousYearFyorJl = previousYearFyorJl.add(currentData.getDataAssist2());
                        continue;
                    }
                    System.err.println("\u8b66\u544a\uff1a\u7f3a\u5c11" + yearMonth + "\u7684\u8f85\u52a9\u6570\u636e");
                }
                try {
                    if (currentYearSr.compareTo(BigDecimal.ZERO) != 0) {
                        currentYearCumulative = currentYearFyorJl.divide(currentYearSr, 10, 4);
                    } else {
                        System.out.println("\u5f53\u524d\u5e74\u6536\u5165\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8d39\u7528\u7387/\u51c0\u5229\u7387");
                        currentYearCumulative = BigDecimal.ZERO;
                    }
                    if (previousYearSr.compareTo(BigDecimal.ZERO) != 0) {
                        previousYearCumulative = previousYearFyorJl.divide(previousYearSr, 10, 4);
                    } else {
                        System.out.println("\u4e0a\u4e00\u5e74\u6536\u5165\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8d39\u7528\u7387/\u51c0\u5229\u7387");
                        previousYearCumulative = BigDecimal.ZERO;
                    }
                }
                catch (Exception e) {
                    System.err.println("\u8ba1\u7b97\u8d39\u7528\u7387/\u51c0\u5229\u7387\u65f6\u51fa\u9519: " + e.getMessage());
                    currentYearCumulative = BigDecimal.ZERO;
                    previousYearCumulative = BigDecimal.ZERO;
                }
                if (previousYearCumulative.compareTo(BigDecimal.ZERO) != 0) {
                    previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 10, 4).multiply(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u5e74\u540c\u671f\u8d39\u7528\u7387/\u51c0\u5229\u7387\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4\u53d8\u5316\u7387");
                    previousYearyoy = BigDecimal.ZERO;
                }
            }
            GlbbDataN2 glbbDataN2 = new GlbbDataN2();
            glbbDataN2.setDataName(product);
            glbbDataN2.setDataType(type);
            glbbDataN2.setCurrentTime(currentTime);
            glbbDataN2.setCurrentmonthData(currentMonthData.setScale(2, 4));
            glbbDataN2.setCurrentmonthDataHB(mom.setScale(2, 4));
            glbbDataN2.setCurrentmonthDataTB(yoy.setScale(2, 4));
            glbbDataN2.setCurrentYearData(currentYearCumulative.setScale(2, 4));
            glbbDataN2.setCurrentYearDataTB(previousYearyoy.setScale(2, 4));
            glbbDataN2.setCwbbType(grading);
            glbbDataN2s.add(glbbDataN2);
        }
        return glbbDataN2s;
    }

    public static BigDecimal getMonthData(List<MonthEntity> monthEntities, YearMonth monthTime) {
        if (monthEntities == null || monthEntities.isEmpty()) {
            return BigDecimal.valueOf(-1L);
        }
        return monthEntities.stream().filter(e -> e != null && Objects.equals(e.getDataMonth(), monthTime)).map(MonthEntity::getDataValue).filter(Objects::nonNull).findFirst().orElse(BigDecimal.valueOf(-1L));
    }

    public static BigDecimal getMonthDataAssist1(List<MonthEntity> monthEntities, YearMonth monthTime) {
        if (monthEntities == null || monthEntities.isEmpty()) {
            return BigDecimal.valueOf(-1L);
        }
        return monthEntities.stream().filter(e -> e != null && Objects.equals(e.getDataMonth(), monthTime)).map(MonthEntity::getDataAssist1).filter(Objects::nonNull).findFirst().orElse(BigDecimal.valueOf(-1L));
    }

    public static BigDecimal getMonthDataAssist2(List<MonthEntity> monthEntities, YearMonth monthTime) {
        if (monthEntities == null || monthEntities.isEmpty()) {
            return BigDecimal.valueOf(-1L);
        }
        return monthEntities.stream().filter(e -> e != null && Objects.equals(e.getDataMonth(), monthTime)).map(MonthEntity::getDataAssist2).filter(Objects::nonNull).findFirst().orElse(BigDecimal.valueOf(-1L));
    }

    public static BigDecimal getQuarterData(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getQuarterAssist1(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataAssist1).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getQuarterAssist2(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataAssist2).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public ResponseDTO<List<GlbbData>> getCpMonthData(String userId, String selectedValue) {
        List orderMonthEntities = this.monthDataDao.queryNormOrderById(Long.parseLong(userId));
        List srData = GlbbService.calculateSrYoYAndMoM((List)orderMonthEntities);
        List costMonthEntities = this.monthDataDao.queryCostById(Long.parseLong(userId));
        List cbData = GlbbService.calculateCbYoYAndMoM((List)costMonthEntities);
        List MaoriMonthEntities = GlbbService.calculateMargin((List)costMonthEntities, (List)orderMonthEntities);
        List mlData = GlbbService.calculateMlYoYAndMoM((List)MaoriMonthEntities);
        List mllData = GlbbService.calculateMllYoYAndMoM((List)MaoriMonthEntities);
        List listAll = new ArrayList();
        listAll.addAll(srData);
        listAll.addAll(cbData);
        listAll.addAll(mlData);
        listAll.addAll(mllData);
        if (selectedValue != null && !"".equals(selectedValue)) {
            String queryCpname = this.monthDataDao.queryCpNameByorderId(Long.parseLong(selectedValue));
            listAll = this.selectCP(queryCpname, listAll);
        }
        return ResponseDTO.ok(listAll);
    }

    public ResponseDTO<List<GlbbDataTwo>> getMonthData(String userId, String selectedValue) {
        ArrayList listAll = new ArrayList();
        List cwbbMonthEntities = this.monthDataDao.queryCwbbById(Long.parseLong(userId));
        List fyData = this.calculateFyYoYAndMoM(cwbbMonthEntities);
        List jlData = this.calculateJlYoYAndMoM(cwbbMonthEntities);
        List jllData = this.calculateJllYoYAndMoM(cwbbMonthEntities);
        listAll.addAll(fyData);
        listAll.addAll(jlData);
        listAll.addAll(jllData);
        return ResponseDTO.ok(listAll);
    }

    private List<GlbbData> selectCP(String cpName, List<GlbbData> list) {
        ArrayList<GlbbData> listAll = new ArrayList<GlbbData>();
        System.out.println(cpName);
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getProduct().equals(cpName)) continue;
            listAll.add(list.get(i));
        }
        System.out.println("list" + listAll);
        return listAll;
    }

    private List<GlbbDataTwo> calculateFyYoYAndMoM(List<CwbbMonthEntity> cwbbMonthEntities) {
        ArrayList<YearMonth> monthList = new ArrayList<YearMonth>();
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            monthList.add(cwbbMonthEntity.getCwbbMonth());
        }
        Collections.sort(monthList);
        YearMonth currentTime = (YearMonth)monthList.get(monthList.size() - 1);
        YearMonth previousMonthTime = (YearMonth)monthList.get(monthList.size() - 2);
        YearMonth previousYearTime = currentTime.minusYears(1L);
        BigDecimal currentMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousYearFy = BigDecimal.valueOf(0L);
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            if (cwbbMonthEntity.getCwbbMonth().equals(currentTime)) {
                currentMonthFy = cwbbMonthEntity.getCwbbZfy();
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().equals(previousMonthTime)) {
                previousMonthFy = cwbbMonthEntity.getCwbbZfy();
                continue;
            }
            if (!cwbbMonthEntity.getCwbbMonth().equals(previousYearTime)) continue;
            previousYearFy = cwbbMonthEntity.getCwbbZfy();
        }
        if (previousMonthTime.equals(previousYearTime)) {
            previousYearFy = previousMonthFy;
        }
        BigDecimal mom = currentMonthFy.subtract(previousMonthFy).divide(previousMonthFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        BigDecimal yoy = currentMonthFy.subtract(previousYearFy).divide(previousYearFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        Integer CurrentYear = currentTime.getYear();
        BigDecimal currentYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearCumulative = BigDecimal.ZERO;
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            if (cwbbMonthEntity.getCwbbMonth().getYear() == CurrentYear.intValue()) {
                currentYearCumulative = currentYearCumulative.add(cwbbMonthEntity.getCwbbZfy());
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().getYear() != CurrentYear - 1) continue;
            previousYearCumulative = currentYearCumulative.add(cwbbMonthEntity.getCwbbZfy());
        }
        BigDecimal Yearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        GlbbDataTwo glbbDataTwo = new GlbbDataTwo();
        glbbDataTwo.setCurrentTime(currentTime);
        glbbDataTwo.setCurrentmonthData(currentMonthFy);
        glbbDataTwo.setCurrentmonthDataHB(mom);
        glbbDataTwo.setCurrentmonthDataTB(yoy);
        glbbDataTwo.setCurrentYearData(currentYearCumulative);
        glbbDataTwo.setCurrentYearDataTB(Yearyoy);
        glbbDataTwo.setDataType("\u8d39\u7528");
        ArrayList<GlbbDataTwo> glbbDataTwoList = new ArrayList<GlbbDataTwo>();
        glbbDataTwoList.add(glbbDataTwo);
        return glbbDataTwoList;
    }

    private List<GlbbDataTwo> calculateJlYoYAndMoM(List<CwbbMonthEntity> cwbbMonthEntities) {
        ArrayList<YearMonth> monthList = new ArrayList<YearMonth>();
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            monthList.add(cwbbMonthEntity.getCwbbMonth());
        }
        Collections.sort(monthList);
        YearMonth currentTime = (YearMonth)monthList.get(monthList.size() - 1);
        YearMonth previousMonthTime = (YearMonth)monthList.get(monthList.size() - 2);
        YearMonth previousYearTime = currentTime.minusYears(1L);
        BigDecimal currentMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousYearFy = BigDecimal.valueOf(0L);
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            if (cwbbMonthEntity.getCwbbMonth().equals(currentTime)) {
                currentMonthFy = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().equals(previousMonthTime)) {
                previousMonthFy = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
                continue;
            }
            if (!cwbbMonthEntity.getCwbbMonth().equals(previousYearTime)) continue;
            previousYearFy = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
        }
        if (previousMonthTime.equals(previousYearTime)) {
            previousYearFy = previousMonthFy;
        }
        BigDecimal mom = currentMonthFy.subtract(previousMonthFy).divide(previousMonthFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        BigDecimal yoy = currentMonthFy.subtract(previousYearFy).divide(previousYearFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        Integer CurrentYear = currentTime.getYear();
        BigDecimal currentYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearCumulative = BigDecimal.ZERO;
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            if (cwbbMonthEntity.getCwbbMonth().getYear() == CurrentYear.intValue()) {
                currentYearCumulative = currentYearCumulative.add(cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy()));
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().getYear() != CurrentYear - 1) continue;
            previousYearCumulative = currentYearCumulative.add(cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy()));
        }
        BigDecimal Yearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        GlbbDataTwo glbbDataTwo = new GlbbDataTwo();
        glbbDataTwo.setCurrentTime(currentTime);
        glbbDataTwo.setCurrentmonthData(currentMonthFy);
        glbbDataTwo.setCurrentmonthDataHB(mom);
        glbbDataTwo.setCurrentmonthDataTB(yoy);
        glbbDataTwo.setCurrentYearData(currentYearCumulative);
        glbbDataTwo.setCurrentYearDataTB(Yearyoy);
        glbbDataTwo.setDataType("\u51c0\u5229");
        ArrayList<GlbbDataTwo> glbbDataTwoList = new ArrayList<GlbbDataTwo>();
        glbbDataTwoList.add(glbbDataTwo);
        return glbbDataTwoList;
    }

    private List<GlbbDataTwo> calculateJllYoYAndMoM(List<CwbbMonthEntity> cwbbMonthEntities) {
        ArrayList<YearMonth> monthList = new ArrayList<YearMonth>();
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            monthList.add(cwbbMonthEntity.getCwbbMonth());
        }
        Collections.sort(monthList);
        YearMonth currentTime = (YearMonth)monthList.get(monthList.size() - 1);
        YearMonth previousMonthTime = (YearMonth)monthList.get(monthList.size() - 2);
        YearMonth previousYearTime = currentTime.minusYears(1L);
        BigDecimal currentMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousMonthFy = BigDecimal.valueOf(0L);
        BigDecimal previousYearFy = BigDecimal.valueOf(0L);
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            BigDecimal jl;
            if (cwbbMonthEntity.getCwbbMonth().equals(currentTime)) {
                jl = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
                currentMonthFy = jl.divide(cwbbMonthEntity.getCwbbYysr(), 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().equals(previousMonthTime)) {
                jl = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
                previousMonthFy = jl.divide(cwbbMonthEntity.getCwbbYysr(), 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                continue;
            }
            if (!cwbbMonthEntity.getCwbbMonth().equals(previousYearTime)) continue;
            jl = cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy());
            previousYearFy = jl.divide(cwbbMonthEntity.getCwbbYysr(), 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
        }
        if (previousMonthTime.equals(previousYearTime)) {
            previousYearFy = previousMonthFy;
        }
        BigDecimal mom = currentMonthFy.subtract(previousMonthFy).divide(previousMonthFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        BigDecimal yoy = currentMonthFy.subtract(previousYearFy).divide(previousYearFy, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        Integer CurrentYear = currentTime.getYear();
        BigDecimal currentYearCumulativeJl = BigDecimal.ZERO;
        BigDecimal previousYearCumulativejl = BigDecimal.ZERO;
        BigDecimal currentYearCumulativeSr = BigDecimal.ZERO;
        BigDecimal previousYearCumulativeSr = BigDecimal.ZERO;
        for (CwbbMonthEntity cwbbMonthEntity : cwbbMonthEntities) {
            if (cwbbMonthEntity.getCwbbMonth().getYear() == CurrentYear.intValue()) {
                currentYearCumulativeSr = currentYearCumulativeSr.add(cwbbMonthEntity.getCwbbYysr());
                currentYearCumulativeJl = currentYearCumulativeJl.add(cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy()));
                continue;
            }
            if (cwbbMonthEntity.getCwbbMonth().getYear() != CurrentYear - 1) continue;
            previousYearCumulativeSr = previousYearCumulativeSr.add(cwbbMonthEntity.getCwbbYysr());
            previousYearCumulativejl = previousYearCumulativejl.add(cwbbMonthEntity.getCwbbYysr().subtract(cwbbMonthEntity.getCwbbYycb()).subtract(cwbbMonthEntity.getCwbbZfy()));
        }
        BigDecimal currentYearCumulative = currentYearCumulativeJl.divide(currentYearCumulativeSr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        BigDecimal previousYearCumulative = previousYearCumulativejl.divide(currentYearCumulativeSr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        BigDecimal Yearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        GlbbDataTwo glbbDataTwo = new GlbbDataTwo();
        glbbDataTwo.setCurrentTime(currentTime);
        glbbDataTwo.setCurrentmonthData(currentMonthFy);
        glbbDataTwo.setCurrentmonthDataHB(mom);
        glbbDataTwo.setCurrentmonthDataTB(yoy);
        glbbDataTwo.setCurrentYearData(currentYearCumulative);
        glbbDataTwo.setCurrentYearDataTB(Yearyoy);
        glbbDataTwo.setDataType("\u51c0\u5229\u7387");
        ArrayList<GlbbDataTwo> glbbDataTwoList = new ArrayList<GlbbDataTwo>();
        glbbDataTwoList.add(glbbDataTwo);
        return glbbDataTwoList;
    }

    public static List<GlbbData> calculateSrYoYAndMoM(List<OrderMonthEntity> salesData) {
        Map<String, Map<YearMonth, OrderMonthEntity>> productMonthlySales = salesData.stream().collect(Collectors.groupingBy(OrderMonthEntity::getOrderCp, Collectors.toMap(OrderMonthEntity::getOrderMonth, entity -> entity)));
        ArrayList<GlbbData> restfull = new ArrayList<GlbbData>();
        for (Map.Entry<String, Map<YearMonth, OrderMonthEntity>> productEntry : productMonthlySales.entrySet()) {
            String product = productEntry.getKey();
            Map<YearMonth, OrderMonthEntity> monthlySales = productEntry.getValue();
            GlbbData glbbData = new GlbbData();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            glbbData.setProduct(product);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = (YearMonth)months.get(months.size() - 2);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            OrderMonthEntity currentMonthData = monthlySales.get(currentTime);
            OrderMonthEntity previousMonthData = monthlySales.get(previousMonthTime);
            OrderMonthEntity previousYearData = monthlySales.get(previousYearTime);
            glbbData.setCurrentTime(currentTime);
            glbbData.setCurrentmonthData(currentMonthData.getOrderZjg());
            if (previousMonthData != null) {
                BigDecimal mom = currentMonthData.getOrderZjg().subtract(previousMonthData.getOrderZjg()).divide(previousMonthData.getOrderZjg(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataHB(mom);
            }
            if (previousYearData != null && monthlySales.containsKey(previousYearTime)) {
                BigDecimal yoy = currentMonthData.getOrderZjg().subtract(previousYearData.getOrderZjg()).divide(previousYearData.getOrderZjg(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataTB(yoy);
            }
            Integer CurrentYear = currentTime.getYear();
            BigDecimal currentYearCumulative = BigDecimal.ZERO;
            BigDecimal previousYearCumulative = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                OrderMonthEntity currentData = monthlySales.get(yearMonth);
                if (currentData.getOrderMonth().getYear() == CurrentYear.intValue()) {
                    currentYearCumulative = currentYearCumulative.add(currentData.getOrderZjg());
                    continue;
                }
                if (currentData.getOrderMonth().getYear() != CurrentYear - 1) continue;
                previousYearCumulative = previousYearCumulative.add(currentData.getOrderZjg());
            }
            BigDecimal previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            glbbData.setCurrentYearData(currentYearCumulative);
            glbbData.setCurrentYearDataTB(previousYearyoy);
            glbbData.setDataType("\u6536\u5165");
            restfull.add(glbbData);
        }
        return restfull;
    }

    public static List<GlbbData> calculateCbYoYAndMoM(List<CostMonthEntity> salesData) {
        Map<String, Map<YearMonth, CostMonthEntity>> productMonthlySales = salesData.stream().collect(Collectors.groupingBy(CostMonthEntity::getCostCp, Collectors.toMap(CostMonthEntity::getCostMonth, entity -> entity)));
        ArrayList<GlbbData> restfull = new ArrayList<GlbbData>();
        for (Map.Entry<String, Map<YearMonth, CostMonthEntity>> productEntry : productMonthlySales.entrySet()) {
            String product = productEntry.getKey();
            Map<YearMonth, CostMonthEntity> monthlySales = productEntry.getValue();
            GlbbData glbbData = new GlbbData();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            glbbData.setProduct(product);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = (YearMonth)months.get(months.size() - 2);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            CostMonthEntity currentMonthData = monthlySales.get(currentTime);
            CostMonthEntity previousMonthData = monthlySales.get(previousMonthTime);
            CostMonthEntity previousYearData = monthlySales.get(previousYearTime);
            glbbData.setCurrentTime(currentTime);
            glbbData.setCurrentmonthData(currentMonthData.getCostZcb());
            if (previousMonthData != null) {
                BigDecimal mom = currentMonthData.getCostZcb().subtract(previousMonthData.getCostZcb()).divide(previousMonthData.getCostZcb(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataHB(mom);
            }
            if (previousYearData != null && monthlySales.containsKey(previousYearTime)) {
                BigDecimal yoy = currentMonthData.getCostZcb().subtract(previousYearData.getCostZcb()).divide(previousYearData.getCostZcb(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataTB(yoy);
            }
            Integer CurrentYear = currentTime.getYear();
            BigDecimal currentYearCumulative = BigDecimal.ZERO;
            BigDecimal previousYearCumulative = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                CostMonthEntity currentData = monthlySales.get(yearMonth);
                if (currentData.getCostMonth().getYear() == CurrentYear.intValue()) {
                    currentYearCumulative = currentYearCumulative.add(currentData.getCostZcb());
                    continue;
                }
                if (currentData.getCostMonth().getYear() != CurrentYear - 1) continue;
                previousYearCumulative = previousYearCumulative.add(currentData.getCostZcb());
            }
            BigDecimal previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            glbbData.setCurrentYearData(currentYearCumulative);
            glbbData.setCurrentYearDataTB(previousYearyoy);
            glbbData.setDataType("\u6210\u672c");
            restfull.add(glbbData);
        }
        return restfull;
    }

    public static List<MaoriMonthEntity> calculateMargin(List<CostMonthEntity> costMonthEntity, List<OrderMonthEntity> orderMonthEntity) {
        Map<String, Map<YearMonth, OrderMonthEntity>> orderProductMonthlySales = orderMonthEntity.stream().collect(Collectors.groupingBy(OrderMonthEntity::getOrderCp, Collectors.toMap(OrderMonthEntity::getOrderMonth, entity -> entity)));
        ArrayList<MaoriMonthEntity> monthEntityList = new ArrayList<MaoriMonthEntity>();
        for (Map.Entry<String, Map<YearMonth, OrderMonthEntity>> productEntry : orderProductMonthlySales.entrySet()) {
            String product = productEntry.getKey();
            Map<YearMonth, OrderMonthEntity> orderMonthlySales = productEntry.getValue();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(orderMonthlySales.keySet());
            Collections.sort(months);
            for (CostMonthEntity costMonthEntity1 : costMonthEntity) {
                if (!costMonthEntity1.getCostCp().equals(product)) continue;
                for (YearMonth yearMonth : months) {
                    if (!yearMonth.equals(costMonthEntity1.getCostMonth())) continue;
                    MaoriMonthEntity maoriMonthEntity = new MaoriMonthEntity();
                    BigDecimal ml = orderMonthlySales.get(yearMonth).getOrderZjg().subtract(costMonthEntity1.getCostZcb());
                    BigDecimal mll = ml.divide(orderMonthlySales.get(yearMonth).getOrderZjg(), 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                    maoriMonthEntity.setMaoriCp(product);
                    maoriMonthEntity.setMaoriMonth(yearMonth);
                    maoriMonthEntity.setMaoriMl(ml);
                    maoriMonthEntity.setMaoriMll(mll);
                    monthEntityList.add(maoriMonthEntity);
                }
            }
        }
        return monthEntityList;
    }

    public static List<GlbbData> calculateMlYoYAndMoM(List<MaoriMonthEntity> salesData) {
        Map<String, Map<YearMonth, MaoriMonthEntity>> productMonthlySales = salesData.stream().collect(Collectors.groupingBy(MaoriMonthEntity::getMaoriCp, Collectors.toMap(MaoriMonthEntity::getMaoriMonth, entity -> entity)));
        ArrayList<GlbbData> restfull = new ArrayList<GlbbData>();
        for (Map.Entry<String, Map<YearMonth, MaoriMonthEntity>> productEntry : productMonthlySales.entrySet()) {
            String product = productEntry.getKey();
            Map<YearMonth, MaoriMonthEntity> monthlySales = productEntry.getValue();
            GlbbData glbbData = new GlbbData();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            glbbData.setProduct(product);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = (YearMonth)months.get(months.size() - 2);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            MaoriMonthEntity currentMonthData = monthlySales.get(currentTime);
            MaoriMonthEntity previousMonthData = monthlySales.get(previousMonthTime);
            MaoriMonthEntity previousYearData = monthlySales.get(previousYearTime);
            glbbData.setCurrentTime(currentTime);
            glbbData.setCurrentmonthData(currentMonthData.getMaoriMl());
            if (previousMonthData != null) {
                BigDecimal mom = currentMonthData.getMaoriMl().subtract(previousMonthData.getMaoriMl()).divide(previousMonthData.getMaoriMl(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataHB(mom);
            }
            if (previousYearData != null && monthlySales.containsKey(previousYearTime)) {
                BigDecimal yoy = currentMonthData.getMaoriMl().subtract(previousYearData.getMaoriMl()).divide(previousYearData.getMaoriMl(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataTB(yoy);
            }
            Integer CurrentYear = currentTime.getYear();
            BigDecimal currentYearCumulative = BigDecimal.ZERO;
            BigDecimal previousYearCumulative = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                MaoriMonthEntity currentData = monthlySales.get(yearMonth);
                if (currentData.getMaoriMonth().getYear() == CurrentYear.intValue()) {
                    currentYearCumulative = currentYearCumulative.add(currentData.getMaoriMl());
                    continue;
                }
                if (currentData.getMaoriMonth().getYear() != CurrentYear - 1) continue;
                previousYearCumulative = previousYearCumulative.add(currentData.getMaoriMl());
            }
            BigDecimal previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            glbbData.setCurrentYearData(currentYearCumulative);
            glbbData.setCurrentYearDataTB(previousYearyoy);
            glbbData.setDataType("\u6bdb\u5229");
            restfull.add(glbbData);
        }
        return restfull;
    }

    public static List<GlbbData> calculateMllYoYAndMoM(List<MaoriMonthEntity> salesData) {
        Map<String, Map<YearMonth, MaoriMonthEntity>> productMonthlySales = salesData.stream().collect(Collectors.groupingBy(MaoriMonthEntity::getMaoriCp, Collectors.toMap(MaoriMonthEntity::getMaoriMonth, entity -> entity)));
        ArrayList<GlbbData> restfull = new ArrayList<GlbbData>();
        for (Map.Entry<String, Map<YearMonth, MaoriMonthEntity>> productEntry : productMonthlySales.entrySet()) {
            String product = productEntry.getKey();
            Map<YearMonth, MaoriMonthEntity> monthlySales = productEntry.getValue();
            GlbbData glbbData = new GlbbData();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            glbbData.setProduct(product);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = (YearMonth)months.get(months.size() - 2);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            MaoriMonthEntity currentMonthData = monthlySales.get(currentTime);
            MaoriMonthEntity previousMonthData = monthlySales.get(previousMonthTime);
            MaoriMonthEntity previousYearData = monthlySales.get(previousYearTime);
            glbbData.setCurrentTime(currentTime);
            glbbData.setCurrentmonthData(currentMonthData.getMaoriMll());
            if (previousMonthData != null) {
                BigDecimal mom = currentMonthData.getMaoriMll().subtract(previousMonthData.getMaoriMll()).divide(previousMonthData.getMaoriMll(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataHB(mom);
            }
            if (previousYearData != null && monthlySales.containsKey(previousYearTime)) {
                BigDecimal yoy = currentMonthData.getMaoriMll().subtract(previousYearData.getMaoriMll()).divide(previousYearData.getMaoriMll(), 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                glbbData.setCurrentmonthDataTB(yoy);
            }
            Integer CurrentYear = currentTime.getYear();
            BigDecimal currentYearCumulativeMl = BigDecimal.ZERO;
            BigDecimal previousYearCumulativeMl = BigDecimal.ZERO;
            BigDecimal currentYearCumulativeSr = BigDecimal.ZERO;
            BigDecimal previousYearCumulativeSr = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                MaoriMonthEntity currentData = monthlySales.get(yearMonth);
                if (currentData.getMaoriMonth().getYear() == CurrentYear.intValue()) {
                    currentYearCumulativeMl = currentYearCumulativeMl.add(currentData.getMaoriMl());
                    currentYearCumulativeSr = currentYearCumulativeSr.add(currentData.getMaoriMl().divide(currentData.getMaoriMll().divide(BigDecimal.valueOf(100L)), 2, 4));
                    continue;
                }
                if (currentData.getMaoriMonth().getYear() != CurrentYear - 1) continue;
                previousYearCumulativeMl = previousYearCumulativeMl.add(currentData.getMaoriMl());
                previousYearCumulativeSr = previousYearCumulativeSr.add(currentData.getMaoriMl().divide(currentData.getMaoriMll().divide(BigDecimal.valueOf(100L)), 2, 4));
            }
            BigDecimal currentYearCumulative = currentYearCumulativeMl.divide(currentYearCumulativeSr, 2, 4);
            BigDecimal previousYearCumulative = previousYearCumulativeMl.divide(previousYearCumulativeSr, 2, 4);
            BigDecimal previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            glbbData.setCurrentYearData(currentYearCumulative);
            glbbData.setCurrentYearDataTB(previousYearyoy);
            glbbData.setDataType("\u6bdb\u5229\u7387");
            restfull.add(glbbData);
        }
        return restfull;
    }

    public ResponseDTO<List<Map<String, String>>> getSingleSelect(String userId) {
        List cpname = this.monthDataDao.queryCpNameById(Long.parseLong(userId));
        ArrayList cpmap = new ArrayList();
        for (QueryField queryField : cpname) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", queryField.getQueryCpid());
            map.put("label", queryField.getQueryCpname());
            cpmap.add(map);
        }
        return ResponseDTO.ok(cpmap);
    }
}

