/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.service.NewCwbbService;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.IndustryDao;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.ATTIAEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.ATTIATargetEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.IndustryEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.TreeNode;
import net.lab1024.sa.admin.module.business.xmfmodel.utils.IndustryEntitySorter;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IndustryService {
    private static final Logger log = LoggerFactory.getLogger(IndustryService.class);
    @Resource
    private IndustryDao industryDao;
    @Resource
    private NewCwbbService newCwbbService;

    public ResponseDTO<List<IndustryEntity>> query(long userid) {
        String industryname;
        List list = this.industryDao.queryById(userid);
        if (list == null || list.size() <= 0) {
            this.createIndustry(Long.valueOf(userid));
            list = this.industryDao.queryById(userid);
        }
        if ((industryname = this.industryDao.queryIndustryName(userid)) == null) {
            industryname = "\u672a\u9009\u62e9\u884c\u4e1a";
        }
        ((IndustryEntity)list.get(0)).setIndustryName(industryname);
        this.newCwbbService.calculatePfbData(String.valueOf(userid));
        return ResponseDTO.ok((Object)list);
    }

    public ResponseDTO<List<TreeNode>> queryATTIAData() {
        List ATTIAEntitylist = this.industryDao.queryATTIA();
        ArrayList sortedList = new ArrayList(ATTIAEntitylist);
        Collections.sort(sortedList, new /* Unavailable Anonymous Inner Class!! */);
        for (ATTIAEntity attiaEntity : sortedList) {
            System.out.println(attiaEntity);
        }
        List industryTree = this.buildTreeStructure(sortedList);
        return ResponseDTO.ok((Object)industryTree);
    }

    public ResponseDTO<List<IndustryEntity>> getATTIADataTarget(String industryID) {
        List<String> jD = Arrays.asList("\u6210\u957f\u6027", "\u76c8\u5229\u6027", "\u6d41\u52a8\u6027");
        List ATTIATargetEntitylist = this.industryDao.queryATTIATarget(Long.parseLong(industryID));
        System.out.println(ATTIATargetEntitylist);
        ArrayList<IndustryEntity> industryEntityList = new ArrayList<IndustryEntity>();
        for (ATTIATargetEntity entity : ATTIATargetEntitylist) {
            IndustryEntity industryEntity = new IndustryEntity();
            if (entity.getTargetName().equals("\u51c0\u8d44\u4ea7\u589e\u957f\u7387(%)") || entity.getTargetName().equals("\u6536\u5165\u589e\u957f\u7387(%)") || entity.getTargetName().equals("\u51c0\u5229\u589e\u957f\u7387(%)")) {
                industryEntity.setIndustryJd(jD.get(0));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
            }
            if (entity.getTargetName().equals("\u603b\u8d44\u4ea7\u5468\u8f6c\u7387(\u6b21)") || entity.getTargetName().equals("\u8425\u4e1a\u5229\u6da6\u7387(%)") || entity.getTargetName().equals("\u51c0\u8d44\u4ea7\u6536\u76ca\u7387(%)")) {
                industryEntity.setIndustryJd(jD.get(1));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
            }
            if (entity.getTargetName().equals("\u901f\u52a8\u6bd4\u7387") || entity.getTargetName().equals("\u81ea\u6709\u8d44\u672c\u6bd4\u7387(%)") || entity.getTargetName().equals("\u5e94\u6536\u8d26\u6b3e\u5468\u8f6c\u7387(\u6b21)") || entity.getTargetName().equals("\u5b58\u8d27\u5468\u8f6c\u7387(\u6b21)")) {
                industryEntity.setIndustryJd(jD.get(2));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
            }
            industryEntityList.add(industryEntity);
        }
        IndustryEntitySorter.sortIndustryEntities(industryEntityList);
        return ResponseDTO.ok(industryEntityList);
    }

    public ResponseDTO<List<IndustryEntity>> saveATTIADataTarget(String industryID, String userID) {
        List<String> jD = Arrays.asList("\u6210\u957f\u6027", "\u76c8\u5229\u6027", "\u6d41\u52a8\u6027");
        List ATTIATargetEntitylist = this.industryDao.queryATTIATarget(Long.parseLong(industryID));
        String industryName = this.industryDao.queryATTIAName(Long.parseLong(industryID));
        ArrayList<IndustryEntity> industryEntityList = new ArrayList<IndustryEntity>();
        for (ATTIATargetEntity entity : ATTIATargetEntitylist) {
            IndustryEntity industryEntity = new IndustryEntity();
            if (entity.getTargetName().equals("\u51c0\u8d44\u4ea7\u589e\u957f\u7387(%)") || entity.getTargetName().equals("\u6536\u5165\u589e\u957f\u7387(%)") || entity.getTargetName().equals("\u51c0\u5229\u589e\u957f\u7387(%)")) {
                industryEntity.setUserId(String.valueOf(userID));
                industryEntity.setIndustryJd(jD.get(0));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
                industryEntity.setIndustryName(industryName);
            }
            if (entity.getTargetName().equals("\u603b\u8d44\u4ea7\u5468\u8f6c\u7387(\u6b21)") || entity.getTargetName().equals("\u8425\u4e1a\u5229\u6da6\u7387(%)") || entity.getTargetName().equals("\u51c0\u8d44\u4ea7\u6536\u76ca\u7387(%)")) {
                industryEntity.setUserId(String.valueOf(userID));
                industryEntity.setIndustryJd(jD.get(1));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
                industryEntity.setIndustryName(industryName);
            }
            if (entity.getTargetName().equals("\u901f\u52a8\u6bd4\u7387") || entity.getTargetName().equals("\u81ea\u6709\u8d44\u672c\u6bd4\u7387(%)") || entity.getTargetName().equals("\u5e94\u6536\u8d26\u6b3e\u5468\u8f6c\u7387(\u6b21)") || entity.getTargetName().equals("\u5b58\u8d27\u5468\u8f6c\u7387(\u6b21)")) {
                industryEntity.setUserId(String.valueOf(userID));
                industryEntity.setIndustryJd(jD.get(2));
                industryEntity.setIndustryZb(entity.getTargetName());
                industryEntity.setIndustryPj(entity.getTargetPj());
                industryEntity.setIndustryZg(entity.getTargetZg());
                industryEntity.setIndustryName(industryName);
            }
            industryEntityList.add(industryEntity);
        }
        IndustryEntitySorter.sortIndustryEntities(industryEntityList);
        this.industryDao.deleteAll(Long.parseLong(userID));
        this.industryDao.insertBatch(industryEntityList);
        return ResponseDTO.okMsg((String)"\u9009\u62e9\u6210\u529f");
    }

    public List<TreeNode> buildTreeStructure(List<ATTIAEntity> sortedList) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>();
        HashMap<Integer, TreeNode> levelNodeMap = new HashMap<Integer, TreeNode>();
        for (ATTIAEntity entity : sortedList) {
            int currentLevel = entity.getIndustryLevel();
            TreeNode node = new TreeNode();
            node.setTitle(entity.getIndustryName());
            node.setKey(entity.getIndustryID());
            node.setChildren(new ArrayList());
            if (currentLevel == 1) {
                rootNodes.add(node);
                levelNodeMap.clear();
                levelNodeMap.put(currentLevel, node);
                continue;
            }
            TreeNode parentNode = (TreeNode)levelNodeMap.get(currentLevel - 1);
            if (parentNode == null) continue;
            parentNode.getChildren().add(node);
            levelNodeMap.put(currentLevel, node);
            levelNodeMap.entrySet().removeIf(entry -> (Integer)entry.getKey() > currentLevel);
        }
        return rootNodes;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> createIndustry(Long userid) {
        List<String> zB = Arrays.asList("\u603b\u8d44\u4ea7\u589e\u957f\u7387", "\u6536\u5165\u589e\u957f\u7387", "\u51c0\u5229\u589e\u957f\u7387", "\u603b\u8d44\u4ea7\u5468\u8f6c\u7387", "\u51c0\u5229\u7387", "\u51c0\u8d44\u4ea7\u6536\u76ca\u7387", "\u901f\u52a8\u6bd4\u7387", "\u81ea\u6709\u8d44\u672c\u6bd4\u7387", "\u5e94\u6536\u8d26\u6b3e\u5468\u8f6c\u7387", "\u5b58\u8d27\u5468\u8f6c\u7387");
        List<String> jD = Arrays.asList("\u6210\u957f\u6027", "\u6210\u957f\u6027", "\u6210\u957f\u6027", "\u76c8\u5229\u6027", "\u76c8\u5229\u6027", "\u76c8\u5229\u6027", "\u6d41\u52a8\u6027", "\u6d41\u52a8\u6027", "\u6d41\u52a8\u6027", "\u6d41\u52a8\u6027");
        ArrayList<IndustryEntity> industryEntityList = new ArrayList<IndustryEntity>();
        for (int i = 0; i < jD.size(); ++i) {
            IndustryEntity industryEntity = new IndustryEntity();
            industryEntity.setUserId(String.valueOf(userid));
            industryEntity.setIndustryZb(zB.get(i));
            industryEntity.setIndustryJd(jD.get(i));
            industryEntityList.add(industryEntity);
        }
        this.industryDao.insertBatch(industryEntityList);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> update(Map<String, String> updateForm) {
        long industryId = Long.parseLong(updateForm.get("industryId"));
        String industryPj = updateForm.get("industryPj");
        String industryZg = updateForm.get("industryZg");
        this.industryDao.updateValue(industryId, industryPj, industryZg);
        return ResponseDTO.ok();
    }
}

