/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.service;

import io.swagger.v3.oas.annotations.Operation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.VentureAnalysisDao;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VentureAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(VentureAnalysisService.class);
    @Resource
    private VentureAnalysisDao ventureAnalysisDao;

    @Operation(summary="\u83b7\u53d6\u8d26\u6237\u4f59\u989d")
    public ResponseDTO<List<Map<String, Object>>> getAccountBalance(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryAccountBalance(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u901f\u52a8\u6bd4\u7387")
    public ResponseDTO<List<Map<String, Object>>> getQuickRatio(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryQuickRatio(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u81ea\u6709\u8d44\u672c\u6bd4\u7387")
    public ResponseDTO<List<Map<String, Object>>> getEquityRatio(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryEquityRatio(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u5e94\u6536\u8d26\u6b3e\u5468\u8f6c\u7387")
    public ResponseDTO<List<Map<String, Object>>> getReceivableTurnover(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryReceivableTurnover(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u5e94\u4ed8\u8d26\u6b3e\u5468\u8f6c\u7387")
    public ResponseDTO<List<Map<String, Object>>> getPayableTurnover(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryPayableTurnover(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u5b58\u8d27\u5468\u8f6c\u7387")
    public ResponseDTO<List<Map<String, Object>>> getInventoryTurnoverRatio(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryInventoryTurnover(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u8868\u6a21\u677f\uff08\u5224\u65ad\u4e3a\u5e74\u8868\u5b63\u8868\u6708\u8868\uff09")
    public int getTemplateType() {
        return this.ventureAnalysisDao.queryTemplateType();
    }

    @Operation(summary="\u83b7\u53d6\u51c0\u8425\u8fd0\u8d44\u672c")
    public ResponseDTO<List<Map<String, Object>>> getNetWorkingCapital(String employeeId) {
        return ResponseDTO.ok((Object)this.ventureAnalysisDao.queryNetWorkingCapital(employeeId));
    }

    @Operation(summary="\u83b7\u53d6\u8d44\u91d1\u53ef\u652f\u6491\u65f6\u95f4")
    public ResponseDTO<Map<String, Object>> getCashSupportPeriod(String employeeId) {
        List CashSupportPeriodMap = this.ventureAnalysisDao.queryCashSupportPeriod(employeeId);
        if (CashSupportPeriodMap.isEmpty()) {
            ResponseDTO.userErrorParam((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8d44\u91d1\u53ef\u652f\u6491\u65f6\u95f4");
        }
        BigDecimal CashSupportPeriod = (BigDecimal)((Map)CashSupportPeriodMap.get(0)).get("ncwbb_cash_support_period");
        HashMap<String, Number> map = new HashMap<String, Number>();
        if (CashSupportPeriod.compareTo(BigDecimal.ZERO) > 0) {
            map.put("CashSupportPeriod", -1);
        } else {
            int i = this.getTemplateType();
            if (i == 1) {
                map.put("CashSupportPeriod", CashSupportPeriod.abs().setScale(0, RoundingMode.CEILING));
            } else if (i == 2) {
                BigDecimal roundedValue = CashSupportPeriod.multiply(BigDecimal.valueOf(3L)).abs().setScale(0, RoundingMode.CEILING);
                map.put("CashSupportPeriod", roundedValue);
            } else {
                map.put("CashSupportPeriod", CashSupportPeriod.multiply(BigDecimal.valueOf(12L)).abs().setScale(0, RoundingMode.CEILING));
            }
        }
        return ResponseDTO.ok(map);
    }

    public ResponseDTO<Map<String, Object>> getPaybackPeriod(String employeeId) {
        int i;
        List res = this.ventureAnalysisDao.queryPaybackPeriod(employeeId);
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal ncwbbTzhdxjlr = BigDecimal.ZERO;
        BigDecimal ncwbbJyhdxjlc = BigDecimal.ZERO;
        BigDecimal ncwbbJyhdxjlr = BigDecimal.ZERO;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (i = 0; i < res.size(); ++i) {
            ncwbbTzhdxjlr = ncwbbTzhdxjlr.add(new BigDecimal(String.valueOf(((Map)res.get(i)).get("ncwbb_tzhdxjlr"))));
            ncwbbJyhdxjlc = ncwbbJyhdxjlc.add(new BigDecimal(String.valueOf(((Map)res.get(i)).get("ncwbb_jyhdxjlc"))));
            ncwbbJyhdxjlr = ncwbbJyhdxjlr.add(new BigDecimal(String.valueOf(((Map)res.get(i)).get("ncwbb_jyhdxjlr"))));
            if (i != res.size() - 1) continue;
            result = ncwbbTzhdxjlr.divide(ncwbbJyhdxjlr.subtract(ncwbbJyhdxjlc), 2, 4);
        }
        i = this.getTemplateType();
        map.put("type", i == 1 ? "\u6708" : (i == 2 ? "\u5b63" : "\u5e74"));
        if (i == 1) {
            map.put("value", result);
        } else if (i == 2) {
            map.put("value", result.multiply(BigDecimal.valueOf(4L)));
        } else {
            map.put("value", result.multiply(BigDecimal.valueOf(12L)));
        }
        return ResponseDTO.ok(map);
    }
}

