/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.service;

import io.swagger.v3.oas.annotations.Operation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.YwfxDao;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.MonthEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.CpQdBySrCbMlMllEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.FzjdEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.MarginalCostn;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.ProportionEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.YwfxCostEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.YwfxCpEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.ywfxEntity.YwfxDataHTB;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class YwfxService {
    private static final Logger log = LoggerFactory.getLogger(YwfxService.class);
    @Resource
    private YwfxDao ywfxDao;

    public ResponseDTO<Map<String, BigDecimal>> query(long userid) {
        List list = this.ywfxDao.queryById(userid);
        Set latestYearSet = list.stream().max(Comparator.comparing(FzjdEntity::getNcwbbTime)).map(fzjd -> fzjd.getNcwbbTime().getYear()).map(year -> new HashSet<Integer>(Collections.singleton(year))).orElse(new HashSet());
        int latestYear = (Integer)latestYearSet.iterator().next();
        BigDecimal yysr = BigDecimal.valueOf(0L);
        BigDecimal jlr = BigDecimal.valueOf(0L);
        for (FzjdEntity fzjdEntity : list) {
            int year2 = fzjdEntity.getNcwbbTime().getYear();
            if (latestYear != year2) continue;
            yysr = yysr.add(fzjdEntity.getNcwbbYysr());
            jlr = jlr.add(fzjdEntity.getNcwbbJlr());
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put("yysr", yysr);
        result.put("jlr", jlr);
        Integer re = null;
        if (yysr.compareTo(BigDecimal.valueOf(5000000L)) < 0) {
            re = 0;
        } else if (yysr.compareTo(BigDecimal.valueOf(5000000L)) >= 0 && jlr.compareTo(BigDecimal.valueOf(50000000L)) < 0) {
            re = 1;
        } else if (jlr.compareTo(BigDecimal.valueOf(50000000L)) >= 0 && jlr.compareTo(BigDecimal.valueOf(500000000L)) < 0) {
            re = 2;
        } else if (jlr.compareTo(BigDecimal.valueOf(500000000L)) >= 0) {
            re = 3;
        }
        return ResponseDTO.ok(result);
    }

    public ResponseDTO<Integer> queryTotalCustomers(long userid) {
        List proportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        Long maxOrderYear = proportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).max().getAsLong();
        HashSet<String> khmcList = new HashSet<String>();
        for (ProportionEntity ProportionEntity2 : proportionEntityes) {
            if (!ProportionEntity2.getOrderYear().equals(maxOrderYear)) continue;
            khmcList.add(ProportionEntity2.getNsorderKhmc());
        }
        return ResponseDTO.ok((Object)khmcList.size());
    }

    public ResponseDTO<Map<String, String>> queryCustomers(long userid) {
        List ProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        HashSet<String> NotcurrentYearkhmcList = new HashSet<String>();
        Long currentYear = ProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).max().getAsLong();
        HashSet<String> currentYearkhmcList = new HashSet<String>();
        for (Object ProportionEntity2 : ProportionEntityes) {
            if (ProportionEntity2.getOrderYear().equals(currentYear)) {
                currentYearkhmcList.add(ProportionEntity2.getNsorderKhmc());
                continue;
            }
            NotcurrentYearkhmcList.add(ProportionEntity2.getNsorderKhmc());
        }
        int currentYearOldkhmcNumber = 0;
        for (String NotcurrentYearkhmc : NotcurrentYearkhmcList) {
            if (!currentYearkhmcList.contains(NotcurrentYearkhmc)) continue;
            ++currentYearOldkhmcNumber;
        }
        int currentYearNewkhmcNumber = currentYearkhmcList.size() - currentYearOldkhmcNumber;
        double oldCustomerRate = (double)currentYearOldkhmcNumber / (double)NotcurrentYearkhmcList.size() * 100.0;
        double newCustomerRate = (double)currentYearNewkhmcNumber / (double)currentYearkhmcList.size() * 100.0;
        DecimalFormat df = new DecimalFormat("0");
        HashMap<String, String> returned = new HashMap<String, String>();
        returned.put("newCustomerRate", df.format(newCustomerRate));
        returned.put("oldCustomerRate", df.format(oldCustomerRate));
        returned.put("title", String.valueOf(currentYear + "\u5e74\u6838\u5fc3\u6307\u6807"));
        return ResponseDTO.ok(returned);
    }

    public ResponseDTO<List<Map<String, String>>> queryCustomerConcentration(long userid) {
        List proportionEntities = this.ywfxDao.querynNameAndIncome(userid);
        Map<Long, List<ProportionEntity>> groupedByYear = proportionEntities.stream().collect(Collectors.groupingBy(ProportionEntity::getOrderYear));
        ArrayList result = new ArrayList();
        for (Map.Entry<Long, List<ProportionEntity>> entry : groupedByYear.entrySet()) {
            Long year = entry.getKey();
            List<ProportionEntity> yearEntities = entry.getValue();
            List sortedEntities = yearEntities.stream().sorted(Comparator.comparing(ProportionEntity::getTotalSre).reversed()).collect(Collectors.toList());
            BigDecimal totalIncomeForYear = yearEntities.stream().map(ProportionEntity::getTotalSre).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal top1IncomePercentage = YwfxService.calculateIncomePercentage(sortedEntities, (BigDecimal)totalIncomeForYear, (int)1);
            BigDecimal top5IncomePercentage = YwfxService.calculateIncomePercentage(sortedEntities, (BigDecimal)totalIncomeForYear, (int)5);
            BigDecimal top10IncomePercentage = YwfxService.calculateIncomePercentage(sortedEntities, (BigDecimal)totalIncomeForYear, (int)10);
            HashMap<String, String> proportionMap = new HashMap<String, String>();
            proportionMap.put("c_year", year.toString());
            proportionMap.put("c_cr1", top1IncomePercentage + "");
            proportionMap.put("c_cr5", top5IncomePercentage + "");
            proportionMap.put("c_cr10", top10IncomePercentage + "");
            result.add(proportionMap);
        }
        return ResponseDTO.ok(result);
    }

    private static BigDecimal calculateIncomePercentage(List<ProportionEntity> sortedEntities, BigDecimal totalIncomeForYear, int topN) {
        BigDecimal topNIncome = sortedEntities.stream().limit(topN).map(ProportionEntity::getTotalSre).reduce(BigDecimal.ZERO, BigDecimal::add);
        return topNIncome.multiply(BigDecimal.valueOf(100L)).divide(totalIncomeForYear, 2, 4);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewnNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        Integer maxMouth = this.ywfxDao.queryMaxMonthOfLatestYear2(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear) continue;
            zsr = zsr.add(srProportion.getTotalSre());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear) continue;
            srProportionEntity1.setNsorderKhmc(srProportionEntity.getNsorderKhmc());
            srProportionEntity1.setTotalSre(srProportionEntity.getTotalSre());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            srProportionEntity1.setTitle(currentYear + "\u5e74\u622a\u6b62" + maxMouth + "\u6708");
            srProportionEntity1.setProportion(srProportionEntity.getTotalSre().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSre).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldnNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear - 1L) continue;
            zsr = zsr.add(srProportion.getTotalSre());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear - 1L) continue;
            srProportionEntity1.setNsorderKhmc(srProportionEntity.getNsorderKhmc());
            srProportionEntity1.setTotalSre(srProportionEntity.getTotalSre());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            srProportionEntity1.setProportion(srProportionEntity.getTotalSre().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSre).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewKhNameAndMaori(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewKhNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getNcostKh() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mlProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getNsorderKhmc() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSre();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal grossProfitMargin = income.subtract(cost);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getNsorderKhmc());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(grossProfitMargin);
                mlProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mlProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mlProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity mlProportion : mlProportionEntityes) {
            if (mlProportion.getOrderYear() != currentYear) continue;
            zml = zml.add(mlProportion.getCpMl());
        }
        for (ProportionEntity mlProportionEntity : mlProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mlProportionEntity.getOrderYear() != currentYear) continue;
            mlProportionEntity1.setOrderCp(mlProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMl(mlProportionEntity.getCpMl());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            mlProportionEntity1.setProportion(mlProportionEntity.getCpMl().divide(zml, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mlProportionEntityList.add(mlProportionEntity1);
        }
        mlProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMl).reversed());
        if (mlProportionEntityList.size() > 10) {
            mlProportionEntityList = mlProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mlProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldKhNameAndMaori(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewKhNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getNcostKh() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mlProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getNsorderKhmc() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSre();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal grossProfitMargin = income.subtract(cost);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getNsorderKhmc());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(grossProfitMargin);
                mlProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mlProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mlProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity mlProportion : mlProportionEntityes) {
            if (mlProportion.getOrderYear() != currentYear - 1L) continue;
            zml = zml.add(mlProportion.getCpMl());
        }
        for (ProportionEntity mlProportionEntity : mlProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mlProportionEntity.getOrderYear() != currentYear - 1L) continue;
            mlProportionEntity1.setOrderCp(mlProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMl(mlProportionEntity.getCpMl());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            mlProportionEntity1.setProportion(mlProportionEntity.getCpMl().divide(zml, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mlProportionEntityList.add(mlProportionEntity1);
        }
        mlProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMl).reversed());
        if (mlProportionEntityList.size() > 10) {
            mlProportionEntityList = mlProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mlProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewKhNameAndGrossProfitMargin(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewKhNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getNcostKh() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mllProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getNsorderKhmc() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSre();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal maori = income.subtract(cost);
                BigDecimal bigDecimal = income.subtract(cost).divide(income, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getNsorderKhmc());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(maori);
                mlProportionEntity.setCpMll(bigDecimal);
                mlProportionEntity.setTotalSr(income);
                mllProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mllProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mllProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity proportionEntity : mllProportionEntityes) {
            if (proportionEntity.getOrderYear() != currentYear) continue;
            zml = zml.add(proportionEntity.getCpMl());
        }
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity mllProportion : mllProportionEntityes) {
            if (mllProportion.getOrderYear() != currentYear) continue;
            zsr = zsr.add(mllProportion.getTotalSr());
        }
        BigDecimal bigDecimal = zml.divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        for (ProportionEntity mllProportionEntity : mllProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mllProportionEntity.getOrderYear() != currentYear) continue;
            mlProportionEntity1.setOrderCp(mllProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMll(mllProportionEntity.getCpMll());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            mlProportionEntity1.setProportion(mllProportionEntity.getCpMll().divide(bigDecimal, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mllProportionEntityList.add(mlProportionEntity1);
        }
        mllProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMll).reversed());
        if (mllProportionEntityList.size() > 10) {
            mllProportionEntityList = mllProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mllProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldKhNameAndGrossProfitMargin(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.querynNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewKhNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getNcostKh() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mllProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getNsorderKhmc() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSre();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal maori = income.subtract(cost);
                BigDecimal bigDecimal = income.subtract(cost).divide(income, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getNsorderKhmc());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(maori);
                mlProportionEntity.setCpMll(bigDecimal);
                mlProportionEntity.setTotalSr(income);
                mllProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mllProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mllProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity proportionEntity : mllProportionEntityes) {
            if (proportionEntity.getOrderYear() != currentYear - 1L) continue;
            zml = zml.add(proportionEntity.getCpMl());
        }
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity mllProportion : mllProportionEntityes) {
            if (mllProportion.getOrderYear() != currentYear - 1L) continue;
            zsr = zsr.add(mllProportion.getTotalSr());
        }
        BigDecimal bigDecimal = zml.divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        for (ProportionEntity mllProportionEntity : mllProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mllProportionEntity.getOrderYear() != currentYear - 1L) continue;
            mlProportionEntity1.setOrderCp(mllProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMll(mllProportionEntity.getCpMll());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            mlProportionEntity1.setProportion(mllProportionEntity.getCpMll().divide(bigDecimal, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mllProportionEntityList.add(mlProportionEntity1);
        }
        mllProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMll).reversed());
        if (mllProportionEntityList.size() > 10) {
            mllProportionEntityList = mllProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mllProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewCpNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        Integer maxMouth = this.ywfxDao.queryMaxMonthOfLatestYear(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear) continue;
            zsr = zsr.add(srProportion.getTotalSr());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear) continue;
            srProportionEntity1.setOrderCp(srProportionEntity.getOrderCp());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            srProportionEntity1.setTitle(currentYear + "\u5e74\u622a\u6b62" + maxMouth + "\u6708");
            srProportionEntity1.setProportion(srProportionEntity.getTotalSr().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSr).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldCpNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear - 1L) continue;
            zsr = zsr.add(srProportion.getTotalSr());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear - 1L) continue;
            srProportionEntity1.setOrderCp(srProportionEntity.getOrderCp());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            srProportionEntity1.setProportion(srProportionEntity.getTotalSr().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSr).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewCpNameAndMaori(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewCpNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getCostCp() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mlProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getOrderCp() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSr();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal grossProfitMargin = income.subtract(cost);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getOrderCp());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(grossProfitMargin);
                mlProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mlProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mlProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity mlProportion : mlProportionEntityes) {
            if (mlProportion.getOrderYear() != currentYear) continue;
            zml = zml.add(mlProportion.getCpMl());
        }
        for (ProportionEntity mlProportionEntity : mlProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mlProportionEntity.getOrderYear() != currentYear) continue;
            mlProportionEntity1.setOrderCp(mlProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMl(mlProportionEntity.getCpMl());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            mlProportionEntity1.setProportion(mlProportionEntity.getCpMl().divide(zml, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mlProportionEntityList.add(mlProportionEntity1);
        }
        mlProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMl).reversed());
        if (mlProportionEntityList.size() > 10) {
            mlProportionEntityList = mlProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mlProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldCpNameAndMaori(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewCpNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getCostCp() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mlProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getOrderCp() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSr();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal maori = income.subtract(cost);
                BigDecimal grossProfitMargin = income.subtract(cost).divide(income, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getOrderCp());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(maori);
                mlProportionEntity.setCpMll(grossProfitMargin);
                mlProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mlProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mlProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity mlProportion : mlProportionEntityes) {
            if (mlProportion.getOrderYear() != currentYear - 1L) continue;
            zml = zml.add(mlProportion.getCpMl());
        }
        for (ProportionEntity mlProportionEntity : mlProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mlProportionEntity.getOrderYear() != currentYear - 1L) continue;
            mlProportionEntity1.setOrderCp(mlProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMl(mlProportionEntity.getCpMl());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            mlProportionEntity1.setProportion(mlProportionEntity.getCpMl().divide(zml, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mlProportionEntityList.add(mlProportionEntity1);
        }
        mlProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMl).reversed());
        if (mlProportionEntityList.size() > 10) {
            mlProportionEntityList = mlProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mlProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewCpNameAndGrossProfitMargin(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewCpNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getCostCp() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mllProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getOrderCp() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSr();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal maori = income.subtract(cost);
                BigDecimal bigDecimal = income.subtract(cost).divide(income, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getOrderCp());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(maori);
                mlProportionEntity.setCpMll(bigDecimal);
                mlProportionEntity.setTotalSr(income);
                mllProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mllProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mllProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity proportionEntity : mllProportionEntityes) {
            if (proportionEntity.getOrderYear() != currentYear) continue;
            zml = zml.add(proportionEntity.getCpMl());
        }
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity mllProportion : mllProportionEntityes) {
            if (mllProportion.getOrderYear() != currentYear) continue;
            zsr = zsr.add(mllProportion.getTotalSr());
        }
        BigDecimal bigDecimal = zml.divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        for (ProportionEntity mllProportionEntity : mllProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mllProportionEntity.getOrderYear() != currentYear) continue;
            mlProportionEntity1.setOrderCp(mllProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMll(mllProportionEntity.getCpMll());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            mlProportionEntity1.setProportion(mllProportionEntity.getCpMll().divide(bigDecimal, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mllProportionEntityList.add(mlProportionEntity1);
        }
        mllProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMll).reversed());
        if (mllProportionEntityList.size() > 10) {
            mllProportionEntityList = mllProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mllProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldCpNameAndGrossProfitMargin(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewCpNameAndIncome(userid);
        List cbProportionEntityes = this.ywfxDao.queryNewCpNameAndCost(userid);
        HashMap<String, Object> costMap = new HashMap<String, Object>();
        for (Object cbProportionEntity : cbProportionEntityes) {
            String key = cbProportionEntity.getCostCp() + "_" + cbProportionEntity.getCostYear();
            costMap.put(key, cbProportionEntity);
        }
        ArrayList<ProportionEntity> mllProportionEntityes = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            String key = srProportionEntity.getOrderCp() + "_" + srProportionEntity.getOrderYear();
            ProportionEntity cbProportionEntity = (ProportionEntity)costMap.get(key);
            if (cbProportionEntity != null) {
                BigDecimal income = srProportionEntity.getTotalSr();
                BigDecimal cost = cbProportionEntity.getTotalCb();
                BigDecimal maori = income.subtract(cost);
                BigDecimal bigDecimal = income.subtract(cost).divide(income, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
                ProportionEntity mlProportionEntity = new ProportionEntity();
                mlProportionEntity.setOrderCp(srProportionEntity.getOrderCp());
                mlProportionEntity.setOrderYear(srProportionEntity.getOrderYear());
                mlProportionEntity.setCpMl(maori);
                mlProportionEntity.setCpMll(bigDecimal);
                mlProportionEntity.setTotalSr(income);
                mllProportionEntityes.add(mlProportionEntity);
                continue;
            }
            System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6570\u636e\uff1a" + key);
        }
        long finalCurrentYear = currentYear = 0L;
        currentYear = mllProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> mllProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zml = BigDecimal.valueOf(0L);
        for (ProportionEntity proportionEntity : mllProportionEntityes) {
            if (proportionEntity.getOrderYear() != currentYear - 1L) continue;
            zml = zml.add(proportionEntity.getCpMl());
        }
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity mllProportion : mllProportionEntityes) {
            if (mllProportion.getOrderYear() != currentYear - 1L) continue;
            zsr = zsr.add(mllProportion.getTotalSr());
        }
        BigDecimal bigDecimal = zml.divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4);
        for (ProportionEntity mllProportionEntity : mllProportionEntityes) {
            ProportionEntity mlProportionEntity1 = new ProportionEntity();
            if (mllProportionEntity.getOrderYear() != currentYear - 1L) continue;
            mlProportionEntity1.setOrderCp(mllProportionEntity.getOrderCp());
            mlProportionEntity1.setCpMll(mllProportionEntity.getCpMll());
            mlProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            mlProportionEntity1.setProportion(mllProportionEntity.getCpMll().divide(bigDecimal, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            mllProportionEntityList.add(mlProportionEntity1);
        }
        mllProportionEntityList.sort(Comparator.comparing(ProportionEntity::getCpMll).reversed());
        if (mllProportionEntityList.size() > 10) {
            mllProportionEntityList = mllProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(mllProportionEntityList);
    }

    public ResponseDTO<List<YwfxCpEntity>> queryPriceDemand(long userid) {
        List ywfxCpEntitie = this.ywfxDao.queryMonthCpXlJg(userid);
        System.out.println(ywfxCpEntitie);
        HashMap<String, Map> productData = new HashMap<String, Map>();
        for (Object entity2 : ywfxCpEntitie) {
            productData.computeIfAbsent(entity2.getOrderCp(), k -> new HashMap()).put(entity2.getOrderYearmonth(), entity2);
        }
        ArrayList<YwfxCpEntity> resultList = new ArrayList<YwfxCpEntity>();
        for (String product : productData.keySet()) {
            Map productSalesData = (Map)productData.get(product);
            for (YearMonth month : productSalesData.keySet()) {
                YwfxCpEntity resultEntity;
                YwfxCpEntity currentMonthData = (YwfxCpEntity)productSalesData.get(month);
                YearMonth previousMonth = month.minusMonths(1L);
                YwfxCpEntity previousYearMonthData = (YwfxCpEntity)productSalesData.get(previousMonth);
                if (previousYearMonthData == null) continue;
                BigDecimal salesChange = currentMonthData.getCpXl().subtract(previousYearMonthData.getCpXl()).abs();
                BigDecimal priceChange = currentMonthData.getCpZjg().divide(currentMonthData.getCpXl(), 10, 4).abs().subtract(previousYearMonthData.getCpZjg().divide(previousYearMonthData.getCpXl(), 10, 4)).abs();
                BigDecimal averageSales = currentMonthData.getCpXl().add(previousYearMonthData.getCpXl()).divide(BigDecimal.valueOf(2L), 2, 4).abs();
                BigDecimal averagePrice = currentMonthData.getCpZjg().divide(currentMonthData.getCpXl(), 10, 4).add(previousYearMonthData.getCpZjg().divide(previousYearMonthData.getCpXl(), 10, 4)).divide(BigDecimal.valueOf(2L), 10, 4).abs();
                if (priceChange.compareTo(BigDecimal.ZERO) == 0) {
                    resultEntity = new YwfxCpEntity();
                    resultEntity.setOrderCp(product);
                    resultEntity.setOrderYearmonth(month);
                    resultEntity.setCpXl(BigDecimal.ZERO);
                    resultList.add(resultEntity);
                    continue;
                }
                if (salesChange.compareTo(BigDecimal.ZERO) == 0) {
                    resultEntity = new YwfxCpEntity();
                    resultEntity.setOrderCp(product);
                    resultEntity.setOrderYearmonth(month);
                    resultEntity.setCpXl(BigDecimal.ZERO);
                    resultList.add(resultEntity);
                    continue;
                }
                BigDecimal priceElasticity = salesChange.divide(averageSales, 10, 4).divide(priceChange.divide(averagePrice, 10, 4), 10, 4).abs();
                YwfxCpEntity resultEntity2 = new YwfxCpEntity();
                resultEntity2.setOrderCp(product);
                resultEntity2.setOrderYearmonth(month);
                resultEntity2.setCpXl(priceElasticity);
                resultList.add(resultEntity2);
            }
        }
        resultList.sort(Comparator.comparing(YwfxCpEntity::getOrderYearmonth));
        Optional<YearMonth> latestYearMonth = resultList.stream().map(YwfxCpEntity::getOrderYearmonth).max(YearMonth::compareTo);
        if (latestYearMonth.isPresent()) {
            int latestYear = latestYearMonth.get().getYear();
            List latestYearData = resultList.stream().filter(entity -> entity.getOrderYearmonth().getYear() == latestYear).collect(Collectors.toList());
            return ResponseDTO.ok(latestYearData);
        }
        return ResponseDTO.ok(Collections.emptyList());
    }

    public ResponseDTO<List<CpQdBySrCbMlMllEntity>> queryMarginalCost(long userid) {
        List ywfxQdEntitie = this.ywfxDao.queryMonthQdXlCb(userid);
        HashMap<String, Map> productData = new HashMap<String, Map>();
        for (Object entity2 : ywfxQdEntitie) {
            productData.computeIfAbsent(entity2.getCpProduct(), k -> new HashMap()).put(entity2.getCpMonth(), entity2);
        }
        ArrayList<CpQdBySrCbMlMllEntity> resultList = new ArrayList<CpQdBySrCbMlMllEntity>();
        for (String product : productData.keySet()) {
            Map productSalesData = (Map)productData.get(product);
            for (YearMonth month : productSalesData.keySet()) {
                CpQdBySrCbMlMllEntity resultEntity;
                CpQdBySrCbMlMllEntity currentMonthData = (CpQdBySrCbMlMllEntity)productSalesData.get(month);
                YearMonth previousMonth = month.minusMonths(1L);
                CpQdBySrCbMlMllEntity previousYearMonthData = (CpQdBySrCbMlMllEntity)productSalesData.get(previousMonth);
                if (previousYearMonthData == null) continue;
                BigDecimal salesChange = currentMonthData.getCpXl().subtract(previousYearMonthData.getCpXl()).abs();
                BigDecimal costChange = currentMonthData.getCpCost().subtract(previousYearMonthData.getCpCost());
                System.out.println("\u9500\u91cf\u53d8\u5316");
                System.out.println(salesChange);
                System.out.println("\u6210\u672c\u53d8\u5316");
                System.out.println(costChange);
                BigDecimal averageSales = currentMonthData.getCpXl().add(previousYearMonthData.getCpXl()).divide(BigDecimal.valueOf(2L), 10, 4).abs();
                BigDecimal averageCost = currentMonthData.getCpCost().add(previousYearMonthData.getCpCost()).divide(BigDecimal.valueOf(2L), 10, 4);
                System.out.println("\u5e73\u5747\u9500\u91cf");
                System.out.println(averageSales);
                System.out.println("\u5e73\u5747\u6210\u672c");
                System.out.println(averageCost);
                if (salesChange.compareTo(BigDecimal.ZERO) == 0) {
                    resultEntity = new CpQdBySrCbMlMllEntity();
                    resultEntity.setCpProduct(product);
                    resultEntity.setCpMonth(month);
                    resultEntity.setCpXl(BigDecimal.ZERO);
                    resultList.add(resultEntity);
                    continue;
                }
                if (costChange.compareTo(BigDecimal.ZERO) == 0) {
                    resultEntity = new CpQdBySrCbMlMllEntity();
                    resultEntity.setCpProduct(product);
                    resultEntity.setCpMonth(month);
                    resultEntity.setCpXl(BigDecimal.ZERO);
                    resultList.add(resultEntity);
                    continue;
                }
                System.out.println("\u6210\u672c\u53d8\u5316/\u5e73\u5747\u6210\u672c\uff1a" + costChange.divide(averageCost, 10, 4));
                System.out.println("\u9500\u91cf\u53d8\u5316/\u5e73\u5747\u9500\u91cf\uff1a" + salesChange.divide(averageSales, 10, 4));
                BigDecimal priceElasticity = costChange.divide(averageCost, 10, 4).divide(salesChange.divide(averageSales, 10, 4), 10, 4).abs();
                System.out.println("\u4ea7\u54c1 " + product + " \u5728 " + month + " \u7684\u8fb9\u9645\u6210\u672c: " + priceElasticity);
                CpQdBySrCbMlMllEntity resultEntity2 = new CpQdBySrCbMlMllEntity();
                resultEntity2.setCpProduct(product);
                resultEntity2.setCpMonth(month);
                resultEntity2.setCpXl(priceElasticity);
                resultList.add(resultEntity2);
            }
        }
        resultList.sort(Comparator.comparing(CpQdBySrCbMlMllEntity::getCpMonth));
        Optional<YearMonth> latestYearMonth = resultList.stream().map(CpQdBySrCbMlMllEntity::getCpMonth).max(YearMonth::compareTo);
        if (latestYearMonth.isPresent()) {
            int latestYear = latestYearMonth.get().getYear();
            List latestYearData = resultList.stream().filter(entity -> entity.getCpMonth().getYear() == latestYear).collect(Collectors.toList());
            return ResponseDTO.ok(latestYearData);
        }
        return ResponseDTO.ok(Collections.emptyList());
    }

    @Operation(summary="\u83b7\u53d6\u4ea4\u4ed8\u5468\u671f\u5206\u6790")
    public ResponseDTO<List<Map<String, Object>>> getDeliveryCycle(String employeeId) {
        return ResponseDTO.ok((Object)this.ywfxDao.queryDeliveryCycle(employeeId));
    }

    public ResponseDTO<List<MarginalCostn>> queryMarginalCostn(long userid) {
        List ywfxQdEntitie = this.ywfxDao.queryMarginalCostn(userid);
        ywfxQdEntitie.sort(Comparator.comparing(MarginalCostn::getKhMonth));
        HashMap<YearMonth, MarginalCostn> monthMap = new HashMap<YearMonth, MarginalCostn>();
        for (MarginalCostn m : ywfxQdEntitie) {
            monthMap.put(m.getKhMonth(), m);
        }
        ArrayList<MarginalCostn> resultList = new ArrayList<MarginalCostn>();
        for (MarginalCostn current : ywfxQdEntitie) {
            MarginalCostn prev;
            YearMonth currentMonth = current.getKhMonth();
            YearMonth prevMonth = currentMonth.minusMonths(1L);
            if (monthMap.containsKey(prevMonth)) {
                MarginalCostn prevOriginal = (MarginalCostn)monthMap.get(prevMonth);
                prev = new MarginalCostn();
                prev.setUserId(prevOriginal.getUserId());
                prev.setKhMonth(prevMonth);
                prev.setAllCost(prevOriginal.getAllCost() != null ? prevOriginal.getAllCost() : BigDecimal.ZERO);
                prev.setKhXl(prevOriginal.getKhXl() != null ? prevOriginal.getKhXl() : BigDecimal.ZERO);
            } else {
                prev = new MarginalCostn();
                prev.setUserId(current.getUserId());
                prev.setKhMonth(prevMonth);
                prev.setAllCost(BigDecimal.ZERO);
                prev.setKhXl(BigDecimal.ZERO);
            }
            BigDecimal currentCost = current.getAllCost() != null ? current.getAllCost() : BigDecimal.ZERO;
            BigDecimal prevCost = prev.getAllCost();
            BigDecimal costChange = currentCost.subtract(prevCost).abs();
            BigDecimal avgCost = currentCost.add(prevCost).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            BigDecimal currentXl = current.getKhXl() != null ? current.getKhXl() : BigDecimal.ZERO;
            BigDecimal prevXl = prev.getKhXl();
            BigDecimal xlChange = currentXl.subtract(prevXl).abs();
            BigDecimal avgXl = currentXl.add(prevXl).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            BigDecimal marginalRate = BigDecimal.ZERO;
            try {
                if (!avgCost.equals(BigDecimal.ZERO) && !xlChange.equals(BigDecimal.ZERO)) {
                    BigDecimal costRatio = costChange.divide(avgCost, 10, RoundingMode.HALF_UP);
                    BigDecimal xlRatio = xlChange.divide(avgXl, 10, RoundingMode.HALF_UP);
                    if (!xlRatio.equals(BigDecimal.ZERO)) {
                        marginalRate = costRatio.divide(xlRatio, 10, RoundingMode.HALF_UP).abs();
                    }
                }
            }
            catch (ArithmeticException costRatio) {
                // empty catch block
            }
            MarginalCostn entity = new MarginalCostn();
            entity.setKhMonth(currentMonth);
            entity.setMarginalRate(marginalRate);
            resultList.add(entity);
        }
        System.out.println(resultList);
        return ResponseDTO.ok(resultList);
    }

    public ResponseDTO<List<ProportionEntity>> queryNewQdNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewQdNameAndIncome(userid);
        Integer maxMouth = this.ywfxDao.queryMaxMonthOfLatestYear(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear) continue;
            zsr = zsr.add(srProportion.getTotalSr());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear) continue;
            srProportionEntity1.setOrderQd(srProportionEntity.getOrderQd());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            srProportionEntity1.setTitle(currentYear + "\u5e74\u622a\u6b62" + maxMouth + "\u6708");
            srProportionEntity1.setProportion(srProportionEntity.getTotalSr().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSr).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<CpQdBySrCbMlMllEntity>> queryNewQdNameAndMl(long userid) {
        List cpQdBySrCbMlMllEntity = this.ywfxDao.queryCpQdBySrCbMlMll(userid);
        Optional<YearMonth> latestDate = cpQdBySrCbMlMllEntity.stream().map(CpQdBySrCbMlMllEntity::getCpMonth).max(YearMonth::compareTo);
        YearMonth newDate = latestDate.get();
        List latestEntities = cpQdBySrCbMlMllEntity.stream().filter(entity -> entity.getCpMonth().getYear() == newDate.getYear()).collect(Collectors.toList());
        Map<String, BigDecimal> channelProfitMap = latestEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpGrossprofit, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal totalProfit = channelProfitMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<CpQdBySrCbMlMllEntity> resultList = new ArrayList<CpQdBySrCbMlMllEntity>();
        for (Map.Entry<String, BigDecimal> entry : channelProfitMap.entrySet()) {
            String channel = entry.getKey();
            BigDecimal profit = entry.getValue();
            BigDecimal profitPercentage = totalProfit.compareTo(BigDecimal.ZERO) > 0 ? profit.multiply(BigDecimal.valueOf(100L)).divide(totalProfit, 2, 4) : BigDecimal.ZERO;
            CpQdBySrCbMlMllEntity resultEntity = new CpQdBySrCbMlMllEntity();
            resultEntity.setCpChannel(channel);
            resultEntity.setCpGrossprofit(profit);
            resultEntity.setProportion(profitPercentage);
            resultList.add(resultEntity);
        }
        resultList.sort(Comparator.comparing(CpQdBySrCbMlMllEntity::getCpGrossprofit).reversed());
        if (resultList.size() > 10) {
            resultList = new ArrayList(resultList.subList(0, 10));
        }
        return ResponseDTO.ok(resultList);
    }

    public ResponseDTO<List<CpQdBySrCbMlMllEntity>> queryOldQdNameAndMl(long userid) {
        List cpQdBySrCbMlMllEntity = this.ywfxDao.queryCpQdBySrCbMlMll(userid);
        Optional<YearMonth> latestDate = cpQdBySrCbMlMllEntity.stream().map(CpQdBySrCbMlMllEntity::getCpMonth).max(YearMonth::compareTo);
        YearMonth newYearMonth = latestDate.get();
        List lastYearEntities = cpQdBySrCbMlMllEntity.stream().filter(entity -> entity.getCpMonth().getYear() == newYearMonth.getYear() - 1).collect(Collectors.toList());
        Map<String, BigDecimal> channelProfitMap = lastYearEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpGrossprofit, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal totalProfit = channelProfitMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<CpQdBySrCbMlMllEntity> resultList = new ArrayList<CpQdBySrCbMlMllEntity>();
        for (Map.Entry<String, BigDecimal> entry : channelProfitMap.entrySet()) {
            String channel = entry.getKey();
            BigDecimal profit = entry.getValue();
            BigDecimal profitPercentage = totalProfit.compareTo(BigDecimal.ZERO) > 0 ? profit.multiply(BigDecimal.valueOf(100L)).divide(totalProfit, 2, 4) : BigDecimal.ZERO;
            CpQdBySrCbMlMllEntity resultEntity = new CpQdBySrCbMlMllEntity();
            resultEntity.setCpChannel(channel);
            resultEntity.setCpGrossprofit(profit);
            resultEntity.setProportion(profitPercentage);
            resultList.add(resultEntity);
        }
        resultList.sort(Comparator.comparing(CpQdBySrCbMlMllEntity::getCpGrossprofit).reversed());
        if (resultList.size() > 10) {
            resultList = new ArrayList(resultList.subList(0, 10));
        }
        return ResponseDTO.ok(resultList);
    }

    public ResponseDTO<List<CpQdBySrCbMlMllEntity>> queryNewQdNameAndMll(long userid) {
        List cpQdBySrCbMlMllEntity = this.ywfxDao.queryCpQdBySrCbMlMll(userid);
        Optional<YearMonth> latestDate = cpQdBySrCbMlMllEntity.stream().map(CpQdBySrCbMlMllEntity::getCpMonth).max(YearMonth::compareTo);
        YearMonth newDate = latestDate.get();
        List latestEntities = cpQdBySrCbMlMllEntity.stream().filter(entity -> entity.getCpMonth().equals(newDate)).collect(Collectors.toList());
        Map<String, BigDecimal> channelProfitMap = latestEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpGrossprofit, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<String, BigDecimal> channelSrMap = latestEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpRevenue, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal totalProfit = channelProfitMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSr = channelSrMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<CpQdBySrCbMlMllEntity> resultList = new ArrayList<CpQdBySrCbMlMllEntity>();
        for (Map.Entry<String, BigDecimal> entry : channelProfitMap.entrySet()) {
            String channel = entry.getKey();
            BigDecimal totalChannelProfit = entry.getValue();
            BigDecimal totalChannelRevenue = channelSrMap.get(channel);
            BigDecimal profitMargin = BigDecimal.ZERO;
            if (totalChannelRevenue.compareTo(BigDecimal.ZERO) > 0) {
                profitMargin = totalChannelProfit.divide(totalChannelRevenue, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            }
            BigDecimal profitShare = BigDecimal.ZERO;
            if (totalProfit.compareTo(BigDecimal.ZERO) > 0) {
                profitShare = totalChannelProfit.divide(totalProfit, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            }
            CpQdBySrCbMlMllEntity resultEntity = new CpQdBySrCbMlMllEntity();
            resultEntity.setCpChannel(channel);
            resultEntity.setCpMll(profitMargin);
            resultList.add(resultEntity);
        }
        resultList.sort(Comparator.comparing(CpQdBySrCbMlMllEntity::getCpMll).reversed());
        if (resultList.size() > 10) {
            resultList = new ArrayList(resultList.subList(0, 10));
        }
        return ResponseDTO.ok(resultList);
    }

    public ResponseDTO<List<CpQdBySrCbMlMllEntity>> queryOldQdNameAndMll(long userid) {
        List cpQdBySrCbMlMllEntity = this.ywfxDao.queryCpQdBySrCbMlMll(userid);
        Optional<YearMonth> latestDate = cpQdBySrCbMlMllEntity.stream().map(CpQdBySrCbMlMllEntity::getCpMonth).max(YearMonth::compareTo);
        YearMonth newDate = latestDate.get();
        List latestEntities = cpQdBySrCbMlMllEntity.stream().filter(entity -> entity.getCpMonth().equals(newDate)).collect(Collectors.toList());
        YearMonth newYearMonth = latestDate.get();
        YearMonth startOfLastYear = YearMonth.of(newYearMonth.getYear() - 1, 1);
        YearMonth endOfLastYear = YearMonth.of(newYearMonth.getYear() - 1, 12);
        List lastYearEntities = cpQdBySrCbMlMllEntity.stream().filter(entity -> !entity.getCpMonth().isBefore(startOfLastYear) && !entity.getCpMonth().isAfter(endOfLastYear)).collect(Collectors.toList());
        Map<String, BigDecimal> channelProfitMap = lastYearEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpGrossprofit, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<String, BigDecimal> channelSrMap = lastYearEntities.stream().collect(Collectors.groupingBy(CpQdBySrCbMlMllEntity::getCpChannel, Collectors.mapping(CpQdBySrCbMlMllEntity::getCpRevenue, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal totalProfit = channelProfitMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSr = channelSrMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<CpQdBySrCbMlMllEntity> resultList = new ArrayList<CpQdBySrCbMlMllEntity>();
        for (Map.Entry<String, BigDecimal> entry : channelProfitMap.entrySet()) {
            String channel = entry.getKey();
            BigDecimal totalChannelProfit = entry.getValue();
            BigDecimal totalChannelRevenue = channelSrMap.get(channel);
            BigDecimal profitMargin = BigDecimal.ZERO;
            if (totalChannelRevenue.compareTo(BigDecimal.ZERO) > 0) {
                profitMargin = totalChannelProfit.divide(totalChannelRevenue, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            }
            BigDecimal profitShare = BigDecimal.ZERO;
            if (totalProfit.compareTo(BigDecimal.ZERO) > 0) {
                profitShare = totalChannelProfit.divide(totalProfit, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            }
            CpQdBySrCbMlMllEntity resultEntity = new CpQdBySrCbMlMllEntity();
            resultEntity.setCpChannel(channel);
            resultEntity.setCpMll(profitMargin);
            resultList.add(resultEntity);
        }
        resultList.sort(Comparator.comparing(CpQdBySrCbMlMllEntity::getCpMll).reversed());
        if (resultList.size() > 10) {
            resultList = new ArrayList(resultList.subList(0, 10));
        }
        return ResponseDTO.ok(resultList);
    }

    public ResponseDTO<List<ProportionEntity>> queryOldQdNameAndIncome(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryNewQdNameAndIncome(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        List<ProportionEntity> srProportionEntityList = new ArrayList<ProportionEntity>();
        BigDecimal zsr = BigDecimal.valueOf(0L);
        for (ProportionEntity srProportion : srProportionEntityes) {
            if (srProportion.getOrderYear() != currentYear - 1L) continue;
            zsr = zsr.add(srProportion.getTotalSr());
        }
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear - 1L) continue;
            srProportionEntity1.setOrderQd(srProportionEntity.getOrderQd());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear - 1L));
            srProportionEntity1.setProportion(srProportionEntity.getTotalSr().divide(zsr, 4, 4).multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
            srProportionEntityList.add(srProportionEntity1);
        }
        srProportionEntityList.sort(Comparator.comparing(ProportionEntity::getTotalSr).reversed());
        if (srProportionEntityList.size() > 10) {
            srProportionEntityList = srProportionEntityList.subList(0, 10);
        }
        return ResponseDTO.ok(srProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> getQdBySr(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryQdNameAndCpSr(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        ArrayList<ProportionEntity> ProportionEntityList = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear) continue;
            srProportionEntity1.setOrderQd(srProportionEntity.getOrderQd());
            srProportionEntity1.setOrderCp(srProportionEntity.getOrderCp());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setTotalXl(srProportionEntity.getTotalXl());
            srProportionEntity1.setOrderPjjg(srProportionEntity.getOrderPjjg());
            ProportionEntityList.add(srProportionEntity1);
        }
        System.out.println(ProportionEntityList);
        return ResponseDTO.ok(ProportionEntityList);
    }

    public ResponseDTO<List<ProportionEntity>> getCpByQdSr(long userid) {
        long currentYear;
        List srProportionEntityes = this.ywfxDao.queryCpNameAndQdSr(userid);
        long finalCurrentYear = currentYear = 0L;
        currentYear = srProportionEntityes.stream().mapToLong(ProportionEntity::getOrderYear).filter(orderYear -> orderYear > finalCurrentYear).max().orElse(currentYear);
        ArrayList<ProportionEntity> ProportionEntityList = new ArrayList<ProportionEntity>();
        for (ProportionEntity srProportionEntity : srProportionEntityes) {
            ProportionEntity srProportionEntity1 = new ProportionEntity();
            if (srProportionEntity.getOrderYear() != currentYear) continue;
            srProportionEntity1.setOrderCp(srProportionEntity.getOrderCp());
            srProportionEntity1.setOrderQd(srProportionEntity.getOrderQd());
            srProportionEntity1.setTotalSr(srProportionEntity.getTotalSr());
            srProportionEntity1.setOrderPjjg(srProportionEntity.getOrderPjjg());
            srProportionEntity1.setTotalXl(srProportionEntity.getTotalXl());
            srProportionEntity1.setOrderYear(Long.valueOf(currentYear));
            ProportionEntityList.add(srProportionEntity1);
        }
        Map<String, List<ProportionEntity>> productGroup = ProportionEntityList.stream().collect(Collectors.groupingBy(ProportionEntity::getOrderCp));
        ArrayList<Map.Entry<String, List<ProportionEntity>>> sortedProducts = new ArrayList<Map.Entry<String, List<ProportionEntity>>>(productGroup.entrySet());
        sortedProducts.sort((e1, e2) -> {
            BigDecimal totalSr1 = ((List)e1.getValue()).stream().map(ProportionEntity::getTotalSr).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalSr2 = ((List)e2.getValue()).stream().map(ProportionEntity::getTotalSr).reduce(BigDecimal.ZERO, BigDecimal::add);
            return totalSr2.compareTo(totalSr1);
        });
        ArrayList sortedList = new ArrayList();
        for (Map.Entry entry : sortedProducts) {
            List channelList = (List)entry.getValue();
            channelList.sort((e1, e2) -> e2.getTotalSr().compareTo(e1.getTotalSr()));
            sortedList.addAll(channelList);
        }
        return ResponseDTO.ok(sortedList);
    }

    public ResponseDTO<List<YwfxDataHTB>> getMonthDataNorm(String userId, String selectedValue) {
        List ywfxCostEntities = this.ywfxDao.queryNormClRgFyByAll(Long.parseLong(userId));
        ArrayList<YwfxDataHTB> ywfxDataHTBList = new ArrayList<YwfxDataHTB>();
        String grading = "1";
        YwfxDataHTB cl = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u6750\u6599\u6210\u672c");
        YwfxDataHTB rg = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u4eba\u5de5\u6210\u672c");
        YwfxDataHTB fy = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u5236\u9020\u8d39\u7528");
        ywfxDataHTBList.add(cl);
        ywfxDataHTBList.add(rg);
        ywfxDataHTBList.add(fy);
        return ResponseDTO.ok(ywfxDataHTBList);
    }

    public ResponseDTO<Map<String, List<YwfxDataHTB>>> getCpMonthDataNorm(String userId, String selectedValue) {
        List ywfxCostEntities = this.ywfxDao.queryNormClRgFyByCp(Long.parseLong(userId));
        String grading = "1";
        List cl = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u6750\u6599\u6210\u672c");
        List rg = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u4eba\u5de5\u6210\u672c");
        List fy = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u5236\u9020\u8d39\u7528");
        ArrayList allList = new ArrayList();
        allList.addAll(cl);
        allList.addAll(rg);
        allList.addAll(fy);
        Map categorizedData = this.adjustList(allList);
        return ResponseDTO.ok((Object)categorizedData);
    }

    public ResponseDTO<List<YwfxDataHTB>> getMonthDataNotNorm(String userId, String selectedValue) {
        List ywfxCostEntities = this.ywfxDao.queryNotNormClRgFyByAll(Long.parseLong(userId));
        System.out.println(ywfxCostEntities);
        ArrayList<YwfxDataHTB> ywfxDataHTBList = new ArrayList<YwfxDataHTB>();
        String grading = "1";
        YwfxDataHTB cl = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u6750\u6599\u6210\u672c");
        YwfxDataHTB rg = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u4eba\u5de5\u6210\u672c");
        YwfxDataHTB fy = YwfxService.calculateYoYAndMoM_NCP((List)ywfxCostEntities, (String)"\u5236\u9020\u8d39\u7528");
        ywfxDataHTBList.add(cl);
        ywfxDataHTBList.add(rg);
        ywfxDataHTBList.add(fy);
        return ResponseDTO.ok(ywfxDataHTBList);
    }

    public ResponseDTO<Map<String, List<YwfxDataHTB>>> getCpMonthDataNotNorm(String userId, String selectedValue) {
        List ywfxCostEntities = this.ywfxDao.queryNotNormClRgFyByCp(Long.parseLong(userId));
        String grading = "1";
        List cl = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u6750\u6599\u6210\u672c");
        List rg = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u4eba\u5de5\u6210\u672c");
        List fy = YwfxService.calculateYoYAndMoM_CP((List)ywfxCostEntities, (String)"\u5236\u9020\u8d39\u7528");
        ArrayList allList = new ArrayList();
        allList.addAll(cl);
        allList.addAll(rg);
        allList.addAll(fy);
        Map categorizedData = this.adjustList(allList);
        return ResponseDTO.ok((Object)categorizedData);
    }

    public static YwfxDataHTB calculateYoYAndMoM_NCP(List<YwfxCostEntity> monthEntities, String type) {
        ArrayList<YearMonth> months = new ArrayList<YearMonth>();
        for (YwfxCostEntity monthEntity : monthEntities) {
            months.add(monthEntity.getCostTime());
        }
        Collections.sort(months);
        System.out.println(months);
        YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
        YearMonth previousMonthTime = currentTime.minusMonths(1L);
        YearMonth previousQuarterTime = currentTime.minusMonths(4L);
        YearMonth previousYearTime = currentTime.minusYears(1L);
        BigDecimal currentMonthData = new BigDecimal(0);
        BigDecimal previousMonthData = new BigDecimal(0);
        BigDecimal previousYearData = new BigDecimal(0);
        currentMonthData = YwfxService.getMonthData(monthEntities, (YearMonth)currentTime, (String)type);
        previousMonthData = YwfxService.getMonthData(monthEntities, (YearMonth)previousMonthTime, (String)type);
        previousYearData = YwfxService.getMonthData(monthEntities, (YearMonth)previousYearTime, (String)type);
        BigDecimal yoy = new BigDecimal(0);
        BigDecimal mom = new BigDecimal(0);
        if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
            mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        } else {
            System.out.println("\u4e0a\u4e2a\u6708\u6ca1\u6709\u6570\u636e\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
        }
        if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
            yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        } else {
            System.out.println("\u4e0a\u5e74\u540c\u671f\u6ca1\u6709\u6570\u636e\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
        }
        BigDecimal currentYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearCumulative = BigDecimal.ZERO;
        BigDecimal previousYearyoy = BigDecimal.ZERO;
        for (YearMonth yearMonth : months) {
            if (yearMonth.getYear() == currentTime.getYear()) {
                currentYearCumulative = currentYearCumulative.add(YwfxService.getMonthData(monthEntities, (YearMonth)yearMonth, (String)type));
                continue;
            }
            if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
            previousYearCumulative = previousYearCumulative.add(YwfxService.getMonthData(monthEntities, (YearMonth)yearMonth, (String)type));
        }
        if (previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0) {
            previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        } else {
            System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
        }
        YwfxDataHTB ywfxDataHTB = new YwfxDataHTB();
        ywfxDataHTB.setDataType(type);
        ywfxDataHTB.setCurrentTime(currentTime);
        ywfxDataHTB.setCurrentmonthData(currentMonthData.setScale(2, 4));
        ywfxDataHTB.setCurrentmonthDataHB(mom.setScale(2, 4));
        ywfxDataHTB.setCurrentmonthDataTB(yoy.setScale(2, 4));
        ywfxDataHTB.setCurrentYearData(currentYearCumulative.setScale(2, 4));
        ywfxDataHTB.setCurrentYearDataTB(previousYearyoy.setScale(2, 4));
        return ywfxDataHTB;
    }

    public static List<YwfxDataHTB> calculateYoYAndMoM_CP(List<YwfxCostEntity> monthEntities, String type) {
        Map<String, Map<YearMonth, YwfxCostEntity>> productMonthlySales = monthEntities.stream().collect(Collectors.groupingBy(YwfxCostEntity::getCostCp, Collectors.toMap(YwfxCostEntity::getCostTime, entity -> entity)));
        ArrayList<YwfxDataHTB> ywfxDataHTBList = new ArrayList<YwfxDataHTB>();
        for (Map.Entry<String, Map<YearMonth, YwfxCostEntity>> productEntry : productMonthlySales.entrySet()) {
            YwfxDataHTB ywfxDataHTB;
            YwfxCostEntity currentData;
            BigDecimal previousYearyoy;
            BigDecimal previousYearCumulative;
            BigDecimal currentYearCumulative;
            Integer CurrentYear;
            BigDecimal yoy;
            BigDecimal mom;
            String product = productEntry.getKey();
            Map<YearMonth, YwfxCostEntity> monthlySales = productEntry.getValue();
            ArrayList<YearMonth> months = new ArrayList<YearMonth>(monthlySales.keySet());
            Collections.sort(months);
            YearMonth currentTime = (YearMonth)months.get(months.size() - 1);
            YearMonth previousMonthTime = currentTime.minusMonths(1L);
            YearMonth previousQuarterTime = currentTime.minusMonths(4L);
            YearMonth previousYearTime = currentTime.minusYears(1L);
            BigDecimal currentMonthData = new BigDecimal(0);
            BigDecimal previousMonthData = new BigDecimal(0);
            BigDecimal previousYearData = new BigDecimal(0);
            if (type.equals("\u6750\u6599\u6210\u672c")) {
                if (monthlySales.containsKey(currentTime)) {
                    currentMonthData = monthlySales.get(currentTime).getCostCl();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousMonthTime)) {
                    previousMonthData = monthlySales.get(previousMonthTime).getCostCl();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousYearTime)) {
                    previousYearData = monthlySales.get(previousYearTime).getCostCl();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                mom = new BigDecimal(0);
                yoy = new BigDecimal(0);
                if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
                }
                if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
                }
                CurrentYear = currentTime.getYear();
                currentYearCumulative = BigDecimal.ZERO;
                previousYearCumulative = BigDecimal.ZERO;
                previousYearyoy = BigDecimal.ZERO;
                for (YearMonth yearMonth : months) {
                    currentData = monthlySales.get(yearMonth);
                    if (yearMonth.getYear() == currentTime.getYear()) {
                        currentYearCumulative = currentYearCumulative.add(currentData.getCostCl());
                        continue;
                    }
                    if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                    previousYearCumulative = previousYearCumulative.add(currentData.getCostCl());
                }
                if (previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                ywfxDataHTB = new YwfxDataHTB();
                ywfxDataHTB.setDataName(product);
                ywfxDataHTB.setDataType(type);
                ywfxDataHTB.setCurrentTime(currentTime);
                ywfxDataHTB.setCurrentmonthData(currentMonthData);
                ywfxDataHTB.setCurrentmonthDataHB(mom);
                ywfxDataHTB.setCurrentmonthDataTB(yoy);
                ywfxDataHTB.setCurrentYearData(currentYearCumulative);
                ywfxDataHTB.setCurrentYearDataTB(previousYearyoy);
                ywfxDataHTBList.add(ywfxDataHTB);
                continue;
            }
            if (type.equals("\u4eba\u5de5\u6210\u672c")) {
                if (monthlySales.containsKey(currentTime)) {
                    currentMonthData = monthlySales.get(currentTime).getCostRg();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousMonthTime)) {
                    previousMonthData = monthlySales.get(previousMonthTime).getCostRg();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                if (monthlySales.containsKey(previousYearTime)) {
                    previousYearData = monthlySales.get(previousYearTime).getCostRg();
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                mom = new BigDecimal(0);
                yoy = new BigDecimal(0);
                if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
                }
                if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
                }
                CurrentYear = currentTime.getYear();
                currentYearCumulative = BigDecimal.ZERO;
                previousYearCumulative = BigDecimal.ZERO;
                previousYearyoy = BigDecimal.ZERO;
                for (YearMonth yearMonth : months) {
                    currentData = monthlySales.get(yearMonth);
                    if (yearMonth.getYear() == currentTime.getYear()) {
                        currentYearCumulative = currentYearCumulative.add(currentData.getCostRg());
                        continue;
                    }
                    if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                    previousYearCumulative = previousYearCumulative.add(currentData.getCostRg());
                }
                if (previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0) {
                    previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                } else {
                    System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
                }
                ywfxDataHTB = new YwfxDataHTB();
                ywfxDataHTB.setDataName(product);
                ywfxDataHTB.setDataType(type);
                ywfxDataHTB.setCurrentTime(currentTime);
                ywfxDataHTB.setCurrentmonthData(currentMonthData);
                ywfxDataHTB.setCurrentmonthDataHB(mom);
                ywfxDataHTB.setCurrentmonthDataTB(yoy);
                ywfxDataHTB.setCurrentYearData(currentYearCumulative);
                ywfxDataHTB.setCurrentYearDataTB(previousYearyoy);
                ywfxDataHTBList.add(ywfxDataHTB);
                continue;
            }
            if (!type.equals("\u5236\u9020\u8d39\u7528")) continue;
            if (monthlySales.containsKey(currentTime)) {
                currentMonthData = monthlySales.get(currentTime).getCostFy();
            } else {
                System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
            }
            if (monthlySales.containsKey(previousMonthTime)) {
                previousMonthData = monthlySales.get(previousMonthTime).getCostFy();
            } else {
                System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
            }
            if (monthlySales.containsKey(previousYearTime)) {
                previousYearData = monthlySales.get(previousYearTime).getCostFy();
            } else {
                System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
            }
            mom = new BigDecimal(0);
            yoy = new BigDecimal(0);
            if (previousMonthData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                mom = currentMonthData.subtract(previousMonthData).divide(previousMonthData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            } else {
                System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u73af\u6bd4");
            }
            if (previousYearData.compareTo(BigDecimal.valueOf(0L)) != 0) {
                yoy = currentMonthData.subtract(previousYearData).divide(previousYearData, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            } else {
                System.out.println("\u4e0a\u4e2a\u6708/\u5b63\u5ea6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4");
            }
            CurrentYear = currentTime.getYear();
            currentYearCumulative = BigDecimal.ZERO;
            previousYearCumulative = BigDecimal.ZERO;
            previousYearyoy = BigDecimal.ZERO;
            for (YearMonth yearMonth : months) {
                currentData = monthlySales.get(yearMonth);
                if (yearMonth.getYear() == currentTime.getYear()) {
                    currentYearCumulative = currentYearCumulative.add(currentData.getCostFy());
                    continue;
                }
                if (yearMonth.getYear() != currentTime.getYear() - 1 || yearMonth.getMonthValue() > currentTime.getMonthValue()) continue;
                previousYearCumulative = previousYearCumulative.add(currentData.getCostFy());
            }
            if (previousYearCumulative.compareTo(BigDecimal.valueOf(0L)) != 0) {
                previousYearyoy = currentYearCumulative.subtract(previousYearCumulative).divide(previousYearCumulative, 4, 4).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
            } else {
                System.out.println("\u65e0\u6cd5\u8ba1\u7b97");
            }
            ywfxDataHTB = new YwfxDataHTB();
            ywfxDataHTB.setDataName(product);
            ywfxDataHTB.setDataType(type);
            ywfxDataHTB.setCurrentTime(currentTime);
            ywfxDataHTB.setCurrentmonthData(currentMonthData);
            ywfxDataHTB.setCurrentmonthDataHB(mom);
            ywfxDataHTB.setCurrentmonthDataTB(yoy);
            ywfxDataHTB.setCurrentYearData(currentYearCumulative);
            ywfxDataHTB.setCurrentYearDataTB(previousYearyoy);
            ywfxDataHTBList.add(ywfxDataHTB);
        }
        return ywfxDataHTBList;
    }

    public static BigDecimal getMonthData(List<YwfxCostEntity> monthEntities, YearMonth monthTime, String Type2) {
        BigDecimal returnedValue = new BigDecimal(0);
        if (Type2.equals("\u6750\u6599\u6210\u672c")) {
            returnedValue = monthEntities.stream().filter(e -> e.getCostTime().equals(monthTime)).map(YwfxCostEntity::getCostCl).findFirst().orElse(BigDecimal.valueOf(-1L));
        } else if (Type2.equals("\u4eba\u5de5\u6210\u672c")) {
            returnedValue = monthEntities.stream().filter(e -> e.getCostTime().equals(monthTime)).map(YwfxCostEntity::getCostRg).findFirst().orElse(BigDecimal.valueOf(-1L));
        } else if (Type2.equals("\u5236\u9020\u8d39\u7528")) {
            returnedValue = monthEntities.stream().filter(e -> e.getCostTime().equals(monthTime)).map(YwfxCostEntity::getCostFy).findFirst().orElse(BigDecimal.valueOf(-1L));
        }
        return returnedValue;
    }

    private Map<String, List<YwfxDataHTB>> adjustList(List<YwfxDataHTB> allList) {
        return allList.stream().collect(Collectors.groupingBy(YwfxDataHTB::getDataName, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(YwfxDataHTB::getCurrentmonthData).reversed()).collect(Collectors.toList()))));
    }

    public static BigDecimal getMonthDataAssist1(List<MonthEntity> monthEntities, YearMonth monthTime) {
        return monthEntities.stream().filter(e -> e.getDataMonth().equals(monthTime)).map(MonthEntity::getDataAssist1).findFirst().orElse(BigDecimal.valueOf(-1L));
    }

    public static BigDecimal getMonthDataAssist2(List<MonthEntity> monthEntities, YearMonth monthTime) {
        return monthEntities.stream().filter(e -> e.getDataMonth().equals(monthTime)).map(MonthEntity::getDataAssist2).findFirst().orElse(BigDecimal.valueOf(-1L));
    }

    public static BigDecimal getQuarterData(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getQuarterAssist1(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataAssist1).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getQuarterAssist2(List<MonthEntity> monthEntities, YearMonth monthTime) {
        int year = monthTime.getYear();
        int quarter = (monthTime.getMonthValue() - 1) / 3 + 1;
        return monthEntities.stream().filter(e -> {
            int entityYear = e.getDataMonth().getYear();
            int entityQuarter = (e.getDataMonth().getMonthValue() - 1) / 3 + 1;
            return entityYear == year && entityQuarter == quarter;
        }).map(MonthEntity::getDataAssist2).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

