/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.business.datafrom.dao.SLXDao;
import net.lab1024.sa.admin.module.business.datafrom.dao.SingleRowDataDao;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.SLXEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.entity.SingleRowDataEntity;
import net.lab1024.sa.admin.module.business.datafrom.domain.form.NewCwbbQueryForm;
import net.lab1024.sa.admin.module.business.datafrom.domain.vo.NewCwbbVO;
import net.lab1024.sa.admin.module.business.datafrom.service.NewCwbbService;
import net.lab1024.sa.admin.module.business.datafrom.service.SingleRowDataService;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.IndustryDao;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.MonthDataDao;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.PfbSheetDao;
import net.lab1024.sa.admin.module.business.xmfmodel.dao.ZhpfSurveyDao;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.entity.PfbSheetEntity;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.CwbbTime;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ZhpfSurveyService {
    private static final Logger log = LoggerFactory.getLogger(ZhpfSurveyService.class);
    @Resource
    private ZhpfSurveyDao zhpfSurveyDao;
    @Resource
    private SingleRowDataDao singleRowDataDao;
    @Resource
    private SingleRowDataService singleRowDataService;
    @Resource
    private NewCwbbService newCwbbService;
    @Resource
    private SLXDao slxdao;
    @Resource
    private IndustryDao industryDao;
    @Resource
    private PfbSheetDao pfbSheetDao;
    @Resource
    private MonthDataDao monthDataDao;

    public ResponseDTO<BigDecimal> getSrmbwcl(String employeeID) {
        BigDecimal mb;
        BigDecimal takingValue = this.queryValueByCwbbYysr(employeeID);
        try {
            List srdEntity = this.singleRowDataDao.queryByOne(Long.parseLong(employeeID), "\u6536\u5165\u76ee\u6807");
            mb = ((SingleRowDataEntity)srdEntity.get(0)).getSrdValue();
        }
        catch (Exception e) {
            this.singleRowDataService.createSrdSrmb(Long.valueOf(employeeID));
            List srdEntity = this.singleRowDataDao.queryByOne(Long.parseLong(employeeID), "\u6536\u5165\u76ee\u6807");
            mb = ((SingleRowDataEntity)srdEntity.get(0)).getSrdValue();
        }
        BigDecimal takingValueMb = takingValue.divide(mb, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        return ResponseDTO.ok((Object)takingValueMb);
    }

    public ResponseDTO<BigDecimal> getLrmbwcl(String employeeID) {
        BigDecimal mb;
        BigDecimal takingValue = this.queryValueByCwbbJlr(employeeID);
        try {
            List srdEntity = this.singleRowDataDao.queryByOne(Long.parseLong(employeeID), "\u5229\u6da6\u76ee\u6807");
            mb = ((SingleRowDataEntity)srdEntity.get(0)).getSrdValue();
        }
        catch (Exception e) {
            this.singleRowDataService.createSrdLrmb(Long.valueOf(employeeID));
            List srdEntity = this.singleRowDataDao.queryByOne(Long.parseLong(employeeID), "\u5229\u6da6\u76ee\u6807");
            mb = ((SingleRowDataEntity)srdEntity.get(0)).getSrdValue();
        }
        BigDecimal takingValueMb = takingValue.divide(mb, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        return ResponseDTO.ok((Object)takingValueMb);
    }

    public ResponseDTO<List<SLXEntity>> getSLXData(String userId) {
        List slxEntityList = this.slxdao.query(Long.valueOf(Long.parseLong(userId)));
        return ResponseDTO.ok((Object)slxEntityList);
    }

    public ResponseDTO<Map<Integer, List<BigDecimal>>> getPFBData(Map<String, String> params) {
        String userId = params.get("employeeID");
        ArrayList Jdnew = new ArrayList();
        ArrayList Jdold = new ArrayList();
        HashMap listMap = new HashMap();
        List pfbSheetEntityList = this.pfbSheetDao.queryById(Long.parseLong(userId));
        this.getJdDF(pfbSheetEntityList, Jdnew, Jdold, listMap);
        return ResponseDTO.ok(listMap);
    }

    public ResponseDTO<List<PfbSheetEntity>> queryPfbSheet(long l) {
        return ResponseDTO.ok((Object)this.pfbSheetDao.queryById(l));
    }

    public Map<Integer, List<BigDecimal>> getJdDF(List<PfbSheetEntity> pfbSheetEntityList, List<BigDecimal> Jdnew, List<BigDecimal> Jdold, Map<Integer, List<BigDecimal>> listMap) {
        int time = pfbSheetEntityList.get(0).getPfbTime();
        BigDecimal czx2024 = BigDecimal.valueOf(0L);
        BigDecimal ylx2024 = BigDecimal.valueOf(0L);
        BigDecimal ldx2024 = BigDecimal.valueOf(0L);
        BigDecimal czx2023 = BigDecimal.valueOf(0L);
        BigDecimal ylx2023 = BigDecimal.valueOf(0L);
        BigDecimal ldx2023 = BigDecimal.valueOf(0L);
        for (PfbSheetEntity pfbSheetEntity : pfbSheetEntityList) {
            if (time == pfbSheetEntity.getPfbTime()) {
                if (pfbSheetEntity.getPfbJd().equals("\u6210\u957f\u6027")) {
                    czx2024 = czx2024.add(pfbSheetEntity.getPfbZzdf());
                    continue;
                }
                if (pfbSheetEntity.getPfbJd().equals("\u76c8\u5229\u6027")) {
                    ylx2024 = ylx2024.add(pfbSheetEntity.getPfbZzdf());
                    continue;
                }
                if (!pfbSheetEntity.getPfbJd().equals("\u6d41\u52a8\u6027")) continue;
                ldx2024 = ldx2024.add(pfbSheetEntity.getPfbZzdf());
                continue;
            }
            if (pfbSheetEntity.getPfbJd().equals("\u6210\u957f\u6027")) {
                czx2023 = czx2023.add(pfbSheetEntity.getPfbZzdf());
                continue;
            }
            if (pfbSheetEntity.getPfbJd().equals("\u76c8\u5229\u6027")) {
                ylx2023 = ylx2023.add(pfbSheetEntity.getPfbZzdf());
                continue;
            }
            if (!pfbSheetEntity.getPfbJd().equals("\u6d41\u52a8\u6027")) continue;
            ldx2023 = ldx2023.add(pfbSheetEntity.getPfbZzdf());
        }
        Jdnew.add(czx2024);
        Jdnew.add(ylx2024);
        Jdnew.add(ldx2024);
        Jdold.add(czx2023);
        Jdold.add(ylx2023);
        Jdold.add(ldx2023);
        listMap.put(time, Jdnew);
        listMap.put(time - 1, Jdold);
        return listMap;
    }

    public BigDecimal queryValueByCwbbYysr(String userid) {
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userid));
        Optional<LocalDateTime> maxTime = cwbbTimeList.stream().map(CwbbTime::getNcwbbTime).max(LocalDateTime::compareTo);
        NewCwbbQueryForm newCwbbQueryForm = new NewCwbbQueryForm();
        newCwbbQueryForm.setUserId(Long.valueOf(userid));
        newCwbbQueryForm.setNcwbbTime(String.valueOf(maxTime.get().getYear()));
        newCwbbQueryForm.setPageNum(Long.valueOf(1L));
        newCwbbQueryForm.setPageSize(Long.valueOf(100L));
        List pageResult = ((PageResult)this.newCwbbService.query(newCwbbQueryForm).getData()).getList();
        BigDecimal currentYysr = new BigDecimal(0);
        for (NewCwbbVO newCwbb : pageResult) {
            if (newCwbb.getNcwbbYysr() == null) continue;
            currentYysr = currentYysr.add(newCwbb.getNcwbbYysr());
        }
        return currentYysr;
    }

    public BigDecimal queryValueByCwbbJlr(String userid) {
        List cwbbTimeList = this.monthDataDao.queryCwbbTimeById(Long.parseLong(userid));
        Optional<LocalDateTime> maxTime = cwbbTimeList.stream().map(CwbbTime::getNcwbbTime).max(LocalDateTime::compareTo);
        NewCwbbQueryForm newCwbbQueryForm = new NewCwbbQueryForm();
        newCwbbQueryForm.setUserId(Long.valueOf(userid));
        newCwbbQueryForm.setNcwbbTime(String.valueOf(maxTime.get().getYear()));
        newCwbbQueryForm.setPageNum(Long.valueOf(1L));
        newCwbbQueryForm.setPageSize(Long.valueOf(100L));
        List pageResult = ((PageResult)this.newCwbbService.query(newCwbbQueryForm).getData()).getList();
        BigDecimal currentJlr = new BigDecimal(0);
        for (NewCwbbVO newCwbb : pageResult) {
            if (newCwbb.getNcwbbJlr() == null) continue;
            currentJlr = currentJlr.add(newCwbb.getNcwbbJlr());
        }
        return currentJlr;
    }

    public ResponseDTO<List<PfbSheetEntity>> getDrillData(Map<String, String> params) {
        Long userId = Long.valueOf(params.get("userId"));
        String yearValue = params.get("YearValue");
        List pfbSheetEntityList = this.pfbSheetDao.queryByIdandYear(userId.longValue(), yearValue);
        System.out.println(pfbSheetEntityList);
        return ResponseDTO.ok((Object)pfbSheetEntityList);
    }
}

