/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.business.xmfmodel.utils;

import java.time.LocalDateTime;
import java.time.temporal.IsoFields;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lab1024.sa.admin.module.business.xmfmodel.domain.vo.CwbbTime;
import net.lab1024.sa.admin.module.business.xmfmodel.utils.ReportTypeService;

public class ReportTypeService {
    public static ReportType determineReportType(List<CwbbTime> cwbbTimeList) {
        boolean bl;
        if (cwbbTimeList == null || cwbbTimeList.isEmpty()) {
            return ReportType.UNKNOWN;
        }
        HashMap<Integer, Integer> yearCountMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Map> quarterCountMap = new HashMap<Integer, Map>();
        HashMap<Integer, Map> monthCountMap = new HashMap<Integer, Map>();
        for (CwbbTime cwbbTime : cwbbTimeList) {
            LocalDateTime dateTime = cwbbTime.getNcwbbTime();
            int year = dateTime.getYear();
            int quarter = dateTime.get(IsoFields.QUARTER_OF_YEAR);
            int month = dateTime.getMonthValue();
            yearCountMap.put(year, yearCountMap.getOrDefault(year, 0) + 1);
            quarterCountMap.computeIfAbsent(year, k -> new HashMap());
            ((Map)quarterCountMap.get(year)).put(quarter, ((Map)quarterCountMap.get(year)).getOrDefault(quarter, 0) + 1);
            monthCountMap.computeIfAbsent(year, k -> new HashMap());
            ((Map)monthCountMap.get(year)).put(month, ((Map)monthCountMap.get(year)).getOrDefault(month, 0) + 1);
        }
        boolean isYearly = true;
        Iterator iterator = yearCountMap.values().iterator();
        while (iterator.hasNext()) {
            int count2 = (Integer)iterator.next();
            if (count2 == 1) continue;
            isYearly = false;
            break;
        }
        if (isYearly) {
            return ReportType.YEARLY;
        }
        boolean bl2 = true;
        for (Map quarterMap : quarterCountMap.values()) {
            if (quarterMap.size() != 0 && !quarterMap.values().stream().anyMatch(count -> count > 1)) continue;
            bl = false;
            break;
        }
        if (bl && quarterCountMap.values().stream().anyMatch(map -> !map.isEmpty())) {
            return ReportType.QUARTERLY;
        }
        boolean isMonthly = true;
        for (Map monthMap : monthCountMap.values()) {
            if (monthMap.size() != 0 && !monthMap.values().stream().anyMatch(count -> count > 1)) continue;
            isMonthly = false;
            break;
        }
        if (isMonthly && monthCountMap.values().stream().anyMatch(map -> !map.isEmpty())) {
            return ReportType.MONTHLY;
        }
        return ReportType.UNKNOWN;
    }
}

