/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.datascope.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeViewTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.domain.DataScopeAndViewTypeVO;
import net.lab1024.sa.admin.module.system.datascope.domain.DataScopeDTO;
import net.lab1024.sa.admin.module.system.datascope.domain.DataScopeViewTypeVO;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.springframework.stereotype.Service;

@Service
public class DataScopeService {
    public ResponseDTO<List<DataScopeAndViewTypeVO>> dataScopeList() {
        List dataScopeList = this.getDataScopeType();
        List dataScopeAndTypeList = SmartBeanUtil.copyList((List)dataScopeList, DataScopeAndViewTypeVO.class);
        List typeList = this.getViewType();
        dataScopeAndTypeList.forEach(e -> e.setViewTypeList(typeList));
        return ResponseDTO.ok((Object)dataScopeAndTypeList);
    }

    public List<DataScopeViewTypeVO> getViewType() {
        DataScopeViewTypeEnum[] enums;
        ArrayList viewTypeList = Lists.newArrayList();
        for (DataScopeViewTypeEnum viewTypeEnum : enums = (DataScopeViewTypeEnum[])DataScopeViewTypeEnum.class.getEnumConstants()) {
            DataScopeViewTypeVO dataScopeViewTypeDTO = DataScopeViewTypeVO.builder().viewType(viewTypeEnum.getValue()).viewTypeLevel(viewTypeEnum.getLevel()).viewTypeName(viewTypeEnum.getDesc()).build();
            viewTypeList.add(dataScopeViewTypeDTO);
        }
        Comparator comparator = (h1, h2) -> h1.getViewTypeLevel().compareTo(h2.getViewTypeLevel());
        viewTypeList.sort(comparator);
        return viewTypeList;
    }

    public List<DataScopeDTO> getDataScopeType() {
        DataScopeTypeEnum[] enums;
        ArrayList dataScopeTypeList = Lists.newArrayList();
        for (DataScopeTypeEnum typeEnum : enums = (DataScopeTypeEnum[])DataScopeTypeEnum.class.getEnumConstants()) {
            DataScopeDTO dataScopeDTO = DataScopeDTO.builder().dataScopeType(typeEnum.getValue()).dataScopeTypeDesc(typeEnum.getDesc()).dataScopeTypeName(typeEnum.getName()).dataScopeTypeSort(typeEnum.getSort()).build();
            dataScopeTypeList.add(dataScopeDTO);
        }
        Comparator comparator = (h1, h2) -> h1.getDataScopeTypeSort().compareTo(h2.getDataScopeTypeSort());
        dataScopeTypeList.sort(comparator);
        return dataScopeTypeList;
    }
}

