/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.datascope.service;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.datascope.DataScope;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeViewTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeWhereInTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.domain.DataScopeSqlConfig;
import net.lab1024.sa.admin.module.system.datascope.service.DataScopeViewService;
import net.lab1024.sa.admin.module.system.datascope.strategy.AbstractDataScopeStrategy;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DataScopeSqlConfigService {
    private static final Logger log = LoggerFactory.getLogger(DataScopeSqlConfigService.class);
    private static final String EMPLOYEE_PARAM = "#employeeIds";
    private static final String DEPARTMENT_PARAM = "#departmentIds";
    private final ConcurrentHashMap<String, DataScopeSqlConfig> dataScopeMethodMap = new ConcurrentHashMap();
    @Resource
    private DataScopeViewService dataScopeViewService;
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    private void initDataScopeMethodMap() {
        this.refreshDataScopeMethodMap();
    }

    private Map<String, DataScopeSqlConfig> refreshDataScopeMethodMap() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"net.lab1024.sa", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new MethodAnnotationsScanner()}));
        Set methods = reflections.getMethodsAnnotatedWith(DataScope.class);
        for (Method method : methods) {
            DataScope dataScopeAnnotation = method.getAnnotation(DataScope.class);
            if (dataScopeAnnotation == null) continue;
            DataScopeSqlConfig configDTO = new DataScopeSqlConfig();
            configDTO.setDataScopeType(dataScopeAnnotation.dataScopeType());
            configDTO.setJoinSql(dataScopeAnnotation.joinSql());
            configDTO.setWhereIndex(Integer.valueOf(dataScopeAnnotation.whereIndex()));
            configDTO.setDataScopeWhereInType(dataScopeAnnotation.whereInType());
            configDTO.setParamName(dataScopeAnnotation.paramName());
            configDTO.setJoinSqlImplClazz(dataScopeAnnotation.joinSqlImplClazz());
            this.dataScopeMethodMap.put(method.getDeclaringClass().getSimpleName() + "." + method.getName(), configDTO);
        }
        return this.dataScopeMethodMap;
    }

    public DataScopeSqlConfig getSqlConfig(String method) {
        return (DataScopeSqlConfig)this.dataScopeMethodMap.get(method);
    }

    public String getJoinSql(Map<String, Object> paramMap, DataScopeSqlConfig sqlConfigDTO) {
        DataScopeTypeEnum dataScopeTypeEnum = sqlConfigDTO.getDataScopeType();
        String joinSql = sqlConfigDTO.getJoinSql();
        Long employeeId = SmartRequestUtil.getRequestUserId();
        if (employeeId == null) {
            return "";
        }
        if (DataScopeWhereInTypeEnum.CUSTOM_STRATEGY == sqlConfigDTO.getDataScopeWhereInType()) {
            Class strategyClass = sqlConfigDTO.getJoinSqlImplClazz();
            if (strategyClass == null) {
                log.warn("data scope custom strategy class is null");
                return "";
            }
            AbstractDataScopeStrategy powerStrategy = (AbstractDataScopeStrategy)this.applicationContext.getBean(sqlConfigDTO.getJoinSqlImplClazz());
            if (powerStrategy == null) {
                log.warn("data scope custom strategy class\uff1a{} ,bean is null", (Object)sqlConfigDTO.getJoinSqlImplClazz());
                return "";
            }
            DataScopeViewTypeEnum viewTypeEnum = this.dataScopeViewService.getEmployeeDataScopeViewType(dataScopeTypeEnum, employeeId);
            return powerStrategy.getCondition(viewTypeEnum, paramMap, sqlConfigDTO);
        }
        if (DataScopeWhereInTypeEnum.EMPLOYEE == sqlConfigDTO.getDataScopeWhereInType()) {
            List canViewEmployeeIds = this.dataScopeViewService.getCanViewEmployeeId(dataScopeTypeEnum, employeeId);
            if (CollectionUtils.isEmpty((Collection)canViewEmployeeIds)) {
                return "";
            }
            String employeeIds = StringUtils.join((Iterable)canViewEmployeeIds, (String)",");
            String sql = joinSql.replaceAll(EMPLOYEE_PARAM, employeeIds);
            return sql;
        }
        if (DataScopeWhereInTypeEnum.DEPARTMENT == sqlConfigDTO.getDataScopeWhereInType()) {
            List canViewDepartmentIds = this.dataScopeViewService.getCanViewDepartmentId(dataScopeTypeEnum, employeeId);
            if (CollectionUtils.isEmpty((Collection)canViewDepartmentIds)) {
                return "";
            }
            String departmentIds = StringUtils.join((Iterable)canViewDepartmentIds, (String)",");
            String sql = joinSql.replaceAll(DEPARTMENT_PARAM, departmentIds);
            return sql;
        }
        return "";
    }
}

