/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.datascope.service;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeTypeEnum;
import net.lab1024.sa.admin.module.system.datascope.constant.DataScopeViewTypeEnum;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.admin.module.system.employee.dao.EmployeeDao;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.admin.module.system.role.dao.RoleDataScopeDao;
import net.lab1024.sa.admin.module.system.role.dao.RoleEmployeeDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleDataScopeEntity;
import net.lab1024.sa.base.common.util.SmartEnumUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DataScopeViewService {
    @Resource
    private RoleEmployeeDao roleEmployeeDao;
    @Resource
    private RoleDataScopeDao roleDataScopeDao;
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private DepartmentService departmentService;

    public List<Long> getCanViewEmployeeId(DataScopeTypeEnum dataScopeTypeEnum, Long employeeId) {
        DataScopeViewTypeEnum viewType = this.getEmployeeDataScopeViewType(dataScopeTypeEnum, employeeId);
        if (DataScopeViewTypeEnum.ME == viewType) {
            return this.getMeEmployeeIdList(employeeId);
        }
        if (DataScopeViewTypeEnum.DEPARTMENT == viewType) {
            return this.getDepartmentEmployeeIdList(employeeId);
        }
        if (DataScopeViewTypeEnum.DEPARTMENT_AND_SUB == viewType) {
            return this.getDepartmentAndSubEmployeeIdList(employeeId);
        }
        return Lists.newArrayList();
    }

    public List<Long> getCanViewDepartmentId(DataScopeTypeEnum dataScopeTypeEnum, Long employeeId) {
        DataScopeViewTypeEnum viewType = this.getEmployeeDataScopeViewType(dataScopeTypeEnum, employeeId);
        if (DataScopeViewTypeEnum.ME == viewType) {
            return this.getMeDepartmentIdList(employeeId);
        }
        if (DataScopeViewTypeEnum.DEPARTMENT == viewType) {
            return this.getMeDepartmentIdList(employeeId);
        }
        if (DataScopeViewTypeEnum.DEPARTMENT_AND_SUB == viewType) {
            return this.getDepartmentAndSubIdList(employeeId);
        }
        return Lists.newArrayList();
    }

    public List<Long> getMeDepartmentIdList(Long employeeId) {
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        return Lists.newArrayList((Object[])new Long[]{employeeEntity.getDepartmentId()});
    }

    public List<Long> getDepartmentAndSubIdList(Long employeeId) {
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        return this.departmentService.selfAndChildrenIdList(employeeEntity.getDepartmentId());
    }

    public DataScopeViewTypeEnum getEmployeeDataScopeViewType(DataScopeTypeEnum dataScopeTypeEnum, Long employeeId) {
        if (employeeId == null) {
            return DataScopeViewTypeEnum.ME;
        }
        List roleIdList = this.roleEmployeeDao.selectRoleIdByEmployeeId(employeeId);
        if (CollectionUtils.isEmpty((Collection)roleIdList)) {
            return DataScopeViewTypeEnum.ME;
        }
        List dataScopeRoleList = this.roleDataScopeDao.listByRoleIdList(roleIdList);
        if (CollectionUtils.isEmpty((Collection)dataScopeRoleList)) {
            return DataScopeViewTypeEnum.ME;
        }
        Map<Integer, List<RoleDataScopeEntity>> listMap = dataScopeRoleList.stream().collect(Collectors.groupingBy(RoleDataScopeEntity::getDataScopeType));
        List<RoleDataScopeEntity> viewLevelList = listMap.getOrDefault(dataScopeTypeEnum.getValue(), Lists.newArrayList());
        if (CollectionUtils.isEmpty(viewLevelList)) {
            return DataScopeViewTypeEnum.ME;
        }
        RoleDataScopeEntity maxLevel = viewLevelList.stream().max(Comparator.comparing(e -> ((DataScopeViewTypeEnum)SmartEnumUtil.getEnumByValue((Object)e.getViewType(), DataScopeViewTypeEnum.class)).getLevel())).get();
        return (DataScopeViewTypeEnum)SmartEnumUtil.getEnumByValue((Object)maxLevel.getViewType(), DataScopeViewTypeEnum.class);
    }

    private List<Long> getMeEmployeeIdList(Long employeeId) {
        return Lists.newArrayList((Object[])new Long[]{employeeId});
    }

    private List<Long> getDepartmentEmployeeIdList(Long employeeId) {
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        return this.employeeDao.getEmployeeIdByDepartmentId(employeeEntity.getDepartmentId(), Boolean.valueOf(false));
    }

    private List<Long> getDepartmentAndSubEmployeeIdList(Long employeeId) {
        List allDepartmentIds = this.getDepartmentAndSubIdList(employeeId);
        return this.employeeDao.getEmployeeIdByDepartmentIdList(allDepartmentIds, Boolean.valueOf(false));
    }
}

