/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.department.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.department.domain.form.DepartmentAddForm;
import net.lab1024.sa.admin.module.system.department.domain.form.DepartmentUpdateForm;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentTreeVO;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u90e8\u95e8\u7ba1\u7406")
public class DepartmentController {
    @Resource
    private DepartmentService departmentService;

    @Operation(summary="\u67e5\u8be2\u90e8\u95e8\u6811\u5f62\u5217\u8868 @author \u5353\u5927")
    @GetMapping(value={"/department/treeList"})
    public ResponseDTO<List<DepartmentTreeVO>> departmentTree() {
        return this.departmentService.departmentTree();
    }

    @Operation(summary="\u6dfb\u52a0\u90e8\u95e8 @author \u5353\u5927")
    @PostMapping(value={"/department/add"})
    @SaCheckPermission(value={"system:department:add"})
    public ResponseDTO<String> addDepartment(@Valid @RequestBody DepartmentAddForm createDTO) {
        return this.departmentService.addDepartment(createDTO);
    }

    @Operation(summary="\u66f4\u65b0\u90e8\u95e8 @author \u5353\u5927")
    @PostMapping(value={"/department/update"})
    @SaCheckPermission(value={"system:department:update"})
    public ResponseDTO<String> updateDepartment(@Valid @RequestBody DepartmentUpdateForm updateDTO) {
        return this.departmentService.updateDepartment(updateDTO);
    }

    @Operation(summary="\u5220\u9664\u90e8\u95e8 @author \u5353\u5927")
    @GetMapping(value={"/department/delete/{departmentId}"})
    @SaCheckPermission(value={"system:department:delete"})
    public ResponseDTO<String> deleteDepartment(@PathVariable Long departmentId) {
        return this.departmentService.deleteDepartment(departmentId);
    }

    @Operation(summary="\u67e5\u8be2\u90e8\u95e8\u5217\u8868 @author \u5353\u5927")
    @GetMapping(value={"/department/listAll"})
    public ResponseDTO<List<DepartmentVO>> listAll() {
        return ResponseDTO.ok((Object)this.departmentService.listAll());
    }
}

