/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.department.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.department.dao.DepartmentDao;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentTreeVO;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DepartmentCacheManager {
    private static final Logger log = LoggerFactory.getLogger(DepartmentCacheManager.class);
    @Resource
    private DepartmentDao departmentDao;

    private void logClearInfo(String cache) {
        log.info("clear " + cache);
    }

    @CacheEvict(value={"department_list_cache", "department_map_cache", "department_self_children_cache", "department_tree_cache", "department_path_cache"}, allEntries=true)
    public void clearCache() {
        this.logClearInfo("department_list_cache");
    }

    @Cacheable(value={"department_list_cache"})
    public List<DepartmentVO> getDepartmentList() {
        return this.departmentDao.listAll();
    }

    @Cacheable(value={"department_map_cache"})
    public Map<Long, DepartmentVO> getDepartmentMap() {
        return this.departmentDao.listAll().stream().collect(Collectors.toMap(DepartmentVO::getDepartmentId, Function.identity()));
    }

    @Cacheable(value={"department_tree_cache"})
    public List<DepartmentTreeVO> getDepartmentTree() {
        List departmentVOList = this.departmentDao.listAll();
        return this.buildTree(departmentVOList);
    }

    @Cacheable(value={"department_self_children_cache"})
    public List<Long> getDepartmentSelfAndChildren(Long departmentId) {
        List departmentVOList = this.departmentDao.listAll();
        return this.selfAndChildrenIdList(departmentId, departmentVOList);
    }

    @Cacheable(value={"department_path_cache"})
    public Map<Long, String> getDepartmentPathMap() {
        List departmentVOList = this.departmentDao.listAll();
        Map departmentMap = departmentVOList.stream().collect(Collectors.toMap(DepartmentVO::getDepartmentId, Function.identity()));
        HashMap pathNameMap = Maps.newHashMap();
        for (DepartmentVO departmentVO : departmentVOList) {
            String pathName = this.buildDepartmentPath(departmentVO, departmentMap);
            pathNameMap.put(departmentVO.getDepartmentId(), pathName);
        }
        return pathNameMap;
    }

    private String buildDepartmentPath(DepartmentVO departmentVO, Map<Long, DepartmentVO> departmentMap) {
        if (Objects.equals(departmentVO.getParentId(), NumberUtils.LONG_ZERO)) {
            return departmentVO.getName();
        }
        DepartmentVO parentDepartment = departmentMap.get(departmentVO.getParentId());
        if (parentDepartment == null) {
            return departmentVO.getName();
        }
        String pathName = this.buildDepartmentPath(parentDepartment, departmentMap);
        return pathName + "/" + departmentVO.getName();
    }

    public List<DepartmentTreeVO> buildTree(List<DepartmentVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return Lists.newArrayList();
        }
        List rootList = voList.stream().filter(e -> e.getParentId() == null || Objects.equals(e.getParentId(), NumberUtils.LONG_ZERO)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rootList)) {
            return Lists.newArrayList();
        }
        List treeVOList = SmartBeanUtil.copyList(rootList, DepartmentTreeVO.class);
        this.recursiveBuildTree(treeVOList, voList);
        return treeVOList;
    }

    private void recursiveBuildTree(List<DepartmentTreeVO> nodeList, List<DepartmentVO> allDepartmentList) {
        int nodeSize = nodeList.size();
        for (int i = 0; i < nodeSize; ++i) {
            int preIndex = i - 1;
            int nextIndex = i + 1;
            DepartmentTreeVO node = nodeList.get(i);
            if (preIndex > -1) {
                node.setPreId(nodeList.get(preIndex).getDepartmentId());
            }
            if (nextIndex < nodeSize) {
                node.setNextId(nodeList.get(nextIndex).getDepartmentId());
            }
            ArrayList selfAndAllChildrenIdList = Lists.newArrayList();
            selfAndAllChildrenIdList.add(node.getDepartmentId());
            node.setSelfAndAllChildrenIdList((List)selfAndAllChildrenIdList);
            List children = this.getChildren(node.getDepartmentId(), allDepartmentList);
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            node.setChildren(children);
            this.recursiveBuildTree(children, allDepartmentList);
        }
    }

    private List<DepartmentTreeVO> getChildren(Long departmentId, List<DepartmentVO> voList) {
        List childrenEntityList = voList.stream().filter(e -> departmentId.equals(e.getParentId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childrenEntityList)) {
            return Lists.newArrayList();
        }
        return SmartBeanUtil.copyList(childrenEntityList, DepartmentTreeVO.class);
    }

    public List<Long> selfAndChildrenIdList(Long departmentId, List<DepartmentVO> voList) {
        ArrayList selfAndChildrenIdList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(voList)) {
            return selfAndChildrenIdList;
        }
        selfAndChildrenIdList.add(departmentId);
        List children = this.getChildren(departmentId, voList);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return selfAndChildrenIdList;
        }
        List childrenIdList = children.stream().map(DepartmentVO::getDepartmentId).collect(Collectors.toList());
        selfAndChildrenIdList.addAll(childrenIdList);
        for (Long childId : childrenIdList) {
            this.selfAndChildrenRecursion((List)selfAndChildrenIdList, childId, voList);
        }
        return selfAndChildrenIdList;
    }

    public void selfAndChildrenRecursion(List<Long> selfAndChildrenIdList, Long departmentId, List<DepartmentVO> voList) {
        List children = this.getChildren(departmentId, voList);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        List childrenIdList = children.stream().map(DepartmentVO::getDepartmentId).collect(Collectors.toList());
        selfAndChildrenIdList.addAll(childrenIdList);
        for (Long childId : childrenIdList) {
            this.selfAndChildrenRecursion(selfAndChildrenIdList, childId, voList);
        }
    }
}

