/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.department.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.department.dao.DepartmentDao;
import net.lab1024.sa.admin.module.system.department.domain.entity.DepartmentEntity;
import net.lab1024.sa.admin.module.system.department.domain.form.DepartmentAddForm;
import net.lab1024.sa.admin.module.system.department.domain.form.DepartmentUpdateForm;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentTreeVO;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.admin.module.system.department.manager.DepartmentCacheManager;
import net.lab1024.sa.admin.module.system.employee.dao.EmployeeDao;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.springframework.stereotype.Service;

@Service
public class DepartmentService {
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private DepartmentCacheManager departmentCacheManager;

    public ResponseDTO<String> addDepartment(DepartmentAddForm departmentAddForm) {
        DepartmentEntity departmentEntity = (DepartmentEntity)SmartBeanUtil.copy((Object)departmentAddForm, DepartmentEntity.class);
        this.departmentDao.insert((Object)departmentEntity);
        this.clearCache();
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> updateDepartment(DepartmentUpdateForm updateDTO) {
        if (updateDTO.getParentId() == null) {
            return ResponseDTO.userErrorParam((String)"\u7236\u7ea7\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DepartmentEntity entity = (DepartmentEntity)this.departmentDao.selectById((Serializable)updateDTO.getDepartmentId());
        if (entity == null) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        DepartmentEntity departmentEntity = (DepartmentEntity)SmartBeanUtil.copy((Object)updateDTO, DepartmentEntity.class);
        departmentEntity.setSort(updateDTO.getSort());
        this.departmentDao.updateById((Object)departmentEntity);
        this.clearCache();
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> deleteDepartment(Long departmentId) {
        DepartmentEntity departmentEntity = (DepartmentEntity)this.departmentDao.selectById((Serializable)departmentId);
        if (null == departmentEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        int subDepartmentNum = this.departmentDao.countSubDepartment(departmentId);
        if (subDepartmentNum > 0) {
            return ResponseDTO.userErrorParam((String)"\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u90e8\u95e8");
        }
        int employeeNum = this.employeeDao.countByDepartmentId(departmentId);
        if (employeeNum > 0) {
            return ResponseDTO.userErrorParam((String)"\u8bf7\u5148\u5220\u9664\u90e8\u95e8\u5458\u5de5");
        }
        this.departmentDao.deleteById((Serializable)departmentId);
        this.clearCache();
        return ResponseDTO.ok();
    }

    private void clearCache() {
        this.departmentCacheManager.clearCache();
    }

    public ResponseDTO<List<DepartmentTreeVO>> departmentTree() {
        List treeVOList = this.departmentCacheManager.getDepartmentTree();
        return ResponseDTO.ok((Object)treeVOList);
    }

    public List<Long> selfAndChildrenIdList(Long departmentId) {
        return this.departmentCacheManager.getDepartmentSelfAndChildren(departmentId);
    }

    public List<DepartmentVO> listAll() {
        return this.departmentCacheManager.getDepartmentList();
    }

    public DepartmentVO getDepartmentById(Long departmentId) {
        return (DepartmentVO)this.departmentCacheManager.getDepartmentMap().get(departmentId);
    }

    public String getDepartmentPath(Long departmentId) {
        return (String)this.departmentCacheManager.getDepartmentPathMap().get(departmentId);
    }

    public List<DepartmentVO> queryAllParentDepartment(Long departmentId) {
        ArrayList<DepartmentVO> list = new ArrayList<DepartmentVO>();
        Map departmentMap = this.departmentCacheManager.getDepartmentMap();
        DepartmentVO departmentVO = (DepartmentVO)departmentMap.get(departmentId);
        while (departmentVO != null) {
            list.add(departmentVO);
            departmentVO = (DepartmentVO)departmentMap.get(departmentVO.getParentId());
        }
        Collections.reverse(list);
        return list;
    }

    public List<Long> queryAllParentDepartmentIdList(Long departmentId) {
        ArrayList<Long> list = new ArrayList<Long>();
        Map departmentMap = this.departmentCacheManager.getDepartmentMap();
        DepartmentVO departmentVO = (DepartmentVO)departmentMap.get(departmentId);
        while (departmentVO != null) {
            list.add(departmentVO.getDepartmentId());
            departmentVO = (DepartmentVO)departmentMap.get(departmentVO.getParentId());
        }
        Collections.reverse(list);
        return list;
    }
}

