/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.employee.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeAddForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeBatchUpdateDepartmentForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeQueryForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdateAvatarForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdateForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdatePasswordForm;
import net.lab1024.sa.admin.module.system.employee.domain.vo.EmployeeVO;
import net.lab1024.sa.admin.module.system.employee.service.EmployeeService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u5458\u5de5\u7ba1\u7406")
public class EmployeeController {
    @Resource
    private EmployeeService employeeService;

    @PostMapping(value={"/employee/query"})
    @Operation(summary="\u5458\u5de5\u7ba1\u7406\u67e5\u8be2 @author \u5353\u5927")
    public ResponseDTO<PageResult<EmployeeVO>> query(@Valid @RequestBody EmployeeQueryForm query) {
        return this.employeeService.queryEmployee(query);
    }

    @Operation(summary="\u6dfb\u52a0\u5458\u5de5(\u8fd4\u56de\u6dfb\u52a0\u5458\u5de5\u7684\u5bc6\u7801) @author \u5353\u5927")
    @PostMapping(value={"/employee/add"})
    @SaCheckPermission(value={"system:employee:add"})
    public ResponseDTO<String> addEmployee(@Valid @RequestBody EmployeeAddForm employeeAddForm) {
        return this.employeeService.addEmployee(employeeAddForm);
    }

    @Operation(summary="\u66f4\u65b0\u5458\u5de5 @author \u5353\u5927")
    @PostMapping(value={"/employee/update"})
    @SaCheckPermission(value={"system:employee:update"})
    public ResponseDTO<String> updateEmployee(@Valid @RequestBody EmployeeUpdateForm employeeUpdateForm) {
        return this.employeeService.updateEmployee(employeeUpdateForm);
    }

    @Operation(summary="\u66f4\u65b0\u767b\u5f55\u4eba\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/employee/update/login"})
    public ResponseDTO<String> updateByLogin(@Valid @RequestBody EmployeeUpdateForm employeeUpdateForm) {
        employeeUpdateForm.setEmployeeId(SmartRequestUtil.getRequestUserId());
        return this.employeeService.updateEmployee(employeeUpdateForm);
    }

    @Operation(summary="\u66f4\u65b0\u767b\u5f55\u4eba\u5934\u50cf @author \u5584\u9038")
    @PostMapping(value={"/employee/update/avatar"})
    public ResponseDTO<String> updateAvatar(@Valid @RequestBody EmployeeUpdateAvatarForm employeeUpdateAvatarForm) {
        employeeUpdateAvatarForm.setEmployeeId(SmartRequestUtil.getRequestUserId());
        return this.employeeService.updateAvatar(employeeUpdateAvatarForm);
    }

    @Operation(summary="\u66f4\u65b0\u5458\u5de5\u7981\u7528/\u542f\u7528\u72b6\u6001 @author \u5353\u5927")
    @GetMapping(value={"/employee/update/disabled/{employeeId}"})
    @SaCheckPermission(value={"system:employee:disabled"})
    public ResponseDTO<String> updateDisableFlag(@PathVariable Long employeeId) {
        return this.employeeService.updateDisableFlag(employeeId);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u5458\u5de5 @author \u5353\u5927")
    @PostMapping(value={"/employee/update/batch/delete"})
    @SaCheckPermission(value={"system:employee:delete"})
    public ResponseDTO<String> batchUpdateDeleteFlag(@RequestBody List<Long> employeeIdList) {
        return this.employeeService.batchUpdateDeleteFlag(employeeIdList);
    }

    @Operation(summary="\u6279\u91cf\u8c03\u6574\u5458\u5de5\u90e8\u95e8 @author \u5353\u5927")
    @PostMapping(value={"/employee/update/batch/department"})
    @SaCheckPermission(value={"system:employee:department:update"})
    public ResponseDTO<String> batchUpdateDepartment(@Valid @RequestBody EmployeeBatchUpdateDepartmentForm batchUpdateDepartmentForm) {
        return this.employeeService.batchUpdateDepartment(batchUpdateDepartmentForm);
    }

    @Operation(summary="\u4fee\u6539\u5bc6\u7801 @author \u5353\u5927")
    @PostMapping(value={"/employee/update/password"})
    public ResponseDTO<String> updatePassword(@Valid @RequestBody EmployeeUpdatePasswordForm updatePasswordForm) {
        updatePasswordForm.setEmployeeId(SmartRequestUtil.getRequestUserId());
        return this.employeeService.updatePassword(updatePasswordForm);
    }

    @Operation(summary="\u91cd\u7f6e\u5458\u5de5\u5bc6\u7801 @author \u5353\u5927")
    @GetMapping(value={"/employee/update/password/reset/{employeeId}"})
    @SaCheckPermission(value={"system:employee:password:reset"})
    public ResponseDTO<String> resetPassword(@PathVariable Integer employeeId) {
        return this.employeeService.resetPassword(employeeId);
    }

    @Operation(summary="\u67e5\u8be2\u5458\u5de5-\u6839\u636e\u90e8\u95e8id @author \u5353\u5927")
    @GetMapping(value={"/employee/getAllEmployeeByDepartmentId/{departmentId}"})
    public ResponseDTO<List<EmployeeVO>> getAllEmployeeByDepartmentId(@PathVariable Long departmentId) {
        return this.employeeService.getAllEmployeeByDepartmentId(departmentId, Boolean.FALSE);
    }

    @Operation(summary="\u67e5\u8be2\u6240\u6709\u5458\u5de5 @author \u5353\u5927")
    @GetMapping(value={"/employee/queryAll"})
    public ResponseDTO<List<EmployeeVO>> queryAllEmployee(@RequestParam(value="disabledFlag", required=false) Boolean disabledFlag) {
        return this.employeeService.queryAllEmployee(disabledFlag);
    }
}

