/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.employee.manager;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.employee.dao.EmployeeDao;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.admin.module.system.role.dao.RoleEmployeeDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleEmployeeEntity;
import net.lab1024.sa.admin.module.system.role.service.RoleEmployeeService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeManager
extends ServiceImpl<EmployeeDao, EmployeeEntity> {
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private RoleEmployeeService roleEmployeeService;
    @Resource
    private RoleEmployeeDao roleEmployeeDao;

    @Transactional(rollbackFor={Throwable.class})
    public void saveEmployee(EmployeeEntity employee, List<Long> roleIdList) {
        this.employeeDao.insert((Object)employee);
        if (CollectionUtils.isNotEmpty(roleIdList)) {
            List roleEmployeeList = roleIdList.stream().map(e -> new RoleEmployeeEntity(e, employee.getEmployeeId())).collect(Collectors.toList());
            this.roleEmployeeService.batchInsert(roleEmployeeList);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateEmployee(EmployeeEntity employee, List<Long> roleIdList) {
        this.employeeDao.updateById((Object)employee);
        if (CollectionUtils.isNotEmpty(roleIdList)) {
            List roleEmployeeList = roleIdList.stream().map(e -> new RoleEmployeeEntity(e, employee.getEmployeeId())).collect(Collectors.toList());
            this.updateEmployeeRole(employee.getEmployeeId(), roleEmployeeList);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateEmployeeRole(Long employeeId, List<RoleEmployeeEntity> roleEmployeeList) {
        this.roleEmployeeDao.deleteByEmployeeId(employeeId);
        if (CollectionUtils.isNotEmpty(roleEmployeeList)) {
            this.roleEmployeeService.batchInsert(roleEmployeeList);
        }
    }
}

