/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.employee.service;

import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.department.dao.DepartmentDao;
import net.lab1024.sa.admin.module.system.department.domain.entity.DepartmentEntity;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.admin.module.system.employee.dao.EmployeeDao;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeAddForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeBatchUpdateDepartmentForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeQueryForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdateAvatarForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdateForm;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeUpdatePasswordForm;
import net.lab1024.sa.admin.module.system.employee.domain.vo.EmployeeVO;
import net.lab1024.sa.admin.module.system.employee.manager.EmployeeManager;
import net.lab1024.sa.admin.module.system.login.service.LoginService;
import net.lab1024.sa.admin.module.system.position.dao.PositionDao;
import net.lab1024.sa.admin.module.system.position.domain.entity.PositionEntity;
import net.lab1024.sa.admin.module.system.role.dao.RoleEmployeeDao;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleEmployeeVO;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.enumeration.UserTypeEnum;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import net.lab1024.sa.base.module.support.securityprotect.service.ProtectPasswordService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EmployeeService {
    private static final String PASSWORD_SALT_FORMAT = "smart_%s_admin_$^&*";
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private EmployeeManager employeeManager;
    @Resource
    private RoleEmployeeDao roleEmployeeDao;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private ProtectPasswordService protectPasswordService;
    @Resource
    @Lazy
    private LoginService loginService;
    @Resource
    private PositionDao positionDao;
    @Resource
    private ProtectPasswordService profectPasswordService;

    public EmployeeEntity getById(Long employeeId) {
        return (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
    }

    public ResponseDTO<PageResult<EmployeeVO>> queryEmployee(EmployeeQueryForm employeeQueryForm) {
        List employeeList;
        employeeQueryForm.setDeletedFlag(Boolean.valueOf(false));
        Page pageParam = SmartPageUtil.convert2PageQuery((PageParam)employeeQueryForm);
        ArrayList departmentIdList = new ArrayList();
        if (employeeQueryForm.getDepartmentId() != null) {
            departmentIdList.addAll(this.departmentService.selfAndChildrenIdList(employeeQueryForm.getDepartmentId()));
        }
        if (CollectionUtils.isEmpty((Collection)(employeeList = this.employeeDao.queryEmployee(pageParam, employeeQueryForm, departmentIdList)))) {
            PageResult pageResult = SmartPageUtil.convert2PageResult((Page)pageParam, (List)employeeList);
            return ResponseDTO.ok((Object)pageResult);
        }
        List employeeIdList = employeeList.stream().map(EmployeeVO::getEmployeeId).collect(Collectors.toList());
        List roleEmployeeEntityList = employeeIdList.isEmpty() ? Collections.emptyList() : this.roleEmployeeDao.selectRoleByEmployeeIdList(employeeIdList);
        Map employeeRoleIdListMap = roleEmployeeEntityList.stream().collect(Collectors.groupingBy(RoleEmployeeVO::getEmployeeId, Collectors.mapping(RoleEmployeeVO::getRoleId, Collectors.toList())));
        Map employeeRoleNameListMap = roleEmployeeEntityList.stream().collect(Collectors.groupingBy(RoleEmployeeVO::getEmployeeId, Collectors.mapping(RoleEmployeeVO::getRoleName, Collectors.toList())));
        List positionIdList = employeeList.stream().map(EmployeeVO::getPositionId).filter(Objects::nonNull).collect(Collectors.toList());
        List positionEntityList = positionIdList.isEmpty() ? Collections.emptyList() : this.positionDao.selectBatchIds(positionIdList);
        Map<Long, String> positionNameMap = positionEntityList.stream().collect(Collectors.toMap(PositionEntity::getPositionId, PositionEntity::getPositionName));
        employeeList.forEach(e -> {
            e.setRoleIdList((List)employeeRoleIdListMap.getOrDefault(e.getEmployeeId(), Lists.newArrayList()));
            e.setRoleNameList((List)employeeRoleNameListMap.getOrDefault(e.getEmployeeId(), Lists.newArrayList()));
            e.setDepartmentName(this.departmentService.getDepartmentPath(e.getDepartmentId()));
            e.setPositionName((String)positionNameMap.get(e.getPositionId()));
        });
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)pageParam, (List)employeeList);
        return ResponseDTO.ok((Object)pageResult);
    }

    public synchronized ResponseDTO<String> addEmployee(EmployeeAddForm employeeAddForm) {
        EmployeeEntity employeeEntity = this.employeeDao.getByLoginName(employeeAddForm.getLoginName(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u91cd\u590d");
        }
        employeeEntity = this.employeeDao.getByActualName(employeeAddForm.getActualName(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u59d3\u540d\u91cd\u590d");
        }
        employeeEntity = this.employeeDao.getByPhone(employeeAddForm.getPhone(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        Long departmentId = employeeAddForm.getDepartmentId();
        DepartmentEntity department = (DepartmentEntity)this.departmentDao.selectById((Serializable)departmentId);
        if (department == null) {
            return ResponseDTO.userErrorParam((String)"\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        EmployeeEntity entity = (EmployeeEntity)SmartBeanUtil.copy((Object)employeeAddForm, EmployeeEntity.class);
        String password = this.protectPasswordService.randomPassword();
        entity.setLoginPwd(EmployeeService.getEncryptPwd((String)password));
        entity.setDeletedFlag(Boolean.FALSE);
        this.employeeManager.saveEmployee(entity, employeeAddForm.getRoleIdList());
        return ResponseDTO.ok((Object)password);
    }

    public synchronized ResponseDTO<String> addEmployeeByPassword(EmployeeAddForm employeeAddForm, String password) {
        EmployeeEntity employeeEntity = this.employeeDao.getByLoginName(employeeAddForm.getLoginName(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u91cd\u590d");
        }
        employeeEntity = this.employeeDao.getByActualName(employeeAddForm.getActualName(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u6635\u79f0\u91cd\u590d");
        }
        employeeEntity = this.employeeDao.getByPhone(employeeAddForm.getPhone(), null);
        if (null != employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        Long departmentId = employeeAddForm.getDepartmentId();
        DepartmentEntity department = (DepartmentEntity)this.departmentDao.selectById((Serializable)departmentId);
        if (department == null) {
            return ResponseDTO.userErrorParam((String)"\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        EmployeeEntity entity = (EmployeeEntity)SmartBeanUtil.copy((Object)employeeAddForm, EmployeeEntity.class);
        String requestPassword = this.profectPasswordService.decryptPassword(password);
        entity.setLoginPwd(EmployeeService.getEncryptPwd((String)requestPassword));
        entity.setEmployeeId(Long.valueOf(2L));
        entity.setDeletedFlag(Boolean.FALSE);
        System.out.println(entity);
        this.employeeManager.saveEmployee(entity, employeeAddForm.getRoleIdList());
        return ResponseDTO.ok((Object)password);
    }

    public synchronized ResponseDTO<String> updateEmployee(EmployeeUpdateForm employeeUpdateForm) {
        Long employeeId = employeeUpdateForm.getEmployeeId();
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        if (null == employeeEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        Long departmentId = employeeUpdateForm.getDepartmentId();
        DepartmentEntity departmentEntity = (DepartmentEntity)this.departmentDao.selectById((Serializable)departmentId);
        if (departmentEntity == null) {
            return ResponseDTO.userErrorParam((String)"\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        EmployeeEntity existEntity = this.employeeDao.getByLoginName(employeeUpdateForm.getLoginName(), null);
        if (null != existEntity && !Objects.equals(existEntity.getEmployeeId(), employeeId)) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u91cd\u590d");
        }
        existEntity = this.employeeDao.getByPhone(employeeUpdateForm.getPhone(), null);
        if (null != existEntity && !Objects.equals(existEntity.getEmployeeId(), employeeId)) {
            return ResponseDTO.userErrorParam((String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        existEntity = this.employeeDao.getByActualName(employeeUpdateForm.getActualName(), null);
        if (null != existEntity && !Objects.equals(existEntity.getEmployeeId(), employeeId)) {
            return ResponseDTO.userErrorParam((String)"\u59d3\u540d\u91cd\u590d");
        }
        EmployeeEntity entity = (EmployeeEntity)SmartBeanUtil.copy((Object)employeeUpdateForm, EmployeeEntity.class);
        entity.setLoginPwd(null);
        entity.setPayUser(null);
        this.employeeManager.updateEmployee(entity, employeeUpdateForm.getRoleIdList());
        this.loginService.clearLoginEmployeeCache(employeeId);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> updateAvatar(EmployeeUpdateAvatarForm employeeUpdateAvatarForm) {
        Long employeeId = employeeUpdateAvatarForm.getEmployeeId();
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        if (employeeEntity == null) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        EmployeeEntity updateEntity = new EmployeeEntity();
        updateEntity.setEmployeeId(employeeId);
        updateEntity.setAvatar(employeeUpdateAvatarForm.getAvatar());
        this.employeeDao.updateById((Object)updateEntity);
        this.loginService.clearLoginEmployeeCache(employeeId);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> updateDisableFlag(Long employeeId) {
        if (null == employeeId) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        if (null == employeeEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        this.employeeDao.updateDisableFlag(employeeId, Boolean.valueOf(employeeEntity.getDisabledFlag() == false));
        if (employeeEntity.getDisabledFlag().booleanValue()) {
            StpUtil.logout((Object)(UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeId));
        }
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchUpdateDeleteFlag(List<Long> employeeIdList) {
        if (CollectionUtils.isEmpty(employeeIdList)) {
            return ResponseDTO.ok();
        }
        List employeeEntityList = this.employeeManager.listByIds(employeeIdList);
        if (CollectionUtils.isEmpty((Collection)employeeEntityList)) {
            return ResponseDTO.ok();
        }
        List deleteList = employeeIdList.stream().map(e -> {
            EmployeeEntity updateEmployee = new EmployeeEntity();
            updateEmployee.setEmployeeId(e);
            updateEmployee.setDeletedFlag(Boolean.valueOf(true));
            return updateEmployee;
        }).collect(Collectors.toList());
        this.employeeManager.updateBatchById(deleteList);
        for (Long employeeId : employeeIdList) {
            StpUtil.logout((Object)(UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeId));
        }
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchUpdateDepartment(EmployeeBatchUpdateDepartmentForm batchUpdateDepartmentForm) {
        List employeeIdList = batchUpdateDepartmentForm.getEmployeeIdList();
        List employeeEntityList = this.employeeDao.selectBatchIds((Collection)employeeIdList);
        if (employeeIdList.size() != employeeEntityList.size()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        List updateList = employeeIdList.stream().map(e -> {
            EmployeeEntity updateEmployee = new EmployeeEntity();
            updateEmployee.setEmployeeId(e);
            updateEmployee.setDepartmentId(batchUpdateDepartmentForm.getDepartmentId());
            return updateEmployee;
        }).collect(Collectors.toList());
        this.employeeManager.updateBatchById(updateList);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> updatePassword(EmployeeUpdatePasswordForm updatePasswordForm) {
        Long employeeId = updatePasswordForm.getEmployeeId();
        EmployeeEntity employeeEntity = (EmployeeEntity)this.employeeDao.selectById((Serializable)employeeId);
        if (employeeEntity == null) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        String encryptPwd = EmployeeService.getEncryptPwd((String)updatePasswordForm.getOldPassword());
        if (!Objects.equals(encryptPwd, employeeEntity.getLoginPwd())) {
            return ResponseDTO.userErrorParam((String)"\u539f\u5bc6\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String newPassword = updatePasswordForm.getNewPassword();
        if (Objects.equals(updatePasswordForm.getOldPassword(), newPassword)) {
            return ResponseDTO.userErrorParam((String)"\u65b0\u5bc6\u7801\u4e0e\u539f\u59cb\u5bc6\u7801\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        ResponseDTO validatePassComplexity = this.protectPasswordService.validatePassComplexity(newPassword);
        if (!validatePassComplexity.getOk().booleanValue()) {
            return validatePassComplexity;
        }
        EmployeeEntity updateEntity = new EmployeeEntity();
        updateEntity.setEmployeeId(employeeId);
        updateEntity.setLoginPwd(EmployeeService.getEncryptPwd((String)newPassword));
        this.employeeDao.updateById((Object)updateEntity);
        return ResponseDTO.ok();
    }

    public ResponseDTO<List<EmployeeVO>> getAllEmployeeByDepartmentId(Long departmentId, Boolean disabledFlag) {
        List employeeEntityList = this.employeeDao.selectByDepartmentId(departmentId, disabledFlag);
        if (disabledFlag != null) {
            employeeEntityList = employeeEntityList.stream().filter(e -> e.getDisabledFlag().equals(disabledFlag)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)employeeEntityList)) {
            return ResponseDTO.ok(Collections.emptyList());
        }
        DepartmentVO department = this.departmentService.getDepartmentById(departmentId);
        List voList = employeeEntityList.stream().map(e -> {
            EmployeeVO employeeVO = (EmployeeVO)SmartBeanUtil.copy((Object)e, EmployeeVO.class);
            if (department != null) {
                employeeVO.setDepartmentName(department.getName());
            }
            return employeeVO;
        }).collect(Collectors.toList());
        return ResponseDTO.ok(voList);
    }

    public ResponseDTO<String> resetPassword(Integer employeeId) {
        String password = this.protectPasswordService.randomPassword();
        this.employeeDao.updatePassword(employeeId, EmployeeService.getEncryptPwd((String)password));
        return ResponseDTO.ok((Object)password);
    }

    public static String getEncryptPwd(String password) {
        return DigestUtils.md5Hex((String)String.format("smart_%s_admin_$^&*", password));
    }

    public ResponseDTO<List<EmployeeVO>> queryAllEmployee(Boolean disabledFlag) {
        List employeeList = this.employeeDao.selectEmployeeByDisabledAndDeleted(disabledFlag, Boolean.FALSE);
        return ResponseDTO.ok((Object)employeeList);
    }

    public EmployeeEntity getByLoginName(String loginName) {
        return this.employeeDao.getByLoginName(loginName, null);
    }

    public EmployeeEntity getByLoginPhone(String loginPhone) {
        return this.employeeDao.getByPhone(loginPhone, null);
    }
}

